/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.entry.filtering;

import java.util.Objects;
import java.util.function.Function;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Experimental
public interface FilteringRuleType<T extends FilteringRule<?>> {
    public static CompoundTag save(FilteringRule<?> rule, CompoundTag tag) {
        tag.m_128359_("id", rule.getType().getId().toString());
        tag.m_128365_("rule", (Tag)rule.getType().saveTo(rule, new CompoundTag()));
        return tag;
    }

    public CompoundTag saveTo(T var1, CompoundTag var2);

    @Nullable
    public static FilteringRule<?> read(CompoundTag tag) {
        FilteringRuleType<?> type = FilteringRuleTypeRegistry.getInstance().get(ResourceLocation.m_135820_((String)tag.m_128461_("id")));
        if (type == null) {
            return null;
        }
        return type.readFrom(tag.m_128469_("rule"));
    }

    public T readFrom(CompoundTag var1);

    @Nullable
    default public Function<Screen, Screen> createEntryScreen(T rule) {
        return null;
    }

    default public Component getTitle(T rule) {
        return Component.m_130674_((String)this.getId().toString());
    }

    default public Component getSubtitle(T rule) {
        return Component.m_130674_(null);
    }

    default public ResourceLocation getId() {
        return Objects.requireNonNull(FilteringRuleTypeRegistry.getInstance().getId(this), "Id of " + this);
    }

    public T createNew();

    public boolean isSingular();
}

