/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.options.preview;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.options.AllREIConfigOptions;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TooltipPreviewer {
    public static WidgetWithBounds create(ConfigAccess access, int width, @Nullable IntSupplier height) {
        Rectangle bounds = new Rectangle();
        return Widgets.withBounds(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            EntryStack<ItemStack> stack = EntryStacks.of((ItemLike)Items.f_42647_);
            boolean appendModNames = access.get(AllREIConfigOptions.APPEND_MOD_NAMES);
            boolean appendFavorites = access.get(AllREIConfigOptions.APPEND_FAVORITES_HINT);
            ArrayList<Tooltip.Entry> entries = new ArrayList<Tooltip.Entry>();
            entries.add(Tooltip.entry((Component)new TranslatableComponent("block.minecraft.oak_planks")));
            if (appendModNames) {
                entries.add(Tooltip.entry((Component)new TextComponent("Minecraft").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
            }
            if (appendFavorites) {
                String name = ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString();
                entries.addAll(Stream.of(I18n.m_118938_((String)"text.rei.favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(TextComponent::new).map(Tooltip::entry).toList());
            }
            List components = entries.stream().flatMap(entry -> Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)entry.getAsText(), width - 12 - 4).stream()).toList();
            int minWidth = components.stream().mapToInt(component -> Minecraft.m_91087_().f_91062_.m_92724_(component)).max().orElse(0) + 4;
            int minHeight = components.stream().mapToInt(component -> components.get(0) == component && components.size() >= 2 ? 12 : 10).sum() + 4;
            int tX = Math.max(6, (width - minWidth) / 2);
            int tWidth = Math.min(width - 12, minWidth);
            int tY = 28;
            int tHeight = Math.min(minHeight, height == null ? 100000 : height.getAsInt() - tY - 4);
            matrices.m_85836_();
            matrices.m_85837_(0.0, height == null ? 4.0 : (double)Math.max(0, (height.getAsInt() - (tY + tHeight)) / 2), 400.0);
            bounds.setSize(width, height == null ? tY + tHeight + 12 : height.getAsInt());
            stack.getRenderer().render(stack, matrices, new Rectangle(width / 2 - 12, 0, 24, 24), mouseX, mouseY, delta);
            matrices.m_85837_(0.0, 0.0, -400.0);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tesselator.m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            Matrix4f matrix4f = matrices.m_85850_().m_85861_();
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX - 3, tY - 4, tX + tWidth + 3, tY - 3, 400, -267386864, -267386864);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX - 3, tY + tHeight + 3, tX + tWidth + 3, tY + tHeight + 4, 400, -267386864, -267386864);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX - 3, tY - 3, tX + tWidth + 3, tY + tHeight + 3, 400, -267386864, -267386864);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX - 4, tY - 3, tX - 3, tY + tHeight + 3, 400, -267386864, -267386864);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX + tWidth + 3, tY - 3, tX + tWidth + 4, tY + tHeight + 3, 400, -267386864, -267386864);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX - 3, tY - 3 + 1, tX - 3 + 1, tY + tHeight + 3 - 1, 400, 0x505000FF, 1344798847);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX + tWidth + 2, tY - 3 + 1, tX + tWidth + 3, tY + tHeight + 3 - 1, 400, 0x505000FF, 1344798847);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX - 3, tY - 3, tX + tWidth + 3, tY - 3 + 1, 400, 0x505000FF, 0x505000FF);
            TooltipPreviewer.fillGradient(matrix4f, bufferBuilder, tX - 3, tY + tHeight + 2, tX + tWidth + 3, tY + tHeight + 3, 400, 1344798847, 1344798847);
            RenderSystem.m_69482_();
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
            RenderSystem.m_69461_();
            RenderSystem.m_69493_();
            matrices.m_85837_(0.0, 0.0, 400.0);
            for (int i = 0; i < components.size(); ++i) {
                Minecraft.m_91087_().f_91062_.m_92877_(matrices, (FormattedCharSequence)components.get(i), (float)(tX + 2), (float)(tY + 2), -1);
                tY += 10 + (i == 0 ? 2 : 0);
            }
            matrices.m_85849_();
        }), bounds);
    }

    private static void fillGradient(Matrix4f pose, BufferBuilder builder, int x1, int y1, int x2, int y2, int blitOffset, int color1, int color2) {
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float g = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float h = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float i = (float)(color1 & 0xFF) / 255.0f;
        float j = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float k = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float l = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float m = (float)(color2 & 0xFF) / 255.0f;
        builder.m_85982_(pose, (float)x2, (float)y1, (float)blitOffset).m_85950_(g, h, i, f).m_5752_();
        builder.m_85982_(pose, (float)x1, (float)y1, (float)blitOffset).m_85950_(g, h, i, f).m_5752_();
        builder.m_85982_(pose, (float)x1, (float)y2, (float)blitOffset).m_85950_(k, l, m, j).m_5752_();
        builder.m_85982_(pose, (float)x2, (float)y2, (float)blitOffset).m_85950_(k, l, m, j).m_5752_();
    }
}

