/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.craftable;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerMeta;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.craftable.CraftableFilter;
import me.shedaniel.rei.impl.client.registry.display.DisplayCache;
import me.shedaniel.rei.impl.client.registry.display.DisplayRegistryImpl;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import me.shedaniel.rei.plugin.autocrafting.DefaultCategoryHandler;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CraftableFilterCalculator
implements Predicate<HashedEntryStackWrapper> {
    private final Supplier<DisplayCache> displayCache = Suppliers.memoize(() -> ((DisplayRegistryImpl)DisplayRegistry.getInstance()).displaysHolder().cache());
    private Set<Display> checkedCraftableDisplays = Collections.synchronizedSet(new ReferenceOpenHashSet());
    private Set<Display> checkedUncraftableDisplays = Collections.synchronizedSet(new ReferenceOpenHashSet());
    private LongSet checkedCraftableEntries = LongSets.synchronize((LongSet)new LongOpenHashSet());

    @Override
    public boolean test(HashedEntryStackWrapper wrapper) {
        EntryStack<?> stack = wrapper.unwrap();
        if (stack.getType() != VanillaEntryTypes.ITEM || stack.isEmpty()) {
            return false;
        }
        if (this.checkedCraftableEntries.contains(wrapper.hashExact())) {
            return true;
        }
        DisplayCache cache = this.displayCache.get();
        for (Display display : cache.getAllDisplaysByOutputs(List.of(stack))) {
            if (!this.checkCraftableCachedByResult(display)) continue;
            return true;
        }
        return false;
    }

    private boolean checkCraftableCachedByDisplay(Display display) {
        if (this.checkedCraftableDisplays.contains(display)) {
            return true;
        }
        if (this.checkedUncraftableDisplays.contains(display)) {
            return false;
        }
        boolean checkCraftable = this.checkCraftable(display);
        if (checkCraftable) {
            this.checkedCraftableDisplays.add(display);
        } else {
            this.checkedUncraftableDisplays.add(display);
        }
        return checkCraftable;
    }

    private boolean checkCraftableCachedByResult(Display display) {
        boolean checkCraftable = this.checkCraftableCachedByDisplay(display);
        if (checkCraftable) {
            for (EntryIngredient ingredient : display.getOutputEntries()) {
                for (EntryStack stack : ingredient) {
                    if (stack.getType() != VanillaEntryTypes.ITEM || stack.isEmpty()) continue;
                    this.checkedCraftableEntries.add(EntryStacks.hashExact(stack));
                }
            }
        }
        return checkCraftable;
    }

    private boolean checkCraftable(Display display) {
        @Nullable Long2LongMap ingredients = this.chooseHandler(display);
        if (ingredients == null) {
            return false;
        }
        List<EntryIngredient> requiredEntries = display.getRequiredEntries();
        if (requiredEntries.isEmpty()) {
            return false;
        }
        int slotsCraftable = 0;
        boolean containsNonEmpty = false;
        block0: for (EntryIngredient slot : requiredEntries) {
            if (slot.isEmpty()) {
                ++slotsCraftable;
                continue;
            }
            for (EntryStack slotPossible : slot) {
                if (slotPossible.getType() != VanillaEntryTypes.ITEM) continue;
                ItemStack stack = (ItemStack)slotPossible.castValue();
                long hashFuzzy = EntryStacks.hashFuzzy(slotPossible);
                long availableAmount = ingredients.get(hashFuzzy);
                if (availableAmount < (long)stack.m_41613_()) continue;
                ingredients.put(hashFuzzy, availableAmount - (long)stack.m_41613_());
                containsNonEmpty = true;
                ++slotsCraftable;
                continue block0;
            }
        }
        return slotsCraftable == requiredEntries.size() && containsNonEmpty;
    }

    @Nullable
    public Long2LongMap chooseHandler(Display display) {
        TransferHandler.ApplicabilityResult result;
        TransferHandler.Context transferContext = TransferHandler.Context.create(false, false, REIRuntime.getInstance().getPreviousContainerScreen(), display);
        DefaultCategoryHandler legacyHandler = null;
        for (TransferHandler handler : TransferHandlerRegistry.getInstance()) {
            if (handler instanceof DefaultCategoryHandler) {
                legacyHandler = (DefaultCategoryHandler)handler;
                continue;
            }
            TransferHandler.ApplicabilityResult result2 = handler.checkApplicable(transferContext);
            if (!result2.isSuccessful()) continue;
            if (handler instanceof TransferHandlerMeta) {
                return CraftableFilterCalculator.extractIngredients(((TransferHandlerMeta)((Object)handler)).getAvailableIngredients(transferContext));
            }
            return CraftableFilter.INSTANCE.getInvStacks();
        }
        if (legacyHandler != null && (result = legacyHandler.checkApplicable(transferContext)).isSuccessful()) {
            return CraftableFilter.INSTANCE.getInvStacks();
        }
        return null;
    }

    private static Long2LongMap extractIngredients(Iterable<ItemStack> ingredients) {
        EntryDefinition<ItemStack> definition = VanillaEntryTypes.ITEM.getDefinition();
        Long2LongOpenHashMap map = new Long2LongOpenHashMap();
        for (ItemStack stack : ingredients) {
            if (stack.m_41619_()) continue;
            long hash = definition.hash(null, stack, ComparisonContext.FUZZY);
            long newCount = map.getOrDefault(hash, 0L) + (long)Math.max(0, stack.m_41613_());
            map.put(hash, newCount);
        }
        return map;
    }
}

