/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.clothconfig2.impl.EasingMethod;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.config.DisplayScreenType;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class UncertainDisplayViewingScreen
extends Screen {
    private static final ResourceLocation DEFAULT = new ResourceLocation("roughlyenoughitems", "textures/gui/screenshot_default.png");
    private static final ResourceLocation COMPOSITE = new ResourceLocation("roughlyenoughitems", "textures/gui/screenshot_composite.png");
    private final List<Widget> widgets = Lists.newArrayList();
    protected long start;
    protected long duration;
    private boolean isSet;
    private boolean original;
    private double frame = 0.0;
    private double target = 0.0;
    private BooleanConsumer callback;
    private Button button;
    private Screen parent;
    private boolean showTips;

    public UncertainDisplayViewingScreen(Screen parent, DisplayScreenType type, boolean showTips, BooleanConsumer callback) {
        super((Component)ImmutableTextComponent.EMPTY);
        if (type == DisplayScreenType.UNSET) {
            this.isSet = false;
            this.original = true;
        } else {
            this.isSet = true;
            this.original = type == DisplayScreenType.ORIGINAL;
            this.moveFrameTo(this.original ? 0.0 : 1.0, false, 0L);
        }
        this.callback = callback;
        this.parent = parent;
        this.showTips = showTips;
    }

    public final double clamp(double v) {
        return this.clamp(v, 30.0);
    }

    public final double clamp(double v, double clampExtension) {
        return Mth.m_14008_((double)v, (double)(-clampExtension), (double)(1.0 + clampExtension));
    }

    private void moveFrameTo(double value, boolean animated, long duration) {
        this.target = this.clamp(value);
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.frame = this.target;
        }
    }

    public void m_7856_() {
        this.m_6702_().clear();
        this.widgets.clear();
        this.button = Widgets.createButton(new Rectangle(this.f_96543_ / 2 - 100, this.f_96544_ - 40, 200, 20), NarratorChatListener.f_93310_).onRender((matrices, button) -> {
            button.setEnabled(this.isSet);
            button.setText((Component)new TranslatableComponent("gui.done"));
        }).onClick(button -> this.callback.accept(this.original));
        this._children().add((GuiEventListener)this.button);
        this.widgets.add(new ScreenTypeSelection(this.f_96543_ / 2 - 200 - 5, this.f_96544_ / 2 - 56 - 10, DisplayScreenType.ORIGINAL));
        this.widgets.add(Widgets.createLabel(new Point(this.f_96543_ / 2 - 200 - 5 + 104, this.f_96544_ / 2 - 56 + 115), (Component)new TranslatableComponent("config.roughlyenoughitems.recipeScreenType.original")).noShadow().color(-1124073473));
        this.widgets.add(new ScreenTypeSelection(this.f_96543_ / 2 + 5, this.f_96544_ / 2 - 56 - 10, DisplayScreenType.COMPOSITE));
        this.widgets.add(Widgets.createLabel(new Point(this.f_96543_ / 2 + 5 + 104, this.f_96544_ / 2 - 56 + 115), (Component)new TranslatableComponent("config.roughlyenoughitems.recipeScreenType.composite")).noShadow().color(-1124073473));
        this._children().addAll(this.widgets);
    }

    public List<GuiEventListener> _children() {
        return this.m_6702_();
    }

    public void m_6305_(PoseStack matrices, int int_1, int int_2, float float_1) {
        if (this.f_96541_.f_91073_ != null) {
            this.m_7333_(matrices);
        } else {
            this.m_93179_(matrices, 0, 0, this.f_96543_, this.f_96544_, -16777216, -16777216);
        }
        UncertainDisplayViewingScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)new TranslatableComponent("text.rei.recipe_screen_type.selection"), (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        Objects.requireNonNull(this.f_96547_);
        ScissorsHandler.INSTANCE.scissor(new Rectangle(0, 20 + 9 + 2, this.f_96543_, this.f_96544_ - 42));
        if (this.showTips) {
            float i = 32.0f;
            for (FormattedCharSequence s : this.f_96547_.m_92923_((FormattedText)new TranslatableComponent("text.rei.recipe_screen_type.selection.sub").m_130940_(ChatFormatting.GRAY), this.f_96543_ - 30)) {
                this.f_96547_.m_92744_(matrices, s, (float)(this.f_96543_ / 2 - this.f_96547_.m_92724_(s) / 2), i, -1);
                i += 10.0f;
            }
        }
        super.m_6305_(matrices, int_1, int_2, float_1);
        for (Widget widget : this.widgets) {
            widget.m_6305_(matrices, int_1, int_2, float_1);
        }
        if (this.isSet) {
            matrices.m_85836_();
            this.updateFramePosition(float_1);
            int x = (int)((double)(this.f_96543_ / 2 - 205) + 210.0 * this.frame);
            int y = this.f_96544_ / 2 - 56 - 10;
            this.m_93179_(matrices, x - 2, y - 4, x - 6 + 208, y - 4 + 2, -1778384897, -1778384897);
            this.m_93179_(matrices, x - 2, y - 4 + 126 - 2, x - 6 + 208, y - 4 + 126, -1778384897, -1778384897);
            this.m_93179_(matrices, x - 4, y - 4, x - 4 + 2, y - 4 + 126, -1778384897, -1778384897);
            this.m_93179_(matrices, x - 4 + 208 - 2, y - 4, x - 4 + 208, y - 4 + 126, -1778384897, -1778384897);
            matrices.m_85849_();
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.button.m_6305_(matrices, int_1, int_2, float_1);
    }

    private void updateFramePosition(float delta) {
        this.target = this.clamp(this.target);
        this.frame = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.frame, (double)this.target, (double)0.001f) ? this.ease(this.frame, this.target, Math.min((double)(System.currentTimeMillis() - this.start) / (double)this.duration * (double)delta * 3.0, 1.0)) : this.target;
    }

    private double ease(double start, double end, double amount) {
        return start + (end - start) * EasingMethod.EasingMethodImpl.LINEAR.apply(amount);
    }

    public boolean m_7933_(int int_1, int int_2, int int_3) {
        if (int_1 == 256 || this.f_96541_.f_91066_.f_92092_.m_90832_(int_1, int_2)) {
            Minecraft.m_91087_().m_91152_(this.parent);
            if (this.parent instanceof AbstractContainerScreen) {
                REIRuntime.getInstance().getOverlay().get().queueReloadOverlay();
            }
            return true;
        }
        return super.m_7933_(int_1, int_2, int_3);
    }

    public class ScreenTypeSelection
    extends WidgetWithBounds {
        private final DisplayScreenType type;
        private Rectangle bounds;

        public ScreenTypeSelection(int x, int y, DisplayScreenType type) {
            this.type = type;
            this.bounds = new Rectangle(x - 4 + 16, y - 4, 184, 128);
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        public void m_6305_(PoseStack matrices, int i, int i1, float delta) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)(this.type == DisplayScreenType.ORIGINAL ? DEFAULT : COMPOSITE));
            ScreenTypeSelection.m_93160_((PoseStack)matrices, (int)(this.bounds.x + (this.type == DisplayScreenType.ORIGINAL ? 8 : 4)), (int)(this.bounds.y + 4), (int)(this.bounds.width - 8), (int)(this.bounds.height - 8), (float)113.0f, (float)(this.type == DisplayScreenType.ORIGINAL ? 16.0f : 27.0f), (int)628, (int)426, (int)854, (int)480);
        }

        public boolean m_6375_(double double_1, double double_2, int int_1) {
            if (this.containsMouse(double_1, double_2)) {
                boolean bl = UncertainDisplayViewingScreen.this.original = this.type == DisplayScreenType.ORIGINAL;
                if (!UncertainDisplayViewingScreen.this.isSet) {
                    UncertainDisplayViewingScreen.this.moveFrameTo(UncertainDisplayViewingScreen.this.original ? 0.0 : 1.0, false, 0L);
                }
                UncertainDisplayViewingScreen.this.isSet = true;
                UncertainDisplayViewingScreen.this.moveFrameTo(UncertainDisplayViewingScreen.this.original ? 0.0 : 1.0, true, 500L);
                return true;
            }
            return false;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }
    }
}

