/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen.collapsible;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.collapsible.CollapsibleConfigManager;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.collapsible.CollapsibleEntryWidget;
import me.shedaniel.rei.impl.client.gui.screen.collapsible.selection.CustomCollapsibleEntrySelectionScreen;
import me.shedaniel.rei.impl.client.gui.screen.generic.OptionEntriesScreen;
import me.shedaniel.rei.impl.client.gui.widget.DynamicErrorFreeEntryListWidget;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsibleEntryRegistryImpl;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class CollapsibleEntriesScreen
extends Screen {
    private final Runnable onClose;
    private final CollapsibleConfigManager.CollapsibleConfigObject configObject;
    private final List<CollapsibleEntryWidget> widgets = new ArrayList<CollapsibleEntryWidget>();
    private ListWidget listWidget;
    private boolean dirty = true;

    public CollapsibleEntriesScreen(Runnable onClose, CollapsibleConfigManager.CollapsibleConfigObject configObject) {
        super((Component)new TranslatableComponent("text.rei.collapsible.entries.title"));
        this.onClose = onClose;
        this.configObject = configObject;
        this.prepareWidgets(configObject);
    }

    public void prepareWidgets(CollapsibleConfigManager.CollapsibleConfigObject configObject) {
        this.widgets.clear();
        for (CollapsibleConfigManager.CustomGroup customEntry : configObject.customGroups) {
            this.widgets.add(new CollapsibleEntryWidget(true, customEntry.id, (Component)new TextComponent(customEntry.name), CollectionUtils.filterAndMap(customEntry.stacks, EntryStackProvider::isValid, EntryStackProvider::provide), configObject, () -> {
                this.prepareWidgets(configObject);
                this.dirty = true;
            }));
        }
        CollapsibleEntryRegistryImpl collapsibleRegistry = (CollapsibleEntryRegistryImpl)CollapsibleEntryRegistry.getInstance();
        ListMultimap entries = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
        for (HashedEntryStackWrapper hashedEntryStackWrapper : ((EntryRegistryImpl)EntryRegistry.getInstance()).getFilteredList().getList()) {
            for (CollapsibleEntryRegistryImpl.Entry entry : collapsibleRegistry.getEntries()) {
                if (!entry.getMatcher().matches(hashedEntryStackWrapper.unwrap(), hashedEntryStackWrapper.hashExact())) continue;
                entries.put((Object)entry.getId(), hashedEntryStackWrapper.unwrap());
            }
        }
        for (CollapsibleEntryRegistryImpl.Entry entry : collapsibleRegistry.getEntries()) {
            this.widgets.add(new CollapsibleEntryWidget(false, entry.getId(), entry.getName(), entries.get((Object)entry.getId()), configObject, () -> {
                this.prepareWidgets(configObject);
                this.dirty = true;
            }));
        }
    }

    public void m_7856_() {
        super.m_7856_();
        MutableComponent backText = new TextComponent("\u21a9 ").m_7220_((Component)new TranslatableComponent("gui.back"));
        this.m_142416_((GuiEventListener)new Button(4, 4, this.f_96547_.m_92852_((FormattedText)backText) + 10, 20, (Component)backText, button -> this.m_7379_()));
        TextComponent addText = new TextComponent(" + ");
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 4 - 20, 4, 20, 20, (Component)addText, $ -> CollapsibleEntriesScreen.setupCustom(new ResourceLocation("custom:" + UUID.randomUUID()), "", new ArrayList(), this.configObject, () -> {
            this.prepareWidgets(this.configObject);
            this.dirty = true;
        })));
        this.listWidget = new ListWidget(this.f_96543_, this.f_96544_, 30);
        this.m_6702_().add(this.listWidget);
        this.dirty = true;
    }

    public static void setupCustom(final ResourceLocation id, final String name, final List<EntryStack<?>> stacks, final CollapsibleConfigManager.CollapsibleConfigObject configObject, final Runnable markDirty) {
        Minecraft.m_91087_().m_91152_((Screen)new OptionEntriesScreen((Component)new TranslatableComponent("text.rei.collapsible.entries.custom.title"), Minecraft.m_91087_().f_91080_){
            private OptionEntriesScreen.TextFieldListEntry entry;

            @Override
            public void addEntries(Consumer<OptionEntriesScreen.ListEntry> entryConsumer) {
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (FormattedText)new TranslatableComponent("text.rei.collapsible.entries.custom.id").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(" " + id).m_130940_(ChatFormatting.DARK_GRAY)));
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (FormattedText)new TranslatableComponent("text.rei.collapsible.entries.custom.name").m_130940_(ChatFormatting.GRAY));
                this.entry = new OptionEntriesScreen.TextFieldListEntry(this.f_96543_ - 36, widget -> {
                    widget.m_94199_(40);
                    if (this.entry != null) {
                        widget.m_94144_(this.entry.getWidget().m_94155_());
                    } else {
                        widget.m_94144_(name);
                    }
                });
                entryConsumer.accept(this.entry);
                this.addEmpty(entryConsumer, 10);
                entryConsumer.accept(new OptionEntriesScreen.ButtonListEntry(this.f_96543_ - 36, $ -> new TranslatableComponent("text.rei.collapsible.entries.custom.select"), ($, button) -> {
                    CustomCollapsibleEntrySelectionScreen screen = new CustomCollapsibleEntrySelectionScreen(stacks);
                    screen.parent = this.f_96541_.f_91080_;
                    this.f_96541_.m_91152_((Screen)screen);
                }));
            }

            @Override
            public void save() {
                configObject.customGroups.removeIf(customGroup -> customGroup.id.equals((Object)id));
                configObject.customGroups.add(new CollapsibleConfigManager.CustomGroup(id, this.entry.getWidget().m_94155_(), CollectionUtils.map(stacks, EntryStackProvider::ofStack)));
                markDirty.run();
            }
        });
    }

    public void m_6305_(PoseStack poses, int mouseX, int mouseY, float delta) {
        if (this.dirty) {
            this.listWidget.clear();
            for (CollapsibleEntryWidget widget : this.widgets) {
                this.listWidget.add(widget);
            }
            this.dirty = false;
        }
        this.listWidget.m_6305_(poses, mouseX, mouseY, delta);
        super.m_6305_(poses, mouseX, mouseY, delta);
        this.f_96547_.m_92763_(poses, this.f_96539_, (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f, 12.0f, -1);
        if (ConfigObject.getInstance().doDebugRenderTimeRequired()) {
            TextComponent debugText = new TextComponent(String.format("%s fps", this.f_96541_.f_90977_.split(" ")[0]));
            int stringWidth = this.f_96547_.m_92852_((FormattedText)debugText);
            int n = this.f_96541_.f_91080_.f_96543_ - stringWidth - 2;
            int n2 = this.f_96541_.f_91080_.f_96543_;
            Objects.requireNonNull(this.f_96547_);
            this.m_93179_(poses, n, 32, n2, 32 + 9 + 2, -16777216, -16777216);
            MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            poses.m_85836_();
            poses.m_85837_(0.0, 0.0, (double)this.m_93252_());
            Matrix4f matrix = poses.m_85850_().m_85861_();
            this.f_96547_.m_92733_(debugText.m_7532_(), (float)(this.f_96541_.f_91080_.f_96543_ - stringWidth), 34.0f, -1, false, matrix, (MultiBufferSource)immediate, false, 0, 0xF000F0);
            immediate.m_109911_();
            poses.m_85849_();
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        return this.listWidget.m_6050_(mouseX, mouseY, amount) || super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.listWidget.m_6375_(mouseX, mouseY, button) || super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.listWidget.m_7979_(mouseX, mouseY, button, deltaX, deltaY) || super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void m_7379_() {
        this.onClose.run();
    }

    private static class ListWidget
    extends Widget {
        private static final int PADDING = 6;
        private final int width;
        private final int height;
        private final int top;
        private final ScrollingContainer scroller = new ScrollingContainer(){

            public Rectangle getBounds() {
                return new Rectangle(0, top, width, height - top);
            }

            public int getMaxScrollHeight() {
                return this.getMaxScrollDist();
            }
        };
        private final List<CollapsibleEntryWidget>[] columns;
        private final List<CollapsibleEntryWidget> children = new ArrayList<CollapsibleEntryWidget>();

        public ListWidget(int width, int height, int top) {
            this.width = width;
            this.height = height;
            this.top = top;
            this.columns = new List[Math.max(1, (width - 12 - 6) / 136)];
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i] = new ArrayList<CollapsibleEntryWidget>();
            }
        }

        public void m_6305_(PoseStack poses, int mouseX, int mouseY, float delta) {
            this.scroller.updatePosition(delta);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            DynamicErrorFreeEntryListWidget.renderBackBackground(poses, buffer, tesselator, GuiComponent.f_93096_, 0, this.top, this.width, this.height, 0, 32);
            RenderSystem.m_69478_();
            RenderSystem.m_69411_((int)770, (int)771, (int)0, (int)1);
            RenderSystem.m_69472_();
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            Matrix4f matrix = poses.m_85850_().m_85861_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            buffer.m_85982_(matrix, 0.0f, (float)(this.top + 4), 0.0f).m_7421_(0.0f, 1.0f).m_193479_(0).m_5752_();
            buffer.m_85982_(matrix, (float)this.width, (float)(this.top + 4), 0.0f).m_7421_(1.0f, 1.0f).m_193479_(0).m_5752_();
            buffer.m_85982_(matrix, (float)this.width, (float)this.top, 0.0f).m_7421_(1.0f, 0.0f).m_193479_(-16777216).m_5752_();
            buffer.m_85982_(matrix, 0.0f, (float)this.top, 0.0f).m_7421_(0.0f, 0.0f).m_193479_(-16777216).m_5752_();
            tesselator.m_85914_();
            RenderSystem.m_69493_();
            RenderSystem.m_69461_();
            try (CloseableScissors scissors = ListWidget.scissor(poses, new Rectangle(0, this.top, this.width - 6, this.height - this.top));){
                int entryWidth = (this.width - 12 - 6 - 6) / this.columns.length - 6;
                for (int i = 0; i < this.columns.length; ++i) {
                    int x = 12 + i * (entryWidth + 6);
                    int y = this.top + 6 - this.scroller.scrollAmountInt();
                    for (CollapsibleEntryWidget widget : this.columns[i]) {
                        widget.setPosition(x, y);
                        widget.setWidth(entryWidth);
                        widget.m_6305_(poses, mouseX, mouseY, delta);
                        y += widget.getHeight() + 6;
                    }
                }
            }
            this.scroller.renderScrollBar();
            DynamicErrorFreeEntryListWidget.renderBackBackground(poses, buffer, tesselator, GuiComponent.f_93096_, 0, 0, this.width, this.top, 0, 64);
            ScreenOverlayImpl.getInstance().lateRender(poses, mouseX, mouseY, delta);
        }

        private int getMaxScrollDist() {
            return Arrays.stream(this.columns).mapToInt(ListWidget::getHeightOf).max().orElse(0) + 12;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        public boolean m_6050_(double mouseX, double mouseY, double amount) {
            for (CollapsibleEntryWidget widget : this.children) {
                if (!widget.m_6050_(mouseX, mouseY, amount)) continue;
                return true;
            }
            if (mouseY > (double)this.top) {
                this.scroller.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
                return true;
            }
            return false;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.scroller.updateDraggingState(mouseX, mouseY, button) || super.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return this.scroller.mouseDragged(mouseX, mouseY, button, deltaX, deltaY) || super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }

        public void clear() {
            this.children.clear();
            for (List<CollapsibleEntryWidget> column : this.columns) {
                column.clear();
            }
        }

        public void add(CollapsibleEntryWidget widget) {
            Arrays.stream(this.columns).min(Comparator.comparingInt(ListWidget::getHeightOf)).ifPresent(widgets -> widgets.add(widget));
            this.children.add(widget);
        }

        private static int getHeightOf(List<CollapsibleEntryWidget> widgets) {
            int height = 0;
            for (CollapsibleEntryWidget w : widgets) {
                height += w.getHeight() + 6;
            }
            return Math.max(0, height - 6);
        }
    }
}

