/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.client.gui.widget.AutoCraftingEvaluator;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class DisplayTooltipComponent
implements TooltipComponent,
ClientTooltipComponent {
    private final List<Widget> widgets;
    private final Widget widget;
    private final DisplaySpec display;
    private final Rectangle bounds;
    private final Supplier<AutoCraftingEvaluator.AutoCraftingResult> autoCraftingResult = Suppliers.memoizeWithExpiration(this::evaluateAutoCrafting, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);

    public DisplayTooltipComponent(DisplaySpec display) {
        Display internalDisplay = display.provideInternalDisplay();
        CategoryRegistry.CategoryConfiguration<?> configuration = CategoryRegistry.getInstance().get(internalDisplay.getCategoryIdentifier());
        DisplayCategory<?> category = configuration.getCategory();
        this.bounds = new Rectangle(0, 0, category.getDisplayWidth(internalDisplay), category.getDisplayHeight());
        List<Widget> widgets = configuration.getView(internalDisplay).setupDisplay(internalDisplay, this.bounds);
        this.display = display;
        this.widgets = widgets;
        this.widget = Widgets.concat(widgets);
    }

    public DisplayTooltipComponent(DisplaySpec display, List<Widget> widgets, Rectangle bounds) {
        this.widgets = widgets;
        this.widget = Widgets.concat(widgets);
        this.display = display;
        this.bounds = bounds;
    }

    private AutoCraftingEvaluator.AutoCraftingResult evaluateAutoCrafting() {
        if (this.display == null) {
            return new AutoCraftingEvaluator.AutoCraftingResult();
        }
        return AutoCraftingEvaluator.evaluateAutoCrafting(false, false, this.display.provideInternalDisplay(), this.display::provideInternalDisplayIds);
    }

    public int m_142103_() {
        return this.bounds.height + 4;
    }

    public int m_142069_(Font font) {
        return this.bounds.width + 4;
    }

    public void m_183452_(Font font, int x, int y, PoseStack matrices, ItemRenderer itemRenderer, int z) {
        matrices.m_85836_();
        matrices.m_85837_((double)(x + 2), (double)(y + 2), (double)z);
        matrices.m_85837_((double)(-this.bounds.getX()), (double)(-this.bounds.getY()), 0.0);
        this.widget.m_6305_(matrices, -1000, -1000, 0.0f);
        AutoCraftingEvaluator.AutoCraftingResult craftingResult = this.autoCraftingResult.get();
        if (craftingResult.hasApplicable && craftingResult.renderer != null) {
            matrices.m_85836_();
            Rectangle transformedBounds = MatrixUtils.transform(MatrixUtils.inverse(matrices.m_85850_().m_85861_()), new Rectangle(x + 2, y + 2, this.bounds.width, this.bounds.height));
            Point mouse = MatrixUtils.transform(matrices.m_85850_().m_85861_(), PointHelper.ofMouse());
            craftingResult.renderer.render(matrices, mouse.x, mouse.y, Minecraft.m_91087_().m_91297_(), this.widgets, transformedBounds, this.display.provideInternalDisplay());
            matrices.m_85849_();
        }
        matrices.m_85849_();
    }
}

