/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.config.RecipeBorderType;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public final class PanelWidget
extends Panel {
    private static final PanelWidget TEMP = new PanelWidget(new Rectangle());
    private Rectangle bounds;
    private int color = -1;
    private int xTextureOffset = 0;
    private int yTextureOffset = RecipeBorderType.DEFAULT.getYOffset();
    private Predicate<Panel> rendering = Predicates.alwaysTrue();
    private NumberAnimator<Float> darkBackgroundAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();

    public static boolean isRendering(Panel panel) {
        return true;
    }

    public PanelWidget(Rectangle bounds) {
        this.bounds = Objects.requireNonNull(bounds);
    }

    @Override
    public int getXTextureOffset() {
        return this.xTextureOffset;
    }

    @Override
    public void setXTextureOffset(int xTextureOffset) {
        this.xTextureOffset = xTextureOffset;
    }

    @Override
    public int getYTextureOffset() {
        return this.yTextureOffset;
    }

    @Override
    public void setYTextureOffset(int yTextureOffset) {
        this.yTextureOffset = yTextureOffset;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public Predicate<Panel> getRendering() {
        return this.rendering;
    }

    @Override
    public void setRendering(Predicate<Panel> rendering) {
        this.rendering = Objects.requireNonNull(rendering);
    }

    @ApiStatus.Internal
    public void setDarkBackgroundAlpha(NumberAnimator<Float> darkBackgroundAlpha) {
        this.darkBackgroundAlpha = darkBackgroundAlpha;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.darkBackgroundAlpha.update((double)delta);
        if (ConfigUtils.isReducedMotion()) {
            this.darkBackgroundAlpha.completeImmediately();
        }
        if (!this.getRendering().test(this)) {
            return;
        }
        int x = this.bounds.x;
        int y = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        float alpha = (float)(this.color >> 24 & 0xFF) / 255.0f;
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        this.renderBackground(matrices, x, y, width, height, false, alpha, red, green, blue);
        if (((Float)this.darkBackgroundAlpha.value()).floatValue() * alpha > 0.0f) {
            this.renderBackground(matrices, x, y, width, height, true, ((Float)this.darkBackgroundAlpha.value()).floatValue() * alpha, red, green, blue);
        }
    }

    public void renderBackground(PoseStack matrices, int x, int y, int width, int height, boolean dark, float alpha, float red, float green, float blue) {
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
        RenderSystem.m_157456_((int)0, (ResourceLocation)(dark ? InternalTextures.CHEST_GUI_TEXTURE_DARK : InternalTextures.CHEST_GUI_TEXTURE));
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
        RenderSystem.m_69405_((int)770, (int)771);
        int xTextureOffset = this.getXTextureOffset();
        int yTextureOffset = this.getYTextureOffset();
        this.m_93228_(matrices, x, y, 106 + xTextureOffset, 124 + yTextureOffset, 8, 8);
        this.m_93228_(matrices, x + width - 8, y, 248 + xTextureOffset, 124 + yTextureOffset, 8, 8);
        this.m_93228_(matrices, x, y + height - 8, 106 + xTextureOffset, 182 + yTextureOffset, 8, 8);
        this.m_93228_(matrices, x + width - 8, y + height - 8, 248 + xTextureOffset, 182 + yTextureOffset, 8, 8);
        Matrix4f matrix = matrices.m_85850_().m_85861_();
        GuiComponent.m_93112_((Matrix4f)matrix, (int)(x + 8), (int)(x + width - 8), (int)y, (int)(y + 8), (int)this.getZ(), (float)((float)(114 + xTextureOffset) / 256.0f), (float)((float)(248 + xTextureOffset) / 256.0f), (float)((float)(124 + yTextureOffset) / 256.0f), (float)((float)(132 + yTextureOffset) / 256.0f));
        GuiComponent.m_93112_((Matrix4f)matrix, (int)(x + 8), (int)(x + width - 8), (int)(y + height - 8), (int)(y + height), (int)this.getZ(), (float)((float)(114 + xTextureOffset) / 256.0f), (float)((float)(248 + xTextureOffset) / 256.0f), (float)((float)(182 + yTextureOffset) / 256.0f), (float)((float)(190 + yTextureOffset) / 256.0f));
        GuiComponent.m_93112_((Matrix4f)matrix, (int)x, (int)(x + 8), (int)(y + 8), (int)(y + height - 8), (int)this.getZ(), (float)((float)(106 + xTextureOffset) / 256.0f), (float)((float)(114 + xTextureOffset) / 256.0f), (float)((float)(132 + yTextureOffset) / 256.0f), (float)((float)(182 + yTextureOffset) / 256.0f));
        GuiComponent.m_93112_((Matrix4f)matrix, (int)(x + width - 8), (int)(x + width), (int)(y + 8), (int)(y + height - 8), (int)this.getZ(), (float)((float)(248 + xTextureOffset) / 256.0f), (float)((float)(256 + xTextureOffset) / 256.0f), (float)((float)(132 + yTextureOffset) / 256.0f), (float)((float)(182 + yTextureOffset) / 256.0f));
        GuiComponent.m_93112_((Matrix4f)matrix, (int)(x + 8), (int)(x + width - 8), (int)(y + 8), (int)(y + height - 8), (int)this.getZ(), (float)((float)(114 + xTextureOffset) / 256.0f), (float)((float)(248 + xTextureOffset) / 256.0f), (float)((float)(132 + yTextureOffset) / 256.0f), (float)((float)(182 + yTextureOffset) / 256.0f));
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }
}

