/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.registry.screen.OverlayRendererProvider;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import org.jetbrains.annotations.Nullable;

public enum DefaultScreenOverlayRenderer implements OverlayRendererProvider
{
    INSTANCE;

    @Nullable
    private ClientGuiEvent.ScreenRenderPre renderPre;
    @Nullable
    private ClientGuiEvent.ContainerScreenRenderBackground renderContainerBg;
    @Nullable
    private ClientGuiEvent.ContainerScreenRenderForeground renderContainerFg;
    @Nullable
    private ClientGuiEvent.ScreenRenderPost renderPost;

    private DefaultScreenOverlayRenderer() {
        ClientGuiEvent.RENDER_PRE.register((screen, graphics, mouseX, mouseY, delta) -> {
            if (this.renderPre != null) {
                return this.renderPre.render(screen, graphics, mouseX, mouseY, delta);
            }
            return EventResult.pass();
        });
        ClientGuiEvent.RENDER_CONTAINER_BACKGROUND.register((screen, graphics, mouseX, mouseY, delta) -> {
            if (this.renderContainerBg != null) {
                this.renderContainerBg.render(screen, graphics, mouseX, mouseY, delta);
            }
        });
        ClientGuiEvent.RENDER_CONTAINER_FOREGROUND.register((screen, graphics, mouseX, mouseY, delta) -> {
            if (this.renderContainerFg != null) {
                this.renderContainerFg.render(screen, graphics, mouseX, mouseY, delta);
            }
        });
        ClientGuiEvent.RENDER_POST.register((screen, graphics, mouseX, mouseY, delta) -> {
            if (this.renderPost != null) {
                this.renderPost.render(screen, graphics, mouseX, mouseY, delta);
            }
        });
    }

    @Override
    public void onApplied(OverlayRendererProvider.Sink sink) {
        int[] rendered = new int[]{0};
        this.renderPre = (screen, matrices, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return EventResult.pass();
            }
            rendered[0] = 0;
            return EventResult.pass();
        };
        this.renderContainerBg = (screen, matrices, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn((Screen)screen)) {
                return;
            }
            rendered[0] = 1;
            RoughlyEnoughItemsCoreClient.resetFocused((Screen)screen);
            if (!(screen instanceof DisplayScreen)) {
                sink.render(matrices, mouseX, mouseY, delta);
            }
            RoughlyEnoughItemsCoreClient.resetFocused((Screen)screen);
        };
        this.renderContainerFg = (screen, matrices, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn((Screen)screen)) {
                return;
            }
            rendered[0] = 2;
            RoughlyEnoughItemsCoreClient.resetFocused((Screen)screen);
            PoseStack poseStack = RenderSystem.m_157191_();
            poseStack.m_85836_();
            poseStack.m_85837_((double)(-screen.f_97735_), (double)(-screen.f_97736_), 0.0);
            RenderSystem.m_157182_();
            sink.lateRender(matrices, mouseX, mouseY, delta);
            poseStack.m_85849_();
            RenderSystem.m_157182_();
            RoughlyEnoughItemsCoreClient.resetFocused((Screen)screen);
        };
        this.renderPost = (screen, matrices, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen) || rendered[0] == 2) {
                return;
            }
            if (screen instanceof AbstractContainerScreen) {
                InternalLogger.getInstance().warn("Screen " + screen.getClass().getName() + " did not render background and foreground! This might cause rendering issues!");
            }
            RoughlyEnoughItemsCoreClient.resetFocused(screen);
            if (rendered[0] == 0 && !(screen instanceof DisplayScreen)) {
                sink.render(matrices, mouseX, mouseY, delta);
            }
            rendered[0] = 1;
            if (rendered[0] == 1) {
                sink.lateRender(matrices, mouseX, mouseY, delta);
            }
            RoughlyEnoughItemsCoreClient.resetFocused(screen);
        };
    }

    @Override
    public void onRemoved() {
        this.renderPre = null;
        this.renderContainerBg = null;
        this.renderContainerFg = null;
        this.renderPost = null;
    }
}

