/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.util;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.architectury.utils.GameInstance;
import java.lang.ref.WeakReference;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InstanceHelper {
    private static final InstanceHelper INSTANCE = new InstanceHelper();
    private WeakReference<RegistryAccess> registryAccessRef;
    private WeakReference<RecipeManager> recipeManagerRef;
    private boolean warnedRegistryAccess;
    private boolean warnedRecipeManager;

    public static InstanceHelper getInstance() {
        return INSTANCE;
    }

    public RegistryAccess registryAccess() {
        RegistryAccess access;
        RegistryAccess registryAccess = access = this.registryAccessRef == null ? null : (RegistryAccess)this.registryAccessRef.get();
        if (access != null) {
            return access;
        }
        if (Platform.getEnvironment() == Env.CLIENT) {
            access = InstanceHelper.registryAccessFromClient();
        } else if (GameInstance.getServer() != null) {
            access = GameInstance.getServer().m_206579_();
        }
        if (access == null && !this.warnedRegistryAccess) {
            this.warnedRegistryAccess = true;
            InternalLogger.getInstance().throwException(new IllegalStateException("Cannot get registry access!"));
            return RegistryAccess.m_206165_((Registry)Registry.f_122897_);
        }
        return access;
    }

    public RecipeManager recipeManager() {
        RecipeManager manager;
        RecipeManager recipeManager = manager = this.recipeManagerRef == null ? null : (RecipeManager)this.recipeManagerRef.get();
        if (manager != null) {
            return manager;
        }
        if (Platform.getEnvironment() == Env.CLIENT) {
            manager = InstanceHelper.recipeManagerFromClient();
        } else if (GameInstance.getServer() != null) {
            manager = GameInstance.getServer().m_129894_();
        }
        if (manager == null && !this.warnedRegistryAccess) {
            this.warnedRegistryAccess = true;
            throw new IllegalStateException("Cannot get recipe manager!");
        }
        return manager;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static ClientPacketListener connectionFromClient() {
        if (Minecraft.m_91087_().f_91073_ != null) {
            return Minecraft.m_91087_().f_91073_.f_104561_;
        }
        if (Minecraft.m_91087_().m_91403_() != null) {
            return Minecraft.m_91087_().m_91403_();
        }
        if (Minecraft.m_91087_().f_91072_ != null) {
            return Minecraft.m_91087_().f_91072_.f_105190_;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static RegistryAccess registryAccessFromClient() {
        ClientPacketListener connection = InstanceHelper.connectionFromClient();
        if (connection == null) {
            return null;
        }
        return connection.m_105152_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static RecipeManager recipeManagerFromClient() {
        ClientPacketListener connection = InstanceHelper.connectionFromClient();
        if (connection == null) {
            return null;
        }
        return connection.m_105141_();
    }
}

