/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.crafting.filler;

import com.google.common.base.MoreObjects;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.client.categories.crafting.filler.CraftingRecipeFiller;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapelessDisplay;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShieldDecorationRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ShieldDecorationRecipeFiller
implements CraftingRecipeFiller<ShieldDecorationRecipe> {
    static List<Pair<DyeColor, ItemStack>> randomizeBanners() {
        ArrayList<Pair<DyeColor, ItemStack>> out = new ArrayList<Pair<DyeColor, ItemStack>>();
        DyeColor[] colors = DyeColor.values();
        Random random = new Random();
        for (DyeColor color : colors) {
            Optional bannerOptional = Registry.f_122827_.m_6612_(new ResourceLocation(color.m_41065_() + "_banner"));
            if (bannerOptional.isEmpty()) continue;
            out.add((Pair<DyeColor, ItemStack>)Pair.of((Object)color, (Object)new ItemStack((ItemLike)bannerOptional.get())));
            for (int i = 0; i < 2; ++i) {
                BannerPattern.Builder patternBuilder = new BannerPattern.Builder();
                BannerPattern[] allPatterns = BannerPattern.values();
                for (int j = 0; j < 2; ++j) {
                    BannerPattern pattern = allPatterns[random.nextInt(allPatterns.length - 1) + 1];
                    patternBuilder.m_58588_(pattern, colors[random.nextInt(colors.length)]);
                }
                ItemStack banner = new ItemStack((ItemLike)bannerOptional.get());
                CompoundTag newTag = new CompoundTag();
                newTag.m_128365_("Patterns", (Tag)patternBuilder.m_58587_());
                banner.m_41700_("BlockEntityTag", (Tag)newTag);
                out.add((Pair<DyeColor, ItemStack>)Pair.of((Object)color, (Object)banner));
            }
        }
        return out;
    }

    @Override
    public Collection<Display> apply(ShieldDecorationRecipe recipe) {
        ArrayList<Display> displays = new ArrayList<Display>();
        EntryIngredient shield = EntryIngredients.of((ItemLike)Items.f_42740_);
        EntryIngredient.Builder inputsBuilder = EntryIngredient.builder();
        EntryIngredient.Builder outputsBuilder = EntryIngredient.builder();
        for (Pair<DyeColor, ItemStack> pair : ShieldDecorationRecipeFiller.randomizeBanners()) {
            inputsBuilder.add((EntryStack<?>)EntryStacks.of((ItemStack)pair.getSecond()));
            outputsBuilder.add((EntryStack<?>)ShieldDecorationRecipeFiller.createOutput((DyeColor)pair.getFirst(), (ItemStack)pair.getSecond()));
        }
        EntryIngredient inputs = inputsBuilder.build();
        EntryIngredient outputs = outputsBuilder.build();
        EntryIngredient.unifyFocuses(inputs, outputs);
        displays.add(new DefaultCustomShapelessDisplay((Recipe<?>)recipe, List.of(inputs, shield), List.of(outputs)));
        return displays;
    }

    private static EntryStack<ItemStack> createOutput(DyeColor color, ItemStack banner) {
        ItemStack output = new ItemStack((ItemLike)Items.f_42740_);
        CompoundTag beTag = (CompoundTag)MoreObjects.firstNonNull((Object)BlockItem.m_186336_((ItemStack)banner), (Object)new CompoundTag());
        beTag.m_128405_("Base", color.m_41060_());
        BlockItem.m_186338_((ItemStack)output, (BlockEntityType)BlockEntityType.f_58935_, (CompoundTag)beTag);
        return EntryStacks.of(output);
    }

    @Override
    public Class<ShieldDecorationRecipe> getRecipeClass() {
        return ShieldDecorationRecipe.class;
    }
}

