/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.brewing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.brewing.BrewingRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DefaultBrewingDisplay
implements Display {
    private EntryStack<?> output;
    private EntryIngredient reactant;
    private EntryIngredient input;

    public DefaultBrewingDisplay(BrewingRecipe recipe) {
        this(recipe.input, recipe.ingredient, recipe.output);
    }

    public DefaultBrewingDisplay(Ingredient input, Ingredient reactant, ItemStack output) {
        this(EntryIngredients.ofIngredient(input), EntryIngredients.ofIngredient(reactant), EntryStacks.of(output));
    }

    public DefaultBrewingDisplay(EntryIngredient input, EntryIngredient reactant, EntryStack<?> output) {
        this.input = input.map(stack -> stack.copy().tooltip(new Component[]{new TranslatableComponent("category.rei.brewing.input").m_130940_(ChatFormatting.YELLOW)}));
        this.reactant = reactant.map(stack -> stack.copy().tooltip(new Component[]{new TranslatableComponent("category.rei.brewing.reactant").m_130940_(ChatFormatting.YELLOW)}));
        this.output = output.copy().tooltip(new Component[]{new TranslatableComponent("category.rei.brewing.result").m_130940_(ChatFormatting.YELLOW)});
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return Lists.newArrayList((Object[])new EntryIngredient[]{this.input, this.reactant});
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(EntryIngredient.of(this.output));
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.BREWING;
    }

    public List<EntryStack<?>> getOutput(int slot) {
        int i;
        ArrayList stack = new ArrayList();
        for (i = 0; i < slot * 2; ++i) {
            stack.add(EntryStack.empty());
        }
        for (i = 0; i < 6 - slot * 2; ++i) {
            stack.add(this.output);
        }
        return stack;
    }

    public static DisplaySerializer<DefaultBrewingDisplay> serializer() {
        return new DisplaySerializer<DefaultBrewingDisplay>(){

            @Override
            public CompoundTag save(CompoundTag tag, DefaultBrewingDisplay display) {
                tag.m_128365_("input", (Tag)display.input.saveIngredient());
                tag.m_128365_("reactant", (Tag)display.reactant.saveIngredient());
                tag.m_128365_("output", (Tag)display.output.saveStack());
                return tag;
            }

            @Override
            public DefaultBrewingDisplay read(CompoundTag tag) {
                EntryIngredient input = EntryIngredient.read(tag.m_128437_("input", 10));
                EntryIngredient reactant = EntryIngredient.read(tag.m_128437_("reactant", 10));
                EntryStack<?> output = EntryStack.read(tag.m_128469_("output"));
                return new DefaultBrewingDisplay(input, reactant, output);
            }
        };
    }
}

