/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import dev.architectury.platform.Platform;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.transfer.info.simple.SimpleGridMenuInfo;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.crafting.CraftingRecipeSizeProvider;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapedDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapelessDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultShapedDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultShapelessDisplay;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultCraftingDisplay<C extends Recipe<?>>
extends BasicDisplay
implements SimpleGridMenuDisplay {
    protected Optional<C> recipe;
    private static final List<CraftingRecipeSizeProvider<?>> SIZE_PROVIDER = new ArrayList();

    public DefaultCraftingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<C> recipe) {
        this(inputs, outputs, recipe.map(Recipe::m_6423_), recipe);
    }

    public DefaultCraftingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location, Optional<C> recipe) {
        super(inputs, outputs, location);
        this.recipe = recipe;
    }

    public static <R extends Recipe<?>> void registerSizeProvider(CraftingRecipeSizeProvider<R> sizeProvider) {
        SIZE_PROVIDER.add(0, sizeProvider);
    }

    @Nullable
    public static DefaultCraftingDisplay<?> of(Recipe<?> recipe) {
        if (recipe instanceof ShapelessRecipe) {
            return new DefaultShapelessDisplay((ShapelessRecipe)recipe);
        }
        if (recipe instanceof ShapedRecipe) {
            return new DefaultShapedDisplay((ShapedRecipe)recipe);
        }
        if (!recipe.m_5598_()) {
            NonNullList ingredients = recipe.m_7527_();
            for (CraftingRecipeSizeProvider<?> pair : SIZE_PROVIDER) {
                CraftingRecipeSizeProvider.Size size = pair.getSize(recipe);
                if (size == null) continue;
                return new DefaultCustomShapedDisplay(recipe, EntryIngredients.ofIngredients((List<Ingredient>)recipe.m_7527_()), Collections.singletonList(EntryIngredients.of(recipe.m_8043_())), size.getWidth(), size.getHeight());
            }
            return new DefaultCustomDisplay(recipe, EntryIngredients.ofIngredients((List<Ingredient>)recipe.m_7527_()), Collections.singletonList(EntryIngredients.of(recipe.m_8043_())));
        }
        return null;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.CRAFTING;
    }

    public Optional<C> getOptionalRecipe() {
        return this.recipe;
    }

    @Override
    public Optional<ResourceLocation> getDisplayLocation() {
        return this.getOptionalRecipe().map(Recipe::m_6423_);
    }

    public <T extends AbstractContainerMenu> List<List<ItemStack>> getOrganisedInputEntries(SimpleGridMenuInfo<T, DefaultCraftingDisplay<?>> menuInfo, T container) {
        return CollectionUtils.map(this.getOrganisedInputEntries(menuInfo.getCraftingWidth(container), menuInfo.getCraftingHeight(container)), ingredient -> CollectionUtils.filterAndMap(ingredient, stack -> stack.getType() == VanillaEntryTypes.ITEM, EntryStack::castValue));
    }

    public <T extends AbstractContainerMenu> List<EntryIngredient> getOrganisedInputEntries(int menuWidth, int menuHeight) {
        int i;
        ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>(menuWidth * menuHeight);
        for (i = 0; i < menuWidth * menuHeight; ++i) {
            list.add(EntryIngredient.empty());
        }
        for (i = 0; i < this.getInputEntries().size(); ++i) {
            list.set(DefaultCraftingDisplay.getSlotWithSize(this, i, menuWidth), this.getInputEntries().get(i));
        }
        return list;
    }

    public boolean isShapeless() {
        return false;
    }

    public static int getSlotWithSize(DefaultCraftingDisplay<?> display, int index, int craftingGridWidth) {
        return DefaultCraftingDisplay.getSlotWithSize(display.getInputWidth(craftingGridWidth, 3), index, craftingGridWidth);
    }

    public static int getSlotWithSize(int recipeWidth, int index, int craftingGridWidth) {
        int x = index % recipeWidth;
        int y = (index - x) / recipeWidth;
        return craftingGridWidth * y + x;
    }

    public static BasicDisplay.Serializer<DefaultCraftingDisplay<?>> serializer() {
        return BasicDisplay.Serializer.of((input, output, location, tag) -> {
            if (tag.m_128441_("REIRecipeType")) {
                String type;
                return switch (type = tag.m_128461_("REIRecipeType")) {
                    case "Shapeless" -> DefaultCustomShapelessDisplay.simple(input, output, location);
                    case "Shaped" -> DefaultCustomShapedDisplay.simple(input, output, tag.m_128451_("RecipeWidth"), tag.m_128451_("RecipeHeight"), location);
                    default -> throw new IllegalArgumentException("Unknown recipe type: " + type);
                };
            }
            return DefaultCustomDisplay.simple(input, output, location);
        }, (display, tag) -> {
            tag.m_128359_("REIRecipeType", display.isShapeless() ? "Shapeless" : "Shaped");
            if (!display.isShapeless()) {
                tag.m_128405_("RecipeWidth", display.getInputWidth(3, 3));
                tag.m_128405_("RecipeHeight", display.getInputHeight(3, 3));
            }
        });
    }

    @Override
    public List<InputIngredient<EntryStack<?>>> getInputIngredients(MenuSerializationContext<?, ?, ?> context, MenuInfo<?, ?> info, boolean fill) {
        int craftingWidth = 3;
        int craftingHeight = 3;
        if (info instanceof SimpleGridMenuInfo && fill) {
            craftingWidth = ((SimpleGridMenuInfo)info).getCraftingWidth(context.getMenu());
            craftingHeight = ((SimpleGridMenuInfo)info).getCraftingHeight(context.getMenu());
        }
        return this.getInputIngredients(craftingWidth, craftingHeight);
    }

    @Override
    public List<InputIngredient<EntryStack<?>>> getInputIngredients(@Nullable AbstractContainerMenu menu, @Nullable Player player) {
        return this.getInputIngredients(3, 3);
    }

    public List<InputIngredient<EntryStack<?>>> getInputIngredients(int craftingWidth, int craftingHeight) {
        int inputWidth = this.getInputWidth(craftingWidth, craftingHeight);
        int inputHeight = this.getInputHeight(craftingWidth, craftingHeight);
        HashMap grid = new HashMap();
        List<EntryIngredient> inputEntries = this.getInputEntries();
        for (int i = 0; i < inputEntries.size(); ++i) {
            EntryIngredient stacks = inputEntries.get(i);
            if (stacks.isEmpty()) continue;
            int index = DefaultCraftingDisplay.getSlotWithSize(inputWidth, i, craftingWidth);
            int x = i % inputWidth;
            int y = i / inputWidth;
            grid.put(new IntIntImmutablePair(x, y), InputIngredient.of(index, 3 * y + x, stacks));
        }
        ArrayList list = new ArrayList(craftingWidth * craftingHeight);
        int n = craftingWidth * craftingHeight;
        for (int i = 0; i < n; ++i) {
            list.add(InputIngredient.empty(i));
        }
        for (int x = 0; x < craftingWidth; ++x) {
            for (int y = 0; y < craftingHeight; ++y) {
                InputIngredient ingredient = (InputIngredient)grid.get(new IntIntImmutablePair(x, y));
                if (ingredient == null) continue;
                int index = craftingWidth * y + x;
                list.set(index, ingredient);
            }
        }
        return list;
    }

    static {
        try {
            Class.forName("me.shedaniel.rei.plugin.common.displays.crafting.%s.DefaultCraftingDisplayImpl".formatted(Platform.isForge() ? "forge" : "fabric")).getDeclaredMethod("registerPlatformSizeProvider", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

