/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.tag;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class TagNode<T> {
    private final List<TagNode<T>> children = new ArrayList<TagNode<T>>();

    public static <T> TagNode<T> ofValues(HolderSet<T> value) {
        return new ValuesTagNode<T>(value);
    }

    public static <T> TagNode<T> ofReference(TagKey<T> key) {
        return new ReferenceTagNode<T>(key);
    }

    public List<TagNode<T>> children() {
        return this.children;
    }

    public void addChild(TagNode<T> child) {
        this.children.add(child);
    }

    public void addValuesChild(HolderSet<T> child) {
        this.children.add(TagNode.ofValues(child));
    }

    public void addReferenceChild(TagKey<T> child) {
        this.children.add(TagNode.ofReference(child));
    }

    public String asTree() {
        StringBuilder builder = new StringBuilder(50);
        this.printTree(builder, "", "");
        return builder.toString();
    }

    private void printTree(StringBuilder builder, String prefix, String childrenPrefix) {
        this.asText(prefix, builder);
        Iterator<TagNode<T>> it = this.children.iterator();
        while (it.hasNext()) {
            TagNode<T> next = it.next();
            if (it.hasNext()) {
                next.printTree(builder, childrenPrefix + "\u251c\u2500\u2500 ", childrenPrefix + "\u2502   ");
                continue;
            }
            next.printTree(builder, childrenPrefix + "\u2514\u2500\u2500 ", childrenPrefix + "    ");
        }
    }

    protected abstract void asText(String var1, StringBuilder var2);

    @Nullable
    public HolderSet<T> getValue() {
        return null;
    }

    @Nullable
    public TagKey<T> getReference() {
        return null;
    }

    private static class ValuesTagNode<T>
    extends TagNode<T> {
        private final HolderSet<T> value;

        public ValuesTagNode(HolderSet<T> value) {
            this.value = value;
        }

        @Override
        public HolderSet<T> getValue() {
            return this.value;
        }

        @Override
        protected void asText(String prefix, StringBuilder builder) {
            for (Holder holder : this.value) {
                holder.m_203543_().ifPresent(key -> {
                    builder.append(prefix);
                    builder.append(key.m_135782_().toString());
                    builder.append('\n');
                });
            }
        }
    }

    private static class ReferenceTagNode<T>
    extends TagNode<T> {
        private final TagKey<T> key;

        public ReferenceTagNode(TagKey<T> key) {
            this.key = key;
        }

        @Override
        public TagKey<T> getReference() {
            return this.key;
        }

        @Override
        protected void asText(String prefix, StringBuilder builder) {
            builder.append(prefix);
            builder.append(this.key.f_203868_());
            builder.append('\n');
        }
    }
}

