/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.base.dragon;

import com.GACMD.isleofberk.config.ModConfigs;
import com.GACMD.isleofberk.entity.AI.breed.DragonBreedGoal;
import com.GACMD.isleofberk.entity.AI.goal.FollowOwnerNoTPGoal;
import com.GACMD.isleofberk.entity.AI.goal.IOBLookAtPlayerGoal;
import com.GACMD.isleofberk.entity.AI.goal.IOBRandomLookAroundGoal;
import com.GACMD.isleofberk.entity.AI.ground.DragonWaterAvoidingRandomStrollGoal;
import com.GACMD.isleofberk.entity.AI.taming.AggressionToPlayersGoal;
import com.GACMD.isleofberk.entity.AI.taming.DragonRideTilTamed;
import com.GACMD.isleofberk.entity.AI.target.DragonHurtByTargetGoal;
import com.GACMD.isleofberk.entity.AI.target.DragonMeleeAttackGoal;
import com.GACMD.isleofberk.entity.AI.target.DragonOwnerHurtTargetGoal;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.entity.eggs.entity.eggs.StingerEgg;
import com.GACMD.isleofberk.entity.projectile.abase.BaseLinearFlightProjectile;
import com.GACMD.isleofberk.network.ControlNetwork;
import com.GACMD.isleofberk.network.message.ControlMessageAbility;
import com.GACMD.isleofberk.network.message.ControlMessageGoingDown;
import com.GACMD.isleofberk.network.message.ControlMessageJumping;
import com.GACMD.isleofberk.network.message.ControlMessageSECONDAbility;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModKeyBinds;
import com.GACMD.isleofberk.util.Util;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.extensions.IForgeEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public abstract class ADragonBase
extends TamableAnimal
implements IAnimatable,
IForgeEntity {
    protected static final EntityDataAccessor<Integer> DRAGON_VARIANT = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> CHANGE_IN_YAW = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> DISTURB_TICKS = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DISTURB_TICKS_ABILITY = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DRAGON_OVERLAY = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> FOOD_TAMING_LIMITER_BAR = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> PHASE_ONE_PROGRESS = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> TITAN_WING = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IS_INCAPACITATED = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> ABILITY = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> DISABLED = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> SECOND_ABILITY = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> MARK_ROAR = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IS_MALE = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> ON_GROUND = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> AIR_SPACE = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IS_ROARING = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> COMMANDS = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> CURRENT_ATTACK = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> TICKS_SINCE_LAST_ATTACK = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> TICKS_SINCE_LAST_ROAR = SynchedEntityData.m_135353_(ADragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> PREY_SELECTOR = p_30437_ -> {
        EntityType entitytype = p_30437_.m_6095_();
        return entitytype == EntityType.f_20520_ || entitytype == EntityType.f_20517_ || entitytype == EntityType.f_20510_ || entitytype == EntityType.f_20557_ || entitytype == EntityType.f_20555_ || entitytype == EntityType.f_20558_;
    };
    public boolean renderedOnGUI;
    public float changeInYaw;
    BlockPos homePos;
    boolean hasHomePosition;
    protected int roarTicks = 0;
    private LazyOptional<?> itemHandler = null;

    protected int getTransitionTicks() {
        return ModConfigs.clientConfig.transitionToggle.get() != false ? 0 : 4;
    }

    protected ADragonBase(EntityType<? extends ADragonBase> animal, Level world) {
        super(animal, world);
        this.f_19793_ = 1.0f;
    }

    public boolean m_6673_(@NotNull DamageSource pSource) {
        if (pSource == DamageSource.f_19305_ || pSource == DamageSource.f_19307_ || pSource == DamageSource.f_19315_ || pSource == DamageSource.f_19308_ || pSource == DamageSource.f_19310_ || pSource == DamageSource.f_19316_ || pSource == DamageSource.f_19314_ || pSource == DamageSource.f_19309_) {
            return true;
        }
        if (this.isDragonDisabled() && !(pSource.m_7639_() instanceof Player)) {
            return false;
        }
        return super.m_6673_(pSource);
    }

    public boolean isDragonMoving() {
        return this.m_20185_() != this.f_19790_ || this.m_20189_() != this.f_19792_;
    }

    public void m_6845_(boolean pDownwards) {
    }

    public void m_20321_(boolean pDownwards) {
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DRAGON_VARIANT, (Object)0);
        this.f_19804_.m_135372_(CHANGE_IN_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DISTURB_TICKS, (Object)0);
        this.f_19804_.m_135372_(DISTURB_TICKS_ABILITY, (Object)0);
        this.f_19804_.m_135372_(DRAGON_OVERLAY, (Object)0);
        this.f_19804_.m_135372_(COMMANDS, (Object)0);
        this.f_19804_.m_135372_(FOOD_TAMING_LIMITER_BAR, (Object)0);
        this.f_19804_.m_135372_(PHASE_ONE_PROGRESS, (Object)0);
        this.f_19804_.m_135372_(TITAN_WING, (Object)false);
        this.f_19804_.m_135372_(IS_INCAPACITATED, (Object)false);
        this.f_19804_.m_135372_(ABILITY, (Object)false);
        this.f_19804_.m_135372_(DISABLED, (Object)false);
        this.f_19804_.m_135372_(SECOND_ABILITY, (Object)false);
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(ON_GROUND, (Object)false);
        this.f_19804_.m_135372_(AIR_SPACE, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(IS_ROARING, (Object)false);
        this.f_19804_.m_135372_(IS_MALE, (Object)this.f_19796_.nextBoolean());
        this.f_19804_.m_135372_(CURRENT_ATTACK, (Object)0);
        this.f_19804_.m_135372_(TICKS_SINCE_LAST_ATTACK, (Object)0);
        this.f_19804_.m_135372_(TICKS_SINCE_LAST_ROAR, (Object)0);
        this.f_19804_.m_135372_(MARK_ROAR, (Object)false);
    }

    public void m_6043_() {
        super.m_6043_();
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("food_taming_threshold", this.getFoodTameLimiterBar());
        pCompound.m_128405_("phase_1_progress", this.getPhase1Progress());
        pCompound.m_128405_("disturb_ticks", this.getSleepDisturbTicks());
        pCompound.m_128405_("disturb_ticks_ability", this.getAbilityDisturbTicks());
        pCompound.m_128405_("variant", this.getDragonVariant());
        pCompound.m_128405_("overlay", this.getDragonOverlay());
        pCompound.m_128405_("commands", this.getCommand());
        pCompound.m_128405_("current_attack", this.getCurrentAttackType());
        pCompound.m_128405_("ticks_since_last_attack", this.getTicksSinceLastAttack());
        pCompound.m_128405_("ticks_since_last_roar", this.getTicksSinceLastRoar());
        pCompound.m_128379_("ability", this.isUsingAbility());
        pCompound.m_128379_("s_ability", this.isUsingSECONDAbility());
        pCompound.m_128379_("dragon_disabled", this.isDragonDisabled());
        pCompound.m_128379_("sleeping", this.isDragonSleeping());
        pCompound.m_128379_("dragonOnGround", this.isDragonOnGround());
        pCompound.m_128379_("dragonAirSpaceClear", this.isDragonOnAirspaceClear());
        pCompound.m_128379_("sitting", this.isDragonSitting());
        pCompound.m_128379_("roaring", this.isDragonRoaring());
        pCompound.m_128379_("incapacitated", this.isDragonIncapacitated());
        pCompound.m_128379_("wandering", this.isDragonWandering());
        pCompound.m_128379_("is_male", this.isDragonMale());
        pCompound.m_128379_("following", this.isDragonFollowing());
        pCompound.m_128379_("mark_roar", this.markRoar());
        pCompound.m_128350_("change_in_yaw", this.getChangeInYaw());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setFoodTameLimiterBar(pCompound.m_128451_("food_taming_threshold"));
        this.setPhase1Progress(pCompound.m_128451_("phase_1_progress"));
        this.setSleepDisturbTicks(pCompound.m_128451_("disturb_ticks"));
        this.setAbilityDisturbTicksAbility(pCompound.m_128451_("disturb_ticks_ability"));
        this.setDragonVariant(pCompound.m_128451_("variant"));
        this.setDragonOverlay(pCompound.m_128451_("overlay"));
        this.setCommands(pCompound.m_128451_("commands"));
        this.setIsTitanWing(pCompound.m_128471_("titan_wing"));
        this.setIsUsingAbility(pCompound.m_128471_("ability"));
        this.setIsUsingSECONDAbility(pCompound.m_128471_("s_ability"));
        this.setIsDragonDisabled(pCompound.m_128471_("dragon_disabled"));
        this.setIsDragonIncapacitated(pCompound.m_128471_("incapacitated"));
        this.setTicksSinceLastRoar(pCompound.m_128451_("ticks_since_last_attack"));
        this.setTicksSinceLastAttack(pCompound.m_128451_("ticks_since_last_roar"));
        this.setIsDragonSitting(pCompound.m_128471_("sitting"));
        this.setIsDragonRoaring(pCompound.m_128471_("roaring"));
        this.setIsDragonSleeping(pCompound.m_128471_("sleeping"));
        this.setIsDragonOnGround(pCompound.m_128471_("dragonOnGround"));
        this.setIsDragonOnAirspaceClear(pCompound.m_128471_("dragonAirSpaceClear"));
        this.setIsDragonWandering(pCompound.m_128471_("wandering"));
        this.setIsDragonFollowing(pCompound.m_128471_("following"));
        this.setCurrentAttackType(pCompound.m_128451_("current_attack"));
        this.setIsDragonMale(pCompound.m_128471_("is_male"));
        this.setMarkRoar(pCompound.m_128471_("mark_roar"));
        this.setChangeInYaw(pCompound.m_128457_("change_in_yaw"));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @org.jetbrains.annotations.Nullable SpawnGroupData p_146749_, @org.jetbrains.annotations.Nullable CompoundTag p_146750_) {
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    public void registerControllers(AnimationData data) {
    }

    public static boolean checkAnimalSpawnRules(EntityType<? extends Animal> pAnimal, LevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, Random pRandom) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_184228_) || pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_13029_) || pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_13035_) || pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_198158_) || pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_144282_) || pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_144283_) || pLevel.m_45527_(pPos) || !pLevel.m_45527_(pPos);
    }

    protected static boolean isBrightEnoughToSpawn(BlockAndTintGetter p_186210_, BlockPos p_186211_) {
        return p_186210_.m_45524_(p_186211_, 0) > 4;
    }

    public AnimationFactory getFactory() {
        return null;
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMANDS);
    }

    public void setCommands(int commands) {
        this.f_19804_.m_135381_(COMMANDS, (Object)commands);
    }

    public void modifyCommand(int limit, Player player) {
        if (this.getCommand() >= limit) {
            this.setCommands(0);
        } else {
            this.setCommands(this.getCommand() + 1);
        }
        String wandering = "iob.command.wandering";
        String sitting = "iob.command.sitting";
        String following = "iob.command.following";
        switch (this.getCommand()) {
            default: {
                player.m_5661_((Component)new TranslatableComponent(wandering, new Object[]{Integer.toString(this.getCommand())}), true);
                break;
            }
            case 1: {
                player.m_5661_((Component)new TranslatableComponent(sitting, new Object[]{Integer.toString(this.getCommand())}), true);
                break;
            }
            case 2: {
                player.m_5661_((Component)new TranslatableComponent(following, new Object[]{Integer.toString(this.getCommand())}), true);
            }
        }
    }

    public boolean isDragonWandering() {
        return (Integer)this.f_19804_.m_135370_(COMMANDS) == 0;
    }

    public boolean isDragonSitting() {
        return (Integer)this.f_19804_.m_135370_(COMMANDS) == 1;
    }

    public boolean isDragonFollowing() {
        return (Integer)this.f_19804_.m_135370_(COMMANDS) == 2;
    }

    public void setIsDragonWandering(boolean wandering) {
        if (wandering) {
            this.f_19804_.m_135381_(COMMANDS, (Object)0);
        }
    }

    public void setIsDragonSitting(boolean sitting) {
        if (sitting) {
            this.f_19804_.m_135381_(COMMANDS, (Object)1);
        }
    }

    public void setIsDragonFollowing(boolean following) {
        if (following) {
            this.f_19804_.m_135381_(COMMANDS, (Object)2);
        }
    }

    public boolean isDragonSleeping() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setIsDragonSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean isDragonRoaring() {
        return (Boolean)this.f_19804_.m_135370_(IS_ROARING);
    }

    public void setIsDragonRoaring(boolean roar) {
        this.f_19804_.m_135381_(IS_ROARING, (Object)roar);
    }

    public boolean isDragonOnGround() {
        return (Boolean)this.f_19804_.m_135370_(ON_GROUND);
    }

    public void setIsDragonOnGround(boolean sleeping) {
        this.f_19804_.m_135381_(ON_GROUND, (Object)sleeping);
    }

    public boolean isDragonOnAirspaceClear() {
        return (Boolean)this.f_19804_.m_135370_(AIR_SPACE);
    }

    public void setIsDragonOnAirspaceClear(boolean air) {
        this.f_19804_.m_135381_(AIR_SPACE, (Object)air);
    }

    public boolean isDragonIncapacitated() {
        return (Boolean)this.f_19804_.m_135370_(IS_INCAPACITATED);
    }

    public void setIsDragonIncapacitated(boolean incapacitated) {
        this.f_19804_.m_135381_(IS_INCAPACITATED, (Object)incapacitated);
    }

    public int getDragonVariant() {
        return (Integer)this.f_19804_.m_135370_(DRAGON_VARIANT);
    }

    public void setDragonVariant(int pType) {
        this.f_19804_.m_135381_(DRAGON_VARIANT, (Object)pType);
    }

    public int getDragonOverlay() {
        return (Integer)this.f_19804_.m_135370_(DRAGON_OVERLAY);
    }

    public void setDragonOverlay(int pType) {
        this.f_19804_.m_135381_(DRAGON_OVERLAY, (Object)pType);
    }

    public boolean isTitanWing() {
        return (Boolean)this.f_19804_.m_135370_(TITAN_WING);
    }

    public void setIsTitanWing(boolean titan_wing) {
        this.f_19804_.m_135381_(TITAN_WING, (Object)titan_wing);
    }

    public boolean isDragonMale() {
        return (Boolean)this.f_19804_.m_135370_(IS_MALE);
    }

    public void setIsDragonMale(boolean male) {
        this.f_19804_.m_135381_(IS_MALE, (Object)male);
    }

    public boolean canEatWithFoodOnHand(boolean pIgnoreHunger) {
        if (!this.m_21824_()) {
            return this.m_20147_() || pIgnoreHunger && this.m_5448_() != null && this.getFoodTameLimiterBar() < 100;
        }
        return this.m_20147_() || pIgnoreHunger && this.m_5448_() != null;
    }

    public int getFoodTameLimiterBar() {
        return (Integer)this.f_19804_.m_135370_(FOOD_TAMING_LIMITER_BAR);
    }

    public void setFoodTameLimiterBar(int food) {
        this.f_19804_.m_135381_(FOOD_TAMING_LIMITER_BAR, (Object)food);
    }

    public int getPhase1Progress() {
        return (Integer)this.f_19804_.m_135370_(PHASE_ONE_PROGRESS);
    }

    public void setPhase1Progress(int phase_progress) {
        this.f_19804_.m_135381_(PHASE_ONE_PROGRESS, (Object)phase_progress);
    }

    public int getSleepDisturbTicks() {
        return (Integer)this.f_19804_.m_135370_(DISTURB_TICKS);
    }

    public void setSleepDisturbTicks(int disturbTicks) {
        this.f_19804_.m_135381_(DISTURB_TICKS, (Object)disturbTicks);
    }

    public int getTicksSinceLastAttack() {
        return (Integer)this.f_19804_.m_135370_(TICKS_SINCE_LAST_ATTACK);
    }

    public void setTicksSinceLastAttack(int ticks) {
        this.f_19804_.m_135381_(TICKS_SINCE_LAST_ATTACK, (Object)ticks);
    }

    public int getTicksSinceLastRoar() {
        return (Integer)this.f_19804_.m_135370_(TICKS_SINCE_LAST_ROAR);
    }

    public void setTicksSinceLastRoar(int ticks) {
        this.f_19804_.m_135381_(TICKS_SINCE_LAST_ROAR, (Object)ticks);
    }

    public boolean markRoar() {
        return (Boolean)this.f_19804_.m_135370_(MARK_ROAR);
    }

    public void setMarkRoar(boolean mark_roar) {
        this.f_19804_.m_135381_(MARK_ROAR, (Object)mark_roar);
    }

    public int getAbilityDisturbTicks() {
        return (Integer)this.f_19804_.m_135370_(DISTURB_TICKS_ABILITY);
    }

    public void setAbilityDisturbTicksAbility(int disturbTicks) {
        this.f_19804_.m_135381_(DISTURB_TICKS_ABILITY, (Object)disturbTicks);
    }

    public boolean isPhaseTwo() {
        return this.getPhase1Progress() >= 100;
    }

    public int getFoodTamingPhaseMaximumLevel() {
        return 100;
    }

    public boolean isUsingAbility() {
        return (Boolean)this.f_19804_.m_135370_(ABILITY);
    }

    public void setIsUsingAbility(boolean ability_pressed) {
        this.f_19804_.m_135381_(ABILITY, (Object)ability_pressed);
    }

    public boolean isDragonDisabled() {
        return (Boolean)this.f_19804_.m_135370_(DISABLED);
    }

    public void setIsDragonDisabled(boolean invulnerable) {
        this.f_19804_.m_135381_(DISABLED, (Object)invulnerable);
    }

    public boolean isUsingSECONDAbility() {
        return (Boolean)this.f_19804_.m_135370_(SECOND_ABILITY);
    }

    public void setIsUsingSECONDAbility(boolean ability_pressed) {
        this.f_19804_.m_135381_(SECOND_ABILITY, (Object)ability_pressed);
    }

    public boolean isRenderedOnGUI() {
        return this.renderedOnGUI;
    }

    public void setIsRenderedOnGUI(boolean renderedOnGUI) {
        this.renderedOnGUI = renderedOnGUI;
    }

    protected boolean m_6107_() {
        return false;
    }

    public float getRideCameraDistanceBack() {
        return 4.0f;
    }

    public float getRideCameraDistanceVert() {
        return 1.2f;
    }

    public float getRideCameraDistanceHoriz() {
        return 0.0f;
    }

    public float getRideCameraDistanceFront() {
        return this.getRideCameraDistanceBack();
    }

    protected double getFollowDistance() {
        return this.m_21133_(Attributes.f_22277_);
    }

    public boolean isWaterBelow() {
        BlockPos waterPos = new BlockPos(this.m_20182_().f_82479_, this.m_20182_().f_82480_ - 3.0, this.m_20182_().f_82481_);
        return this.f_19853_.m_8055_(waterPos).m_60734_() instanceof LiquidBlock;
    }

    public boolean isOnJumpHeight() {
        BlockPos solidPos = new BlockPos(this.m_20182_().f_82479_, this.m_20182_().f_82480_ - 6.0, this.m_20182_().f_82481_);
        return !this.f_19853_.m_8055_(solidPos).m_60795_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22277_, 7.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0);
    }

    public AABB getTargetSearchArea(double distance) {
        return this.m_142469_().m_82377_(distance, distance, distance);
    }

    public double m_20204_() {
        return (double)this.m_20192_() < 0.4 ? 0.0 : 0.2;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FollowOwnerNoTPGoal(this, 1.1, 4.0f, 4.0f, false));
        this.f_21345_.m_25352_(2, (Goal)new DragonRideTilTamed(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new DragonBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)this.getMeleeAttackGoal());
        this.f_21345_.m_25352_(6, (Goal)new DragonWaterAvoidingRandomStrollGoal(this, 0.7, 1.0000001E-5f));
        this.f_21345_.m_25352_(7, (Goal)new IOBLookAtPlayerGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new IOBRandomLookAroundGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new DragonOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(1, (Goal)new DragonHurtByTargetGoal(this, new Class[0]));
        this.f_21346_.m_25352_(2, new AggressionToPlayersGoal<Player>(this, Player.class, true, this.getAggressionType(), null));
    }

    protected DragonMeleeAttackGoal getMeleeAttackGoal() {
        return new DragonMeleeAttackGoal(this, 1.0, false);
    }

    protected boolean isItemStackForTaming(ItemStack stack) {
        return stack.m_150930_(Items.f_42579_);
    }

    protected int getAggressionType() {
        return 0;
    }

    protected int getInLoveCoolDownInMCDays() {
        return 2;
    }

    public void m_27595_(@Nullable Player pPlayer) {
        super.m_27595_(pPlayer);
    }

    protected boolean isCommandItems(ItemStack stack) {
        return stack.m_150930_(Items.f_42398_);
    }

    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.isCommandItems(itemstack) && this.m_21830_((LivingEntity)pPlayer) && this.m_21824_()) {
            this.modifyCommand(2, pPlayer);
            return InteractionResult.SUCCESS;
        }
        if (this.isBreedingFood(itemstack) && !this.shouldStopMovingIndependently()) {
            if (this.m_21830_((LivingEntity)pPlayer)) {
                int i = this.m_146764_();
                if (!this.f_19853_.f_46443_ && i == 0 && this.m_5957_()) {
                    this.m_142075_(pPlayer, pHand, itemstack);
                    this.m_27595_(pPlayer);
                    this.m_146859_(GameEvent.f_157771_, this.m_146901_());
                    return InteractionResult.SUCCESS;
                }
            } else {
                String string = "iob.only.owner.breed";
                pPlayer.m_5661_((Component)new TranslatableComponent(string), false);
                return InteractionResult.FAIL;
            }
        }
        this.setSleepDisturbTicks(Util.minutesToSeconds(4));
        return super.m_6071_(pPlayer, pHand);
    }

    public InteractionResult m_21499_(Player pPlayer, InteractionHand pHand) {
        InteractionResult interactionresult;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_150930_(Items.f_42655_) && this.m_6573_(pPlayer)) {
            this.m_21463_((Entity)pPlayer, true);
            itemstack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (itemstack.m_150930_(Items.f_42656_) && this.m_21830_((LivingEntity)pPlayer) && (interactionresult = itemstack.m_41647_(pPlayer, (LivingEntity)this, pHand)).m_19077_()) {
            return interactionresult;
        }
        if (itemstack.m_41720_() instanceof SpawnEggItem) {
            if (this.f_19853_ instanceof ServerLevel) {
                SpawnEggItem spawneggitem = (SpawnEggItem)itemstack.m_41720_();
                Optional optional = spawneggitem.m_43215_(pPlayer, (Mob)this, this.m_6095_(), (ServerLevel)this.f_19853_, this.m_20182_(), itemstack);
                optional.ifPresent(p_21476_ -> this.m_5502_(pPlayer, (Mob)p_21476_));
                return optional.isPresent() ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public boolean shouldStopMovingIndependently() {
        return this.isDragonSleeping() || this.isDragonSitting() || this.isDragonIncapacitated() && !this.m_20160_();
    }

    public void m_6674_(@NotNull InteractionHand pHand) {
        this.m_21011_(pHand, true);
        this.setTicksSinceLastAttack(0);
    }

    public boolean m_7327_(@NotNull Entity pEntity) {
        this.playAttackSound();
        return super.m_7327_(pEntity);
    }

    protected void playAttackSound() {
        this.m_5496_(this.get1stAttackSound(), 1.0f, 1.0f);
    }

    public void m_6710_(@org.jetbrains.annotations.Nullable LivingEntity pLivingEntity) {
        if (!this.isDragonDisabled()) {
            super.m_6710_(pLivingEntity);
        }
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        Entity entity;
        this.setSleepDisturbTicks(500);
        this.setAbilityDisturbTicksAbility(500);
        if (pAmount > 0.0f && !this.m_21824_() && (entity = pSource.m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            this.m_6710_((LivingEntity)player);
        }
        if (pSource.m_7639_() != null && pSource.m_7639_().m_20202_() == this) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_21011_(InteractionHand pHand, boolean pUpdateSelf) {
        super.m_21011_(pHand, pUpdateSelf);
    }

    public void m_21828_(Player pPlayer) {
        this.m_6710_(null);
        this.m_21530_();
        super.m_21828_(pPlayer);
    }

    public boolean isTamingPhaseBarFull() {
        return this.getFoodTameLimiterBar() >= this.getFoodTamingPhaseMaximumLevel();
    }

    public boolean isNocturnal() {
        return false;
    }

    public void m_8119_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8119_();
        if (this.isDragonSitting()) {
            this.m_21839_(true);
        }
        if (!this.isDragonSitting()) {
            this.m_21839_(false);
        }
        if (this.shouldStopMovingIndependently()) {
            this.m_21573_().m_26573_();
            this.m_21573_().m_26564_();
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        if (this.getSleepDisturbTicks() > 0) {
            this.setSleepDisturbTicks(this.getSleepDisturbTicks() - 1);
        }
        if (this.getAbilityDisturbTicks() > 0) {
            this.setAbilityDisturbTicksAbility(this.getAbilityDisturbTicks() - 1);
        }
        if (this.getTicksSinceLastAttack() >= 0) {
            this.setTicksSinceLastAttack(this.getTicksSinceLastAttack() + 1);
            if (this.getTicksSinceLastAttack() > 1000) {
                this.setTicksSinceLastAttack(-1);
            }
        }
        if (this.f_19853_.m_5776_()) {
            this.updateClientControls();
        }
        if (!this.m_21824_()) {
            if (this.f_19853_.f_46441_.nextInt(85) == 1 && !this.isPhaseTwo()) {
                this.modifyFoodTamingLimiterBar(-1);
            }
            if (this.f_19853_.f_46441_.nextInt(600) == 1 && this.getPhase1Progress() < 95) {
                this.modifyPhase1Progress(-1);
            }
        }
        if (!this.f_19853_.m_5776_() && this.m_21223_() < this.m_21233_() && this.f_19796_.nextInt(150) == 1 && (!this.isDragonIncapacitated() || this.m_21824_())) {
            this.m_5634_(5.0f);
        }
        if ((livingEntity = this.m_5448_()) instanceof Player && (player = (Player)livingEntity).m_7500_()) {
            this.m_6710_(null);
        }
        if (this.f_19797_ % 1200 == 0) {
            this.sleepMechanics();
        }
        this.onGroundMechanics();
        this.airSpaceMechanics();
    }

    protected void airSpaceMechanics() {
        int start = 2;
        Vec3 pos = this.m_20182_();
        for (int xz1 = -start + 1; xz1 < start; ++xz1) {
            for (int xz4 = -start + 1; xz4 < start; ++xz4) {
                BlockPos pos1 = new BlockPos(pos.m_82520_((double)xz1, 1.0, (double)xz1));
                BlockPos pos2 = new BlockPos(pos.m_82520_((double)(-xz4), 1.0, (double)xz4));
                BlockPos pos3 = new BlockPos(pos.m_82520_((double)xz1, 2.0, (double)xz1));
                BlockPos pos4 = new BlockPos(pos.m_82520_((double)(-xz4), 2.0, (double)xz4));
                if (this.f_19853_.m_8055_(pos1).m_60767_().m_76334_() || this.f_19853_.m_8055_(pos2).m_60767_().m_76334_() || this.f_19853_.m_8055_(pos3).m_60767_().m_76334_() || this.f_19853_.m_8055_(pos4).m_60767_().m_76334_()) {
                    this.setIsDragonOnAirspaceClear(false);
                    continue;
                }
                this.setIsDragonOnAirspaceClear(true);
            }
        }
    }

    protected void onGroundMechanics() {
        BlockPos pos1 = new BlockPos(this.m_20182_().m_82520_(0.0, -1.0, 0.0));
        BlockPos pos2 = new BlockPos(this.m_20182_().m_82520_(0.0, -2.0, 0.0));
        BlockPos pos3 = new BlockPos(this.m_20182_().m_82520_(0.0, -3.0, 0.0));
        if (this.f_19853_.m_8055_(pos1).m_60767_().m_76333_() || this.f_19853_.m_8055_(pos2).m_60767_().m_76333_() || this.f_19853_.m_8055_(pos3).m_60767_().m_76333_() || this.f_19853_.m_8055_(pos1).m_60767_().m_76333_() && !this.f_19853_.m_8055_(pos3).m_60767_().m_76333_() || this.f_19853_.m_8055_(pos1).m_60767_().m_76332_() || this.f_19853_.m_8055_(pos2).m_60767_().m_76332_() || this.f_19853_.m_8055_(pos3).m_60767_().m_76332_() || this.f_19853_.m_8055_(pos1).m_60767_().m_76332_() && !this.f_19853_.m_8055_(pos3).m_60767_().m_76332_() && this.groundDragon()) {
            this.setIsDragonOnGround(true);
        } else {
            this.setIsDragonOnGround(false);
        }
    }

    protected boolean groundDragon() {
        return true;
    }

    public boolean m_20067_() {
        return super.m_20067_() || this.isDragonDisabled();
    }

    protected void sleepMechanics() {
        if (!this.f_19853_.m_5776_()) {
            if (this.isDragonSitting()) {
                this.setIsDragonSleeping(this.isNocturnal() ? this.f_19853_.m_46461_() : !this.f_19853_.m_46461_());
            } else {
                this.setIsDragonSleeping(false);
            }
        }
    }

    public void m_146922_(float pYRot) {
        if (!this.shouldStopMovingIndependently()) {
            super.m_146922_(pYRot);
        }
    }

    public boolean canWearArmor() {
        return true;
    }

    public Vec3 getThroatPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        double x = -Math.sin((double)this.f_20883_ * Math.PI / 180.0) * 2.4;
        double y = 1.5;
        double z = Math.cos((double)this.f_20883_ * Math.PI / 180.0) * 2.4;
        float scale = this.m_6162_() ? 0.2f : 1.0f;
        Vec3 throatPos = bodyOrigin.m_82549_(new Vec3(x * (double)scale, y * (double)scale, z * (double)scale));
        return throatPos;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public boolean isBreedingFood(ItemStack pStack) {
        return pStack.m_150930_(Items.f_42718_);
    }

    public boolean m_6898_(ItemStack pStack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateClientControls() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92089_.m_90857_()) {
            ControlNetwork.INSTANCE.sendToServer((Object)new ControlMessageJumping(true, this.m_142049_()));
        } else {
            ControlNetwork.INSTANCE.sendToServer((Object)new ControlMessageJumping(false, this.m_142049_()));
        }
        if (ModKeyBinds.keyAbilty.m_90857_()) {
            ControlNetwork.INSTANCE.sendToServer((Object)new ControlMessageAbility(true, this.m_142049_()));
        } else {
            ControlNetwork.INSTANCE.sendToServer((Object)new ControlMessageAbility(false, this.m_142049_()));
        }
        if (ModKeyBinds.keySecondAbilty.m_90857_()) {
            ControlNetwork.INSTANCE.sendToServer((Object)new ControlMessageSECONDAbility(true, this.m_142049_()));
        } else {
            ControlNetwork.INSTANCE.sendToServer((Object)new ControlMessageSECONDAbility(false, this.m_142049_()));
        }
        if (ModKeyBinds.keyDown.m_90857_()) {
            ControlNetwork.INSTANCE.sendToServer((Object)new ControlMessageGoingDown(true, this.m_142049_()));
        } else {
            ControlNetwork.INSTANCE.sendToServer((Object)new ControlMessageGoingDown(false, this.m_142049_()));
        }
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean isFoodEdibleToDragon(ItemStack pStack) {
        Item item = pStack.m_41720_();
        return pStack.m_150930_(Items.f_42527_) || pStack.m_150930_(Items.f_42526_) || pStack.m_150930_(Items.f_42583_) || pStack.m_150930_(Items.f_42528_) || pStack.m_150930_(Items.f_42529_) || this.isItemStackForTaming(pStack) || item.m_41472_() && item.m_41473_().m_38746_() && item.m_41473_() != null && !pStack.m_41619_();
    }

    public int getMaxTemper() {
        return 100;
    }

    public BlockPos getHomePos() {
        return this.homePos;
    }

    public void setHomePos(BlockPos homePos) {
        this.homePos = homePos;
    }

    public void modifyFoodTamingLimiterBar(int x) {
        int i = Mth.m_14045_((int)(this.getFoodTameLimiterBar() + x), (int)0, (int)this.getFoodTamingPhaseMaximumLevel());
        this.setFoodTameLimiterBar(i);
    }

    public void modifyPhase1Progress(int x) {
        int i = Mth.m_14045_((int)(this.getPhase1Progress() + x), (int)0, (int)100);
        this.setPhase1Progress(i);
    }

    public void makeMad() {
    }

    public boolean m_21532_() {
        return false;
    }

    public int getCurrentAttackType() {
        return (Integer)this.f_19804_.m_135370_(CURRENT_ATTACK);
    }

    public void setCurrentAttackType(int currentAttack) {
        this.f_19804_.m_135381_(CURRENT_ATTACK, (Object)currentAttack);
    }

    protected void performInCapacitate() {
        if ((double)this.m_21223_() < (double)this.m_21233_() * 0.3 && !this.m_21824_()) {
            this.setIsDragonIncapacitated(true);
        } else {
            this.setIsDragonIncapacitated(false);
        }
    }

    @org.jetbrains.annotations.Nullable
    public ADragonEggBase getBreedEggResult(ServerLevel level, @NotNull AgeableMob parent) {
        StingerEgg dragon = (StingerEgg)((EntityType)ModEntities.STINGER_EGG.get()).m_20615_((Level)level);
        return dragon;
    }

    public int getMaxAmountOfVariants() {
        return 0;
    }

    public void m_27594_() {
        super.m_27594_();
    }

    public void m_27563_(ServerLevel serverLevel, Animal partner) {
        if (partner instanceof ADragonBase) {
            BabyEntitySpawnEvent event;
            boolean cancelled;
            ADragonBase dragonPartner = (ADragonBase)partner;
            ADragonEggBase egg = this.getBreedEggResult(serverLevel, (AgeableMob)dragonPartner);
            if (this.m_6095_().getRegistryName() != null && (this.m_6095_().getRegistryName().equals((Object)new ResourceLocation("isleofberk", "night_fury")) && partner.m_6095_().getRegistryName().equals((Object)new ResourceLocation("isleofberk", "light_fury")) || this.m_6095_().getRegistryName().equals((Object)new ResourceLocation("isleofberk", "light_fury")) && partner.m_6095_().getRegistryName().equals((Object)new ResourceLocation("isleofberk", "night_fury")))) {
                egg = (ADragonEggBase)((EntityType)ModEntities.NIGHT_LIGHT_EGG.get()).m_20615_((Level)serverLevel);
            }
            if (cancelled = MinecraftForge.EVENT_BUS.post((Event)(event = new BabyEntitySpawnEvent((Mob)this, (Mob)partner, (AgeableMob)egg)))) {
                this.m_146762_(Util.mcDaysToMinutes(this.getInLoveCoolDownInMCDays()));
                dragonPartner.m_146762_(Util.mcDaysToMinutes(this.getInLoveCoolDownInMCDays()));
                this.m_27594_();
                partner.m_27594_();
                return;
            }
            if (egg != null) {
                ServerPlayer serverplayer = this.m_27592_();
                if (serverplayer == null && partner.m_27592_() != null) {
                    serverplayer = partner.m_27592_();
                }
                if (serverplayer != null) {
                    serverplayer.m_36220_(Stats.f_12937_);
                    CriteriaTriggers.f_10581_.m_147278_(serverplayer, (Animal)this, partner, (AgeableMob)egg);
                }
                this.m_146762_(Util.mcDaysToMinutes(this.getInLoveCoolDownInMCDays()));
                dragonPartner.m_146762_(Util.mcDaysToMinutes(this.getInLoveCoolDownInMCDays()));
                this.m_27594_();
                partner.m_27594_();
                egg.m_6863_(true);
                egg.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                this.f_19853_.m_7967_((Entity)egg);
                this.f_19853_.m_7605_((Entity)this, (byte)18);
                if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
                    this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_21187_().nextInt(7) + 1));
                }
            }
        }
    }

    public int getExplosionStrength() {
        return 0;
    }

    private float getPartialTick() {
        return Minecraft.m_91087_().m_91296_();
    }

    public float getProjectileDamage(ADragonBase dragon, Entity entity, BaseLinearFlightProjectile projectile) {
        return 15.0f;
    }

    public boolean tameWithName(Player pPlayer) {
        this.m_21816_(pPlayer.m_142081_());
        this.m_7105_(true);
        if (pPlayer instanceof ServerPlayer) {
            CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)pPlayer, (Animal)this);
        }
        this.m_5496_(this.getTameSound(), 3.0f, 1.0f);
        this.modifyPhase1Progress(100);
        this.f_19853_.m_7605_((Entity)this, (byte)7);
        return true;
    }

    protected SoundEvent getTameSound() {
        return null;
    }

    protected SoundEvent get1stAttackSound() {
        return null;
    }

    protected SoundEvent get2ndAttackSound() {
        return null;
    }

    protected SoundEvent getProjectileSound() {
        return null;
    }

    public void playProjectileSound() {
        this.m_5496_(this.getProjectileSound(), 3.0f, 1.0f);
    }

    protected void m_6677_(@NotNull DamageSource pSource) {
        SoundEvent soundevent = this.m_7975_(pSource);
        if (soundevent != null) {
            if (pSource.m_7639_() instanceof LivingEntity) {
                this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
            } else {
                this.m_5496_(SoundEvents.f_11915_, this.m_6121_(), this.m_6100_());
            }
        }
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return null;
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    public int m_8100_() {
        return 1400;
    }

    protected void addParticlesAroundSelf(ParticleOptions p_36209_) {
        for (int i = 0; i < 4; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_(p_36209_, this.getRandomThroatX(!this.m_6162_() ? 0.4 : 0.1), this.getThroatRandomY(0.4), this.getThroatRandomZ(0.4), d0, d1, d2);
        }
    }

    public double m_20165_(double pScale) {
        return this.getThroatPos((ADragonBase)this).f_82479_ + (double)this.m_20205_() * pScale;
    }

    public double getRandomThroatX(double pScale) {
        return this.getThroatPos((ADragonBase)this).f_82479_ + (2.0 * this.f_19796_.nextDouble() - 1.0) * pScale;
    }

    public double m_20227_(double pScale) {
        return this.getThroatPos((ADragonBase)this).f_82480_ + (double)this.m_20206_() * pScale;
    }

    public double getThroatRandomY(double pScale) {
        return this.getThroatPos((ADragonBase)this).f_82480_ + (double)this.m_20206_() * pScale;
    }

    public double m_20246_(double pScale) {
        return this.getThroatPos((ADragonBase)this).f_82481_ + (double)this.m_20205_() * pScale;
    }

    public double getThroatRandomZ(double pScale) {
        return this.getThroatPos((ADragonBase)this).f_82481_ + (2.0 * this.f_19796_.nextDouble() - 1.0) * pScale;
    }

    public float getChangeInYaw() {
        return ((Float)this.f_19804_.m_135370_(CHANGE_IN_YAW)).floatValue();
    }

    public void setChangeInYaw(float changeInYaw) {
        this.f_19804_.m_135381_(CHANGE_IN_YAW, (Object)Float.valueOf(changeInYaw));
    }

    public float getSoundPitch() {
        return this.m_6162_() ? 1.4f : 1.0f;
    }

    public static class DragonPart
    extends PartEntity<ADragonBase> {
        ADragonBase parent;
        EntityDimensions size;
        public final String name;

        public DragonPart(ADragonBase parent, String name, float sizeX, float sizeY) {
            super((Entity)parent);
            this.size = EntityDimensions.m_20395_((float)sizeX, (float)sizeY);
            this.parent = parent;
            this.name = name;
            this.m_6210_();
        }

        protected void m_8097_() {
        }

        protected void m_7378_(CompoundTag pCompound) {
        }

        protected void m_7380_(CompoundTag pCompound) {
        }

        public boolean m_6087_() {
            return true;
        }

        public boolean m_6469_(DamageSource pSource, float pAmount) {
            LivingEntity rider;
            Entity entity = pSource.m_7639_();
            if (entity instanceof LivingEntity && (pSource.equals(DamageSource.m_19370_((LivingEntity)(rider = (LivingEntity)entity))) || rider.m_20202_() == this.parent)) {
                return false;
            }
            return (!this.m_6673_(pSource) || Objects.requireNonNull(entity).m_20202_() == this.parent) && this.parent.m_6469_(pSource, pAmount);
        }

        public boolean m_7306_(@NotNull Entity pEntity) {
            return this == pEntity || this.parent == pEntity;
        }

        public Packet<?> m_5654_() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public EntityDimensions m_6972_(@NotNull Pose pPose) {
            return this.size;
        }

        public boolean m_142391_() {
            return false;
        }
    }
}

