/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.base.dragon;

import com.GACMD.isleofberk.entity.AI.flight.own.AIDragonLand;
import com.GACMD.isleofberk.entity.AI.flight.own.DragonFlyAndAttackAirbourneTargetGoal;
import com.GACMD.isleofberk.entity.AI.flight.own.UntamedDragonCircleFlightGoal;
import com.GACMD.isleofberk.entity.AI.flight.player.AIDragonRide;
import com.GACMD.isleofberk.entity.AI.flight.player.DragonFollowPlayerFlying;
import com.GACMD.isleofberk.entity.AI.path.air.DragonFlyingPathNavigation;
import com.GACMD.isleofberk.entity.AI.path.air.FlyingDragonMoveControl;
import com.GACMD.isleofberk.entity.AI.target.DragonNonTameRandomTargetGoal;
import com.GACMD.isleofberk.entity.AI.water.DragonFloatGoal;
import com.GACMD.isleofberk.entity.base.dragon.ADragonRideableUtility;
import com.GACMD.isleofberk.entity.dragons.deadlynadder.DeadlyNadder;
import com.GACMD.isleofberk.entity.dragons.gronckle.Gronckle;
import com.GACMD.isleofberk.entity.dragons.nightfury.NightFury;
import com.GACMD.isleofberk.entity.dragons.triple_stryke.TripleStryke;
import com.GACMD.isleofberk.network.ControlNetwork;
import com.GACMD.isleofberk.network.message.MessageDragonFlapSounds;
import com.GACMD.isleofberk.registery.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;

public class ADragonBaseFlyingRideable
extends ADragonRideableUtility
implements IAnimatable,
PlayerRideable {
    private static final EntityDataAccessor<Boolean> IS_FLYING = SynchedEntityData.m_135353_(ADragonBaseFlyingRideable.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TICKS_FLY_WANDERING = SynchedEntityData.m_135353_(ADragonBaseFlyingRideable.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> IN_AIR_TICKS_VEHICLE = SynchedEntityData.m_135353_(ADragonBaseFlyingRideable.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ROTATION_STATE = SynchedEntityData.m_135353_(ADragonBaseFlyingRideable.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_LANDING = SynchedEntityData.m_135353_(ADragonBaseFlyingRideable.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_GOINGUP = SynchedEntityData.m_135353_(ADragonBaseFlyingRideable.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_GOINDOWN = SynchedEntityData.m_135353_(ADragonBaseFlyingRideable.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FLAPPING = SynchedEntityData.m_135353_(ADragonBaseFlyingRideable.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> USING_SECOND_NAVIGATOR = SynchedEntityData.m_135353_(ADragonBaseFlyingRideable.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean isLandNavigator;
    public int ticksUnderwater;
    public float oFlapTime;
    public float flapTime;

    public ADragonBaseFlyingRideable(EntityType<? extends ADragonBaseFlyingRideable> entityType, Level level) {
        super(entityType, level);
        this.switchNavigator(true);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean isLanding() {
        return (Boolean)this.f_19804_.m_135370_(IS_LANDING);
    }

    public void setIsLanding(boolean isLanding) {
        this.f_19804_.m_135381_(IS_LANDING, (Object)isLanding);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(IS_FLYING);
    }

    public void setIsFlying(boolean flying) {
        this.f_19804_.m_135381_(IS_FLYING, (Object)flying);
    }

    public boolean IsUsingSecondNavigator() {
        return (Boolean)this.f_19804_.m_135370_(USING_SECOND_NAVIGATOR);
    }

    public void setIsUsingSecondNavigator(boolean usingSecondNavigator) {
        this.f_19804_.m_135381_(USING_SECOND_NAVIGATOR, (Object)usingSecondNavigator);
    }

    public int getTicksFlyWandering() {
        return (Integer)this.f_19804_.m_135370_(TICKS_FLY_WANDERING);
    }

    public void setTicksFlyWandering(int flying) {
        this.f_19804_.m_135381_(TICKS_FLY_WANDERING, (Object)flying);
    }

    public int getRotationState() {
        return (Integer)this.f_19804_.m_135370_(ROTATION_STATE);
    }

    public void setRotationState(int rotation_state) {
        this.f_19804_.m_135381_(ROTATION_STATE, (Object)rotation_state);
    }

    public int getInAirTicksVehicle() {
        return (Integer)this.f_19804_.m_135370_(IN_AIR_TICKS_VEHICLE);
    }

    public void setInAirTicksVehicle(int inAirTicks) {
        this.f_19804_.m_135381_(IN_AIR_TICKS_VEHICLE, (Object)inAirTicks);
    }

    public boolean isGoingUp() {
        return (Boolean)this.f_19804_.m_135370_(IS_GOINGUP);
    }

    public void setIsGoingUp(boolean jumping) {
        this.f_19804_.m_135381_(IS_GOINGUP, (Object)jumping);
    }

    public boolean isGoingDown() {
        return (Boolean)this.f_19804_.m_135370_(IS_GOINDOWN);
    }

    public void setIsGoingDown(boolean goingdown) {
        this.f_19804_.m_135381_(IS_GOINDOWN, (Object)goingdown);
    }

    public boolean shouldPlayFlapping() {
        return (Boolean)this.f_19804_.m_135370_(IS_FLAPPING);
    }

    public void setShouldPlayFlapping(boolean hovering) {
        this.f_19804_.m_135381_(IS_FLAPPING, (Object)hovering);
    }

    public void switchNavigator(boolean useLandNavigationController) {
        if (useLandNavigationController) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.f_19853_);
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new FlyingDragonMoveControl(this, 1, true);
            this.f_21344_ = new DragonFlyingPathNavigation(this, this.f_19853_);
            this.isLandNavigator = false;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_FLYING, (Object)false);
        this.f_19804_.m_135372_(TICKS_FLY_WANDERING, (Object)0);
        this.f_19804_.m_135372_(ROTATION_STATE, (Object)0);
        this.f_19804_.m_135372_(IN_AIR_TICKS_VEHICLE, (Object)0);
        this.f_19804_.m_135372_(IS_LANDING, (Object)false);
        this.f_19804_.m_135372_(IS_GOINGUP, (Object)false);
        this.f_19804_.m_135372_(IS_GOINDOWN, (Object)false);
        this.f_19804_.m_135372_(IS_FLAPPING, (Object)false);
        this.f_19804_.m_135372_(USING_SECOND_NAVIGATOR, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("is_flying", this.isFlying());
        pCompound.m_128379_("is_landing", this.isLanding());
        pCompound.m_128405_("ticks_fly_wandering", this.getTicksFlyWandering());
        pCompound.m_128405_("in_air_ticks_vehicle", this.getInAirTicksVehicle());
        pCompound.m_128405_("rotation_state", this.getRotationState());
        pCompound.m_128379_("is_goingup", this.isGoingUp());
        pCompound.m_128379_("is_goingdown", this.isGoingDown());
        pCompound.m_128379_("play_flapping", this.shouldPlayFlapping());
        pCompound.m_128379_("is_using_second_navigator", this.IsUsingSecondNavigator());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setIsFlying(pCompound.m_128471_("is_flying"));
        this.setIsLanding(pCompound.m_128471_("is_landing"));
        this.setTicksFlyWandering(pCompound.m_128451_("ticks_fly_wandering"));
        this.setInAirTicksVehicle(pCompound.m_128451_("in_air_ticks_vehicle"));
        this.setRotationState(pCompound.m_128451_("rotation_state"));
        this.setIsGoingUp(pCompound.m_128471_("is_goingup"));
        this.setIsGoingDown(pCompound.m_128471_("is_goingdown"));
        this.setShouldPlayFlapping(pCompound.m_128471_("play_flapping"));
        this.setIsUsingSecondNavigator(pCompound.m_128471_("is_using_second_navigator"));
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new DragonFloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new DragonFollowPlayerFlying(this, 3, 4, 3));
        this.f_21345_.m_25352_(0, (Goal)new DragonFlyAndAttackAirbourneTargetGoal(this, 1.0, true));
        this.f_21345_.m_25352_(1, (Goal)new UntamedDragonCircleFlightGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new AIDragonLand(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new AIDragonRide(this));
        this.f_21346_.m_25352_(2, new DragonNonTameRandomTargetGoal<Animal>(this, Animal.class, false, PREY_SELECTOR));
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        this.setTicksFlyWandering(200);
        return super.m_6469_(pSource, pAmount);
    }

    protected float m_6108_() {
        return 0.9f;
    }

    private double calculateFlightHeight(double xHeadRot) {
        if (this.m_20186_() < 250.0) {
            double y = this.isFlying() && (this.isGoingUp() || this.isGoingDown()) ? 0.0 : xHeadRot * -0.005;
            return y;
        }
        return 0.0;
    }

    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (this.m_6084_()) {
            if (this.m_20160_() && this.m_5807_()) {
                LivingEntity pilot = (LivingEntity)this.m_6688_();
                assert (pilot != null);
                pilot.m_5618_(pilot.m_6080_());
                this.m_146922_(pilot.m_146908_());
                if (this.isFlying()) {
                    this.m_146926_(pilot.m_146909_() * 0.5f);
                } else {
                    this.m_146926_(0.0f);
                }
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = pilot.f_20900_ * 0.5f;
                float f1 = pilot.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.m_6688_() != null) {
                    int turnState = 0;
                    float rotationSpeed = 6.0f;
                    float yawDiff = this.f_19859_ - this.m_146908_();
                    turnState = Math.abs(yawDiff) > rotationSpeed && yawDiff > 0.0f ? 1 : turnState;
                    turnState = Math.abs(yawDiff) > rotationSpeed && yawDiff > 4.0f ? 2 : turnState;
                    turnState = Math.abs(yawDiff) > rotationSpeed && yawDiff < 0.0f ? -1 : turnState;
                    turnState = Math.abs(yawDiff) > rotationSpeed && yawDiff < -4.0f ? -2 : turnState;
                    this.setRotationState(turnState);
                } else {
                    this.setRotationState(0);
                }
                this.m_21567_(pilot.f_20901_);
                float xxa = pilot.f_20900_ * 0.5f;
                float zza = pilot.f_20902_;
                double xHeadRot = this.m_146909_() > 0.0f ? (double)(this.m_146909_() / 2.0f) : (double)this.m_146909_() / 3.6;
                double xHeadRotABS = Math.abs(this.m_146909_()) / 450.0f;
                double y = xHeadRot * -0.005;
                if (zza <= 0.0f) {
                    zza *= 0.25f;
                }
                Vec3 delta = this.m_20184_();
                this.m_20334_(delta.f_82479_ / 2.0, delta.f_82480_ / 2.0, delta.f_82481_ / 2.0);
                if (zza > 0.0f) {
                    float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                    float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                    boolean isFlying = this.isFlying() && !this.m_20069_();
                    double speed = this.m_21133_(Attributes.f_22280_) * (double)(this.m_20069_() ? 0.2f : 1.02f);
                    double groundSpeed = this.m_21133_(Attributes.f_22279_) * (double)(this.m_20069_() ? 0.2f : 1.0f) / 8.0;
                    this.m_20256_(delta.m_82520_((isFlying ? -speed : -groundSpeed / 2.0 + xHeadRotABS) * (double)f2, y, (isFlying ? speed : groundSpeed / 2.0 - xHeadRotABS) * (double)f3));
                }
                if (this.isGoingUp()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, zza > 0.0f ? 0.1 : 0.3, 0.0));
                } else if (this.isGoingDown()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, zza > 0.0f ? -0.2 : -0.4, 0.0));
                }
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22280_));
                    super.m_7023_(new Vec3((double)xxa, y, (double)zza));
                } else if (pilot instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_146872_();
            } else {
                this.setRotationState(0);
                super.m_7023_(pTravelVector);
            }
        }
    }

    public boolean m_142039_() {
        float f = Mth.m_14089_((float)(this.flapTime * ((float)Math.PI * 2)));
        float f1 = Mth.m_14089_((float)(this.oFlapTime * ((float)Math.PI * 2)));
        return f1 <= -0.3f && f >= -0.3f;
    }

    public void m_142043_() {
        if (!this.m_20067_() && !this.m_20069_() && !this.m_20077_() && this.isFlying() && this.shouldPlayFlapping()) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getFlapSound(), this.m_5720_(), this.getFlapVol(), this.getFlapPitch() + this.f_19796_.nextFloat() * 0.3f, false);
        }
    }

    protected float getFlapVol() {
        return 6.0f;
    }

    protected float getFlapPitch() {
        return 0.4f;
    }

    protected SoundEvent getFlapSound() {
        return (SoundEvent)ModSounds.DEADLY_NADDER_FLAP.get();
    }

    public void m_8032_() {
        SoundEvent soundevent;
        if (!this.isFlying() && (soundevent = this.m_7515_()) != null) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
        }
    }

    protected SoundEvent getRoarSound() {
        return null;
    }

    public void m_8107_() {
        super.m_8107_();
        this.oFlapTime = this.flapTime;
        this.flapTime += this.getFlapSpeedPerFlyingDragon();
    }

    private float getFlapSpeedPerFlyingDragon() {
        if (this instanceof Gronckle) {
            return 0.09f;
        }
        if (this instanceof DeadlyNadder) {
            return 0.046f;
        }
        if (this instanceof NightFury) {
            return 0.042f;
        }
        if (this instanceof TripleStryke) {
            return 0.042f;
        }
        return 0.042f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isDragonIncapacitated()) {
            this.setIsFlying(false);
        }
        if (this.isFlying() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.isFlying() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.isFlying()) {
            this.m_20242_(true);
        } else {
            this.m_20242_(false);
        }
        if (this.f_19853_.m_5776_()) {
            boolean playFlap = this.shouldPlayFlapping();
            int id = this.m_142049_();
            ControlNetwork.INSTANCE.sendToServer((Object)new MessageDragonFlapSounds(playFlap, id));
        }
        if (this.getTicksFlyWandering() > -10) {
            this.setTicksFlyWandering(this.getTicksFlyWandering() - 1);
        }
    }

    @Override
    protected void onGroundMechanics() {
        int start = 4;
        Vec3 pos = this.m_20182_();
        for (int xz1 = -start + 1; xz1 < start; ++xz1) {
            for (int xz4 = -start + 1; xz4 < start; ++xz4) {
                BlockPos pos1 = new BlockPos(pos.m_82520_((double)xz1, -1.0, (double)xz1));
                BlockPos pos2 = new BlockPos(pos.m_82520_((double)(-xz4), -1.0, (double)xz4));
                BlockPos pos3 = new BlockPos(pos.m_82520_((double)xz1, -2.0, (double)xz1));
                BlockPos pos4 = new BlockPos(pos.m_82520_((double)(-xz4), -2.0, (double)xz4));
                if (this.f_19853_.m_8055_(pos1).m_60767_().m_76334_() || this.f_19853_.m_8055_(pos2).m_60767_().m_76334_() || this.f_19853_.m_8055_(pos3).m_60767_().m_76334_() || this.f_19853_.m_8055_(pos4).m_60767_().m_76334_()) {
                    this.setIsDragonOnGround(true);
                    continue;
                }
                this.setIsDragonOnGround(false);
            }
        }
    }

    public boolean m_6146_() {
        return true;
    }

    public void circleEntity(Vec3 target, float radius, float speed, boolean direction, int circleFrame, float offset, float moveSpeedMultiplier) {
        int directionInt = direction ? 1 : -1;
        double t = (double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
        Vec3 movePos = target.m_82520_((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
        this.m_21573_().m_26519_(movePos.m_7096_(), movePos.m_7098_(), movePos.m_7094_(), (double)(speed * moveSpeedMultiplier));
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    @Override
    protected boolean groundDragon() {
        return false;
    }
}

