/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.base.dragon;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import com.GACMD.isleofberk.entity.dragons.terrible_terror.TerribleTerror;
import com.GACMD.isleofberk.entity.projectile.breath_user.firebreaths.FireBreathProjectile;
import com.GACMD.isleofberk.util.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ADragonBaseFlyingRideableBreathUser
extends ADragonBaseFlyingRideable {
    private static final EntityDataAccessor<Integer> FRST_FUEL = SynchedEntityData.m_135353_(ADragonBaseFlyingRideableBreathUser.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SEC_FUEL = SynchedEntityData.m_135353_(ADragonBaseFlyingRideableBreathUser.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> F_BREATHING_TICKS = SynchedEntityData.m_135353_(ADragonBaseFlyingRideableBreathUser.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int fBreathingTickst = 0;

    public ADragonBaseFlyingRideableBreathUser(EntityType<? extends ADragonBaseFlyingRideable> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FRST_FUEL, (Object)this.getMaxFuel());
        this.f_19804_.m_135372_(SEC_FUEL, (Object)this.getMaxSecondFuel());
        this.f_19804_.m_135372_(F_BREATHING_TICKS, (Object)0);
    }

    public int getRemainingFuel() {
        return (Integer)this.f_19804_.m_135370_(FRST_FUEL);
    }

    public void setRemainingFuel(int fuel) {
        this.f_19804_.m_135381_(FRST_FUEL, (Object)fuel);
    }

    public int getMaxFuel() {
        return 280;
    }

    public int getRemainingSecondFuel() {
        return (Integer)this.f_19804_.m_135370_(SEC_FUEL);
    }

    public void setRemainingSecondFuel(int fuel) {
        this.f_19804_.m_135381_(SEC_FUEL, (Object)fuel);
    }

    public int getFRemainingTicks() {
        return (Integer)this.f_19804_.m_135370_(F_BREATHING_TICKS);
    }

    public void setFRemainingTicks(int fuel) {
        this.f_19804_.m_135381_(F_BREATHING_TICKS, (Object)fuel);
    }

    public int getMaxSecondFuel() {
        return 25;
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setRemainingFuel(pCompound.m_128451_("remaining_fuel"));
        this.setRemainingSecondFuel(pCompound.m_128451_("remaining_fuel2"));
        this.setFRemainingTicks(pCompound.m_128451_("fBreathingTickst"));
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("remaining_fuel", this.getRemainingFuel());
        pCompound.m_128405_("remaining_fuel2", this.getRemainingSecondFuel());
        pCompound.m_128405_("fBreathingTickst", this.getFRemainingTicks());
    }

    protected boolean canUseBreathNormally() {
        return true;
    }

    protected int breathBarRegenSpeed() {
        return 30;
    }

    protected int secondAbilityRegenSpeed() {
        return 200;
    }

    protected int breathBarRegenAmount() {
        return 2;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            Entity entity;
            if (this.isUsingAbility()) {
                if (this.m_6688_() != null) {
                    this.modifyFuel(-1);
                }
            } else if (this.f_19797_ % this.breathBarRegenSpeed() == 0) {
                this.modifyFuel(this.breathBarRegenAmount());
            }
            if (this.f_19797_ % this.secondAbilityRegenSpeed() == 0) {
                this.modifySecondaryFuel(4);
            }
            if (this.m_6688_() != null && (entity = this.m_6688_()) instanceof Player) {
                Player rider = (Player)entity;
                if (this.canUseBreathNormally()) {
                    Vec3 throat = this.getThroatPos(this);
                    Vec3 riderLook = rider.m_20252_(1.0f);
                    if (this.isUsingAbility() && this.canUseBreath()) {
                        this.firePrimary(riderLook, throat);
                    }
                    if (this.isUsingSECONDAbility() && this.canSpamSecondaryFire()) {
                        this.fireSecondary(riderLook, throat);
                    }
                }
            }
            if (this.getFRemainingTicks() > 0) {
                this.setFRemainingTicks(this.getFRemainingTicks() - 1);
            }
            if (this.m_5448_() != null && this.m_5448_().m_21233_() > 18.0f && !(this.m_5448_() instanceof AbstractFish) && (!(this.m_6688_() instanceof Player) || !(this.m_20202_() instanceof Player) && this instanceof TerribleTerror)) {
                if (this.m_21187_().nextInt(8) == 1 && this.getFRemainingTicks() <= 0 && this.getRemainingFuel() > 0) {
                    this.setFRemainingTicks(Util.secondsToTicks(3));
                }
                if (this.getFRemainingTicks() > 0) {
                    this.firePrimary(this.m_20252_(1.0f), this.getThroatPos(this));
                    this.setIsUsingAbility(true);
                    this.modifyFuel(-1);
                }
            }
            if (this instanceof TerribleTerror && this.m_20202_() instanceof Player) {
                this.setIsUsingAbility(false);
            } else if (this.getFRemainingTicks() <= 0 && this.m_6688_() == null) {
                this.setIsUsingAbility(false);
            }
        }
    }

    public void firePrimary(Vec3 riderLook, Vec3 throat) {
        if (this.f_19796_.nextInt(3) == 1) {
            FireBreathProjectile fireProj = new FireBreathProjectile(this, throat, riderLook, this.f_19853_);
            fireProj.shoot(riderLook, 1.0f, 3.0);
            fireProj.setProjectileSize(1);
            this.playProjectileSound();
            this.f_19853_.m_7967_((Entity)fireProj);
        }
    }

    @Override
    public void playProjectileSound() {
        if (this.f_19796_.nextInt(25) == 1) {
            this.m_5496_(this.getProjectileSound(), 3.0f, 1.0f);
        }
    }

    public void fireSecondary(Vec3 riderLook, Vec3 throat) {
    }

    protected boolean canUseBreath() {
        return this.getRemainingFuel() > 0 && !this.m_6162_();
    }

    protected boolean canSpamSecondaryFire() {
        Player player;
        Entity entity;
        if (this.m_6688_() != null && (entity = this.m_6688_()) instanceof Player && (player = (Player)entity).m_7500_()) {
            return true;
        }
        return this.getRemainingSecondFuel() > 0;
    }

    public void modifyFuel(int x) {
        int i = Mth.m_14045_((int)(this.getRemainingFuel() + x), (int)0, (int)this.getMaxFuel());
        this.setRemainingFuel(i);
    }

    public void modifySecondaryFuel(int x) {
        int i = Mth.m_14045_((int)(this.getRemainingSecondFuel() + x), (int)0, (int)this.getMaxSecondFuel());
        this.setRemainingSecondFuel(i);
    }
}

