/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.base.dragon;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import com.GACMD.isleofberk.entity.projectile.abase.BaseLinearFlightProjectile;
import com.GACMD.isleofberk.entity.projectile.proj_user.fire_bolt.FireBolt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ADragonBaseFlyingRideableProjUser
extends ADragonBaseFlyingRideable {
    int explosionStrength;
    int projSize;
    public int playerBoltBlastPendingScale = 0;
    public int playerBoltBlastPendingStopThreshold = 0;
    protected static final EntityDataAccessor<Integer> TICK_SINCE_LAST_FIRE = SynchedEntityData.m_135353_(ADragonBaseFlyingRideableProjUser.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> MARK_FIRED = SynchedEntityData.m_135353_(ADragonBaseFlyingRideableProjUser.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public ADragonBaseFlyingRideableProjUser(EntityType<? extends ADragonBaseFlyingRideable> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public int getExplosionStrength() {
        return this.explosionStrength;
    }

    public void setExplosionStrength(int explosionStrength) {
        this.explosionStrength = explosionStrength;
    }

    public int getProjsSize() {
        return this.projSize;
    }

    public void setProjsSize(int projSize) {
        this.projSize = projSize;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TICK_SINCE_LAST_FIRE, (Object)0);
        this.f_19804_.m_135372_(MARK_FIRED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("markFired", this.isMarkFired());
        pCompound.m_128405_("ticksFire", this.getTicksSinceLastFire());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTicksSinceLastFire(pCompound.m_128451_("ticksFire"));
        this.setMarkFired(pCompound.m_128471_("markFired"));
    }

    public boolean isMarkFired() {
        return (Boolean)this.f_19804_.m_135370_(MARK_FIRED);
    }

    public void setMarkFired(boolean fired) {
        this.f_19804_.m_135381_(MARK_FIRED, (Object)fired);
    }

    public int getTicksSinceLastFire() {
        return (Integer)this.f_19804_.m_135370_(TICK_SINCE_LAST_FIRE);
    }

    public void setTicksSinceLastFire(int pType) {
        this.f_19804_.m_135381_(TICK_SINCE_LAST_FIRE, (Object)pType);
    }

    @Override
    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        Vec3 throat = this.getThroatPos(this);
        if (this.m_6688_() != null && (entity = this.m_6688_()) instanceof Player) {
            Player rider = (Player)entity;
            Vec3 riderLook = rider.m_20252_(1.0f);
            int ticksLimit = this.getMaxPlayerBoltBlast();
            if (this.m_6688_() != null) {
                if (this.isUsingAbility()) {
                    ++this.playerBoltBlastPendingStopThreshold;
                    if (this.playerBoltBlastPendingScale <= ticksLimit + 1 && (double)this.playerBoltBlastPendingStopThreshold < (double)ticksLimit * 1.1) {
                        ++this.playerBoltBlastPendingScale;
                    }
                    if ((double)this.playerBoltBlastPendingStopThreshold > (double)ticksLimit * 1.05 && (double)this.playerBoltBlastPendingScale > (double)ticksLimit * 0.55) {
                        this.setPlayerBoltBlastPendingScale(this.playerBoltBlastPendingScale -= 4);
                    }
                } else if (this.playerBoltBlastPendingScale > 0) {
                    --this.playerBoltBlastPendingScale;
                    --this.playerBoltBlastPendingStopThreshold;
                }
            }
            if (this.canFireProj()) {
                this.playerFireProjectile(riderLook, throat);
            }
            if (!this.isUsingAbility()) {
                this.setPlayerBoltBlastPendingStopThreshold(0);
            }
        }
        if (!this.f_19853_.m_5776_()) {
            if (this.m_5448_() != null && this.m_5448_().m_21233_() > 18.0f && !(this.m_5448_() instanceof AbstractFish) && !(this.m_6688_() instanceof Player) && this.m_21187_().nextInt(this.getChanceToFire()) == 1) {
                this.setPlayerBoltBlastPendingScale((int)((float)this.getMaxPlayerBoltBlast() * this.getAIProjPowerPercentage()));
                this.dragonShootProjectile(this.m_20252_(1.0f), this.getThroatPos(this));
            }
            if (this.getTicksSinceLastFire() > 0) {
                this.setTicksSinceLastFire(this.getTicksSinceLastFire() - 1);
            }
            if (this.getTicksSinceLastFire() < 2) {
                this.setMarkFired(false);
            } else {
                this.setMarkFired(true);
            }
        }
    }

    protected int ticksSinceLastProjShootSet() {
        return 20;
    }

    protected int getChanceToFire() {
        return 60;
    }

    protected float getAIProjPowerPercentage() {
        return 0.85f;
    }

    @Override
    public float getProjectileDamage(ADragonBase dragon, Entity entity, BaseLinearFlightProjectile projectile) {
        if (projectile.getDamageTier() == 1) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.05f);
            } else {
                f = 0.0f;
            }
            return 20.0f + f;
        }
        if (projectile.getDamageTier() == 2) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.08f);
            } else {
                f = 0.0f;
            }
            return 21.0f + f;
        }
        if (projectile.getDamageTier() == 3) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.1f);
            } else {
                f = 0.0f;
            }
            return 22.0f + f;
        }
        if (projectile.getDamageTier() == 4) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.11f);
            } else {
                f = 0.0f;
            }
            return 22.0f + f;
        }
        return 22.0f;
    }

    public boolean canFireProj() {
        return !this.m_6162_();
    }

    protected void playerFireProjectile(Vec3 riderLook, Vec3 throat) {
        FireBolt bolt = new FireBolt(this, throat, riderLook, this.f_19853_, this.getExplosionStrength());
        if ((this.tier1() || this.tier2() || this.tier3() || this.tier4()) && !this.isUsingAbility()) {
            this.setTicksSinceLastFire(this.ticksSinceLastProjShootSet());
            bolt.shoot(riderLook, 1.0f);
            bolt.setProjectileSize(this.getProjsSize());
            if (this.tier4() || this.tier3()) {
                this.playProjectileSound();
            }
            if (this.tier1() || this.tier2()) {
                this.m_5496_(SoundEvents.f_12032_, 18.0f, 0.05f);
            }
            this.f_19853_.m_7967_((Entity)bolt);
            this.setPlayerBoltBlastPendingScale(0);
            this.setPlayerBoltBlastPendingStopThreshold(0);
        }
    }

    public void dragonShootProjectile(Vec3 dragonLook, Vec3 throat) {
        if ((this.tier1() || this.tier2() || this.tier3() || this.tier4()) && !this.isUsingAbility()) {
            FireBolt bolt = new FireBolt(this, throat, dragonLook, this.f_19853_, this.getExplosionStrength());
            this.setTicksSinceLastFire(this.ticksSinceLastProjShootSet());
            bolt.shoot(dragonLook, 1.0f, 1.0);
            bolt.setProjectileSize(this.getProjsSize());
            if (this.tier4() || this.tier3()) {
                this.playProjectileSound();
            }
            if (this.tier1() || this.tier2()) {
                this.m_5496_(SoundEvents.f_12032_, 14.0f, 0.05f);
            }
            this.setPlayerBoltBlastPendingScale(0);
            this.setPlayerBoltBlastPendingStopThreshold(0);
            this.f_19853_.m_7967_((Entity)bolt);
        }
    }

    public int getPlayerBoltBlastPendingScale() {
        return this.playerBoltBlastPendingScale;
    }

    public void setPlayerBoltBlastPendingScale(int playerBoltBlastPendingScale) {
        this.playerBoltBlastPendingScale = playerBoltBlastPendingScale;
    }

    public int getPlayerBoltBlastPendingStopThreshold() {
        return this.playerBoltBlastPendingStopThreshold;
    }

    public void setPlayerBoltBlastPendingStopThreshold(int playerBoltBlastPendingStopThreshold) {
        this.playerBoltBlastPendingStopThreshold = playerBoltBlastPendingStopThreshold;
    }

    public int getMaxPlayerBoltBlast() {
        return 72;
    }

    public boolean tier1() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.2 && (double)this.getPlayerBoltBlastPendingScale() < (double)this.getMaxPlayerBoltBlast() * 0.5;
    }

    public boolean tier2() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.5 && (double)this.getPlayerBoltBlastPendingScale() < (double)this.getMaxPlayerBoltBlast() * 0.75;
    }

    public boolean tier3() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.75 && (double)this.getPlayerBoltBlastPendingScale() < (double)this.getMaxPlayerBoltBlast() * 0.92;
    }

    public boolean tier4() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.92;
    }
}

