/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.deadlynadder;

import com.GACMD.isleofberk.entity.AI.taming.T2DragonFeedTamingGoal;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideableBreathUser;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.entity.eggs.entity.eggs.DeadlyNadderEgg;
import com.GACMD.isleofberk.entity.projectile.abase.BaseLinearFlightProjectile;
import com.GACMD.isleofberk.entity.projectile.other.nadder_spike.DeadlyNadderSpike;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModSounds;
import com.GACMD.isleofberk.registery.ModTags;
import com.GACMD.isleofberk.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class DeadlyNadder
extends ADragonBaseFlyingRideableBreathUser {
    int ticksSinceLastStingAttack = 0;
    int ticksSinceLastStingShootAI = 0;
    protected static final EntityDataAccessor<Integer> TICK_SINCE_LAST_FIRE = SynchedEntityData.m_135353_(DeadlyNadder.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> MARK_FIRED = SynchedEntityData.m_135353_(DeadlyNadder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    private <E extends IAnimatable> PlayState basicMovementController(AnimationEvent<E> event) {
        if (this.isFlying()) {
            if (this.isDragonMoving()) {
                if (this.m_20160_()) {
                    if (this.m_146909_() < 8.0f || this.isGoingUp() || this.m_20197_().size() > 2) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(true);
                    }
                    if (this.m_146909_() >= 8.0f && this.m_146909_() < 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.glide", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    if (this.m_146909_() >= 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    return PlayState.CONTINUE;
                }
                if (this.isDragonFollowing() && this.m_142480_() != null && this.m_142480_().m_21255_()) {
                    LivingEntity owner = this.m_142480_();
                    float dist = this.m_20270_((Entity)owner);
                    double ydist = this.m_20186_() - owner.m_20186_();
                    if (ydist < 10.0 || dist > 15.0f) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    } else {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    }
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    this.setShouldPlayFlapping(true);
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.hover", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                this.setShouldPlayFlapping(true);
            }
        } else {
            if (this.isDragonSitting() && !this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonMoving() && !this.shouldStopMovingIndependently()) {
                if (this.m_5448_() != null && !this.m_5448_().m_21224_() && this.m_20270_((Entity)this.m_5448_()) < 14.0f || this.m_20160_()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attackController(AnimationEvent<E> event) {
        if (this.getTicksSinceLastAttack() >= 0 && this.getTicksSinceLastAttack() < 12 && this.getCurrentAttackType() == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.bite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isUsingAbility()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.breath", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isMarkFired()) {
            if (this.isFlying()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.dart"));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.dart_ground"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState turnController(AnimationEvent<E> event) {
        int turnState = this.getRotationState();
        event.getController().setAnimationSpeed(4.0);
        if (turnState != 0) {
            if (this.isFlying()) {
                if (turnState == 1) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.tailrotleft1f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == 2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.tailrotleft2f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == -1) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.tailrotright1f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == -2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.tailrotright2f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            } else if (turnState == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.tailrotleft1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.tailrotleft2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == -1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.tailrotright1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == -2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.tailrotright2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("nadder.tailrot0", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "basic_MovementController", (float)this.getTransitionTicks(), this::basicMovementController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_Controller", 0.0f, this::attackController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "turnController", 35.0f, this::turnController));
    }

    public DeadlyNadder(EntityType<? extends ADragonBaseFlyingRideable> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TICK_SINCE_LAST_FIRE, (Object)0);
        this.f_19804_.m_135372_(MARK_FIRED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("markFired", this.isMarkFired());
        pCompound.m_128405_("ticksFire", this.getTicksSinceLastFire());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTicksSinceLastFire(pCompound.m_128451_("ticksFire"));
        this.setMarkFired(pCompound.m_128471_("markFired"));
    }

    public int getTicksSinceLastFire() {
        return (Integer)this.f_19804_.m_135370_(TICK_SINCE_LAST_FIRE);
    }

    public void setTicksSinceLastFire(int pType) {
        this.f_19804_.m_135381_(TICK_SINCE_LAST_FIRE, (Object)pType);
    }

    public boolean isMarkFired() {
        return (Boolean)this.f_19804_.m_135370_(MARK_FIRED);
    }

    public void setMarkFired(boolean fired) {
        this.f_19804_.m_135381_(MARK_FIRED, (Object)fired);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22280_, (double)0.14f).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), (double)0.8f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new T2DragonFeedTamingGoal(this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, PREY_SELECTOR));
    }

    @Override
    public Vec3 getThroatPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        double x = -Math.sin((double)this.f_20883_ * Math.PI / 180.0) * 6.0;
        double y = 1.6;
        double z = Math.cos((double)this.f_20883_ * Math.PI / 180.0) * 6.0;
        Vec3 throatPos = bodyOrigin.m_82549_(new Vec3(x, y, z));
        return throatPos;
    }

    public Vec3 getTailPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        double x = Math.cos(Math.toRadians(this.m_146908_() - 90.0f)) * 1.2;
        double y = 1.0;
        double z = Math.sin(Math.toRadians(this.m_146908_() - 90.0f)) * 1.2;
        Vec3 tailPos = bodyOrigin.m_82549_(new Vec3(x, y, z));
        return tailPos;
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        return super.m_6469_(pSource, pAmount);
    }

    @Override
    public void m_8119_() {
        Player player;
        LivingEntity livingEntity;
        String s1;
        String s;
        super.m_8119_();
        if (this.ticksSinceLastStingAttack >= 0 && !this.isUsingSECONDAbility()) {
            --this.ticksSinceLastStingAttack;
        }
        int threshold = 3;
        if (this.isUsingSECONDAbility() && this.ticksSinceLastStingAttack < threshold + 6) {
            ++this.ticksSinceLastStingAttack;
        }
        if (this.getTicksSinceLastFire() > 0) {
            this.setTicksSinceLastFire(this.getTicksSinceLastFire() - 1);
        }
        if (this.getTicksSinceLastFire() < 2) {
            this.setMarkFired(false);
        } else {
            this.setMarkFired(true);
        }
        Entity entity = this.m_6688_();
        if (entity instanceof Player) {
            Player player2 = (Player)entity;
            if (this.getRemainingSecondFuel() > 0 && this.ticksSinceLastStingAttack > threshold && !this.isUsingSECONDAbility()) {
                Vec3 riderLook = player2.m_20154_();
                this.performRangedAttack(riderLook, 1.0f);
            }
        }
        if ((s = ChatFormatting.m_126649_((String)this.m_7755_().getString())) != null && (s.equals("Stormfly") || s.equals("stormfly"))) {
            this.setDragonVariant(0);
        }
        if ((s1 = ChatFormatting.m_126649_((String)this.m_7755_().getString())) != null && (s1.equals("Stormpest") || s1.equals("stormpest") || s1.equals("seedling stormpest") || s1.equals("Seedling Stormpest") || s1.equals("Seedling stormpest"))) {
            this.setDragonVariant(11);
        }
        if (!(this.m_5448_() == null || this.m_5448_() instanceof Animal || this.m_5448_() instanceof WaterAnimal || !((livingEntity = this.m_5448_()) instanceof Player) || (player = (Player)livingEntity).m_7500_() || this.m_6688_() instanceof Player)) {
            if (this.m_21187_().nextInt(4) == 1) {
                this.performRangedAttackAI(this.m_20252_(1.0f), 1.0f);
                this.ticksSinceLastStingShootAI = Util.secondsToTicks(1);
            }
            if (this.ticksSinceLastStingShootAI > 0) {
                --this.ticksSinceLastStingShootAI;
            }
        }
    }

    @Override
    public void fireSecondary(Vec3 riderLook, Vec3 throat) {
    }

    public void performRangedAttack(Vec3 riderLook, float pDistanceFactor) {
        this.setTicksSinceLastFire(10);
        DeadlyNadderSpike spike = new DeadlyNadderSpike(this.f_19853_, (LivingEntity)this);
        spike.m_5602_((Entity)this);
        double d0 = riderLook.m_7096_();
        double d1 = riderLook.m_7098_();
        double d2 = riderLook.m_7094_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        spike.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 5.0f, 1.0f);
        this.modifySecondaryFuel(-1);
        this.m_5496_((SoundEvent)ModSounds.DEADLY_NADDER_STING.get(), 5.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)spike);
    }

    public void performRangedAttackAI(Vec3 dragonLook, float pDistanceFactor) {
        this.setTicksSinceLastFire(10);
        DeadlyNadderSpike spike = new DeadlyNadderSpike(this.f_19853_, (LivingEntity)this);
        spike.m_5602_((Entity)this);
        double d0 = dragonLook.m_7096_();
        double d1 = dragonLook.m_7098_();
        double d2 = dragonLook.m_7094_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        spike.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 4.0f, 1.2f);
        this.modifySecondaryFuel(-1);
        this.m_5496_((SoundEvent)ModSounds.DEADLY_NADDER_STING.get(), 5.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)spike);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pDistanceFactor) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)pArrowStack, (float)pDistanceFactor);
    }

    @Override
    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.setDragonVariant(this.f_19796_.nextInt(this.getMaxAmountOfVariants()));
        return pSpawnData;
    }

    @Override
    public int getMaxAmountOfVariants() {
        return 11;
    }

    @Override
    public int getMaxFuel() {
        return 40;
    }

    @Override
    protected int breathBarRegenSpeed() {
        return 10;
    }

    @Override
    protected int breathBarRegenAmount() {
        return 3;
    }

    @Override
    public void m_6674_(InteractionHand pHand) {
        super.m_6674_(pHand);
    }

    @Override
    protected boolean isItemStackForTaming(ItemStack stack) {
        return Ingredient.m_204132_(ModTags.Items.NADDER_TAME_FOOD).test(stack);
    }

    @Override
    public boolean isBreedingFood(ItemStack pStack) {
        return Ingredient.m_204132_(ModTags.Items.NADDER_BREED_FOOD).test(pStack);
    }

    @Override
    public float getRideCameraDistanceBack() {
        return 8.0f;
    }

    @Override
    public float getRideCameraDistanceFront() {
        return 5.0f;
    }

    @Override
    public int getExplosionStrength() {
        return 1;
    }

    @Override
    protected boolean canCarryCargo() {
        return true;
    }

    @Override
    protected double rider1XOffSet() {
        return 0.0;
    }

    @Override
    protected double rider1YOffSet() {
        return 1.7;
    }

    @Override
    protected double rider1ZOffSet() {
        return 0.0;
    }

    @Override
    protected double extraRidersXOffset() {
        return 0.4;
    }

    @Override
    protected double extraRidersYOffset() {
        return 1.7;
    }

    @Override
    protected double extraRidersZOffset() {
        return 1.0;
    }

    @Override
    @Nullable
    public ADragonEggBase getBreedEggResult(ServerLevel level, @NotNull AgeableMob parent) {
        DeadlyNadderEgg dragon = (DeadlyNadderEgg)((EntityType)ModEntities.NADDER_EGG.get()).m_20615_((Level)level);
        return dragon;
    }

    @Override
    public float getProjectileDamage(ADragonBase dragon, Entity entity, BaseLinearFlightProjectile projectile) {
        return 7.0f;
    }

    @Override
    protected int getInLoveCoolDownInMCDays() {
        return 2;
    }

    protected SoundEvent m_7515_() {
        if (this.isDragonSleeping()) {
            return (SoundEvent)ModSounds.DEADLY_NADDER_SLEEP.get();
        }
        return (SoundEvent)ModSounds.DEADLY_NADDER_GROWL.get();
    }

    @Override
    protected SoundEvent getTameSound() {
        return (SoundEvent)ModSounds.DEADLY_NADDER_TAME.get();
    }

    @Override
    protected SoundEvent getProjectileSound() {
        return (SoundEvent)ModSounds.DEADLY_NADDER_FIRE.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.DEADLY_NADDER_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.DEADLY_NADDER_DEATH.get();
    }

    @Override
    protected SoundEvent get1stAttackSound() {
        return (SoundEvent)ModSounds.DEADLY_NADDER_BITE.get();
    }

    @Override
    protected int getMaxPassengerCapacity() {
        return 2;
    }
}

