/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.lightfury;

import com.GACMD.isleofberk.entity.AI.taming.T4DragonPotionRequirement;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.dragons.nightfury.NightFury;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.entity.eggs.entity.eggs.LightFuryEgg;
import com.GACMD.isleofberk.entity.projectile.abase.BaseLinearFlightProjectile;
import com.GACMD.isleofberk.entity.projectile.proj_user.furybolt.FuryBolt;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModSounds;
import com.GACMD.isleofberk.util.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class LightFury
extends NightFury {
    private int ticksUsingSecondAbility;
    private int ticksSecondAbilityRecharge;

    private <E extends IAnimatable> PlayState basicMovementController(AnimationEvent<E> event) {
        if (this.isFlying()) {
            if (this.isDragonMoving()) {
                if (this.m_20160_()) {
                    if (this.m_146909_() < 8.0f || this.isGoingUp() || this.m_20197_().size() > 2) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(true);
                    }
                    if (this.m_146909_() >= 8.0f && this.m_146909_() < 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.glide", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    if (this.m_146909_() >= 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    return PlayState.CONTINUE;
                }
                if (this.isDragonFollowing() && this.m_142480_() != null && this.m_142480_().m_21255_()) {
                    LivingEntity owner = this.m_142480_();
                    float dist = this.m_20270_((Entity)owner);
                    double ydist = this.m_20186_() - owner.m_20186_();
                    if (ydist < 10.0 || dist > 15.0f) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    } else {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    }
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    this.setShouldPlayFlapping(true);
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.hover", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                this.setShouldPlayFlapping(true);
            }
        } else {
            if (this.isDragonSitting() && !this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonMoving() && !this.shouldStopMovingIndependently()) {
                if (this.m_5448_() != null && !this.m_5448_().m_21224_() && this.m_20270_((Entity)this.m_5448_()) < 14.0f || this.m_20160_()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attackController(AnimationEvent<E> event) {
        if (this.getTicksSinceLastAttack() >= 0 && this.getTicksSinceLastAttack() < 12 && this.getCurrentAttackType() == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.bite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isMarkFired()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.breath"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState turnController(AnimationEvent<E> event) {
        int turnState = this.getRotationState();
        event.getController().setAnimationSpeed(4.0);
        if (turnState != 0) {
            if (this.isFlying()) {
                if (turnState == 1) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.tailrotleft1f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == 2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.tailrotleft2f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == -1) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.tailrotright1f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == -2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.tailrotright2f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            } else if (turnState == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.tailrotleft1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.tailrotleft2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == -1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.tailrotright1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == -2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.tailrotright2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("lightfury.tailrot0", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "basic_MovementController", (float)this.getTransitionTicks(), this::basicMovementController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_Controller", 0.0f, this::attackController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "turnController", 35.0f, this::turnController));
    }

    public LightFury(EntityType<? extends LightFury> entityType, Level level) {
        super((EntityType<? extends NightFury>)entityType, level);
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel level, @NotNull AgeableMob parent) {
        LightFury dragon = (LightFury)((EntityType)ModEntities.LIGHT_FURY.get()).m_20615_((Level)level);
        return dragon;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (this.f_19796_.nextInt(20) == 1) {
            this.setDragonVariant(5);
        } else {
            this.setDragonVariant(this.f_19796_.nextInt(this.getMaxAmountOfVariants()));
        }
        this.setGlowVariant(this.getMaxAmountOfGlowVariants());
        return pSpawnData;
    }

    @Override
    public int getMaxAmountOfVariants() {
        return 5;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22280_, (double)0.2f).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), (double)0.8f);
    }

    @Override
    protected double rider1YOffSet() {
        return 1.0;
    }

    @Override
    protected double extraRidersYOffset() {
        return 1.0;
    }

    @Override
    public float getRideCameraDistanceBack() {
        if (!this.isFlying()) {
            return 4.0f;
        }
        return 9.0f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isUsingSECONDAbility() && this.ticksSecondAbilityRecharge == 0) {
            ++this.ticksUsingSecondAbility;
        }
        if (this.ticksSecondAbilityRecharge > 0) {
            --this.ticksSecondAbilityRecharge;
        }
        if (this.ticksUsingSecondAbility > 40 && !this.isUsingSECONDAbility() && this.m_21124_(MobEffects.f_19609_) == null && this.ticksSecondAbilityRecharge < 2) {
            this.ticksSecondAbilityRecharge = Util.secondsToTicks(14);
            this.ticksUsingSecondAbility = 0;
            this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, Util.secondsToTicks(10)));
        }
        if (this.m_21124_(MobEffects.f_19609_) != null) {
            LivingEntity livingEntity;
            Object object = this.m_146895_();
            if (object instanceof LivingEntity) {
                livingEntity = (LivingEntity)object;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 5));
            }
            if (this.m_20197_().size() > 1 && (object = this.m_20197_().get(1)) instanceof LivingEntity) {
                livingEntity = (LivingEntity)object;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 5));
            }
        }
    }

    @Override
    public Vec3 getThroatPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        double x = -Math.sin((double)this.f_20883_ * Math.PI / 180.0) * 2.4;
        double y = 1.3;
        double z = Math.cos((double)this.f_20883_ * Math.PI / 180.0) * 2.4;
        Vec3 throatPos = bodyOrigin.m_82549_(new Vec3(x, y, z));
        return throatPos;
    }

    @Override
    protected void playerFireProjectile(Vec3 riderLook, Vec3 throat) {
        if ((this.tier1() || this.tier2() || this.tier3() || this.tier4()) && !this.isUsingAbility()) {
            this.setTicksSinceLastFire(12);
            FuryBolt bolt = new FuryBolt(this, throat, riderLook, this.f_19853_, this.getExplosionStrength());
            bolt.setProjectileSize(this.getProjsSize());
            bolt.shoot(riderLook, 1.0f);
            bolt.setIsLightFuryTexture(true);
            if (this.tier4() || this.tier3()) {
                this.playProjectileSound();
            }
            if (this.tier1() || this.tier2()) {
                this.m_5496_(SoundEvents.f_12032_, 18.0f, 0.05f);
            }
            this.f_19853_.m_7967_((Entity)bolt);
            this.setPlayerBoltBlastPendingScale(0);
            this.setPlayerBoltBlastPendingStopThreshold(0);
        }
    }

    @Override
    public void dragonShootProjectile(Vec3 dragonLook, Vec3 throat) {
        if ((this.tier1() || this.tier2() || this.tier3() || this.tier4()) && !this.isUsingAbility()) {
            this.setTicksSinceLastFire(this.ticksSinceLastProjShootSet());
            FuryBolt bolt = new FuryBolt(this, throat, dragonLook, this.f_19853_, this.getExplosionStrength());
            bolt.shoot(dragonLook, 1.0f, 5.0);
            bolt.setProjectileSize(this.getProjsSize());
            if (this.tier4() || this.tier3()) {
                this.playProjectileSound();
            }
            if (this.tier1() || this.tier2()) {
                this.m_5496_(SoundEvents.f_12032_, 18.0f, 0.05f);
            }
            this.f_19853_.m_7967_((Entity)bolt);
            bolt.setIsLightFuryTexture(true);
            this.setPlayerBoltBlastPendingScale(0);
            this.setPlayerBoltBlastPendingStopThreshold(0);
        }
    }

    @javax.annotation.Nullable
    public Entity getSecondPassenger() {
        if (this.m_20197_().size() < 3) {
            return (Entity)this.m_20197_().get(1);
        }
        return null;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new T4DragonPotionRequirement(this, 1.0));
    }

    @Override
    public float getProjectileDamage(ADragonBase dragon, Entity entity, BaseLinearFlightProjectile projectile) {
        if (projectile.getDamageTier() == 1) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.1f);
            } else {
                f = 0.0f;
            }
            return 20.0f + f;
        }
        if (projectile.getDamageTier() == 2) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.1f);
            } else {
                f = 0.0f;
            }
            return 22.0f + f;
        }
        if (projectile.getDamageTier() == 3) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.11f);
            } else {
                f = 0.0f;
            }
            return 24.0f + f;
        }
        if (projectile.getDamageTier() == 4) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.12f);
            } else {
                f = 0.0f;
            }
            return 30.0f + f;
        }
        return 20.0f;
    }

    @Override
    @Nullable
    public ADragonEggBase getBreedEggResult(ServerLevel level, @NotNull AgeableMob parent) {
        LightFuryEgg dragon = (LightFuryEgg)((EntityType)ModEntities.LIGHT_FURY_EGG.get()).m_20615_((Level)level);
        return dragon;
    }

    @Override
    protected SoundEvent m_7515_() {
        if (this.isDragonSleeping()) {
            return (SoundEvent)ModSounds.LIGHT_FURY_SLEEP.get();
        }
        return (SoundEvent)ModSounds.LIGHT_FURY_GROWL.get();
    }

    @Override
    protected SoundEvent getTameSound() {
        return (SoundEvent)ModSounds.LIGHT_FURY_TAME.get();
    }

    @Override
    protected SoundEvent getProjectileSound() {
        return (SoundEvent)ModSounds.LIGHT_FURY_FIRE.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.LIGHT_FURY_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.LIGHT_FURY_DEATH.get();
    }

    @Override
    protected SoundEvent get1stAttackSound() {
        return (SoundEvent)ModSounds.LIGHT_FURY_BITE.get();
    }
}

