/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.montrous_nightmare;

import com.GACMD.isleofberk.entity.base.render.model.BaseDragonModelFlying;
import com.GACMD.isleofberk.entity.dragons.montrous_nightmare.MonstrousNightmare;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class MonstrousNightmareModel
extends BaseDragonModelFlying<MonstrousNightmare> {
    public MonstrousNightmareModel(EntityRendererProvider.Context renderManager) {
    }

    @Override
    public ResourceLocation getModelLocation(MonstrousNightmare entity) {
        return new ResourceLocation("isleofberk", "geo/dragons/nightmare.geo.json");
    }

    @Override
    public ResourceLocation getTextureLocation(MonstrousNightmare entity) {
        switch (entity.getDragonVariant()) {
            default: {
                return new ResourceLocation("isleofberk", "textures/dragons/nightmare/hookfang.png");
            }
            case 1: {
                return new ResourceLocation("isleofberk", "textures/dragons/nightmare/mountain.png");
            }
            case 2: {
                return new ResourceLocation("isleofberk", "textures/dragons/nightmare/bloodroot.png");
            }
            case 3: {
                return new ResourceLocation("isleofberk", "textures/dragons/nightmare/fangmaster.png");
            }
            case 4: {
                return new ResourceLocation("isleofberk", "textures/dragons/nightmare/burlystorm.png");
            }
            case 5: {
                return new ResourceLocation("isleofberk", "textures/dragons/nightmare/wolfsbane.png");
            }
            case 6: {
                return new ResourceLocation("isleofberk", "textures/dragons/nightmare/exiled.png");
            }
            case 7: {
                return new ResourceLocation("isleofberk", "textures/dragons/nightmare/hellebore.png");
            }
            case 8: {
                return new ResourceLocation("isleofberk", "textures/dragons/nightmare/carnation.png");
            }
            case 9: {
                return new ResourceLocation("isleofberk", "textures/dragons/nightmare/cardinal.png");
            }
            case 10: {
                return new ResourceLocation("isleofberk", "textures/dragons/nightmare/sunfyre.png");
            }
            case 11: {
                return new ResourceLocation("isleofberk", "textures/dragons/nightmare/rainbow.png");
            }
            case 12: {
                return new ResourceLocation("isleofberk", "textures/dragons/nightmare/tsukarion.png");
            }
            case 13: 
        }
        return new ResourceLocation("isleofberk", "textures/dragons/nightmare/fanghook.png");
    }

    @Override
    public ResourceLocation getAnimationFileLocation(MonstrousNightmare entity) {
        return new ResourceLocation("isleofberk", "animations/dragons/nightmare.animation.json");
    }

    @Override
    public void setLivingAnimations(MonstrousNightmare dragon, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations(dragon, uniqueID, customPredicate);
        IBone neck1 = this.getAnimationProcessor().getBone("Neck1");
        IBone neck2 = this.getAnimationProcessor().getBone("Neck2");
        IBone neck3 = this.getAnimationProcessor().getBone("Neck3");
        IBone neck4 = this.getAnimationProcessor().getBone("Neck4");
        IBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (!(dragon.shouldStopMovingIndependently() || Minecraft.m_91087_().m_91104_() || dragon.isRenderedOnGUI())) {
            neck1.setRotationZ(neck1.getRotationZ() + extraData.netHeadYaw * ((float)Math.PI / 180) / 5.0f);
            neck2.setRotationZ(neck2.getRotationZ() + extraData.netHeadYaw * ((float)Math.PI / 180) / 5.0f);
            neck3.setRotationZ(neck3.getRotationZ() + extraData.netHeadYaw * ((float)Math.PI / 180) / 5.0f);
            neck4.setRotationZ(neck3.getRotationZ() + extraData.netHeadYaw * ((float)Math.PI / 180) / 5.0f);
            head.setRotationZ(head.getRotationZ() + extraData.netHeadYaw * ((float)Math.PI / 180) / 5.0f);
            neck1.setRotationX(neck1.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 5.0f);
            neck2.setRotationX(neck2.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 5.0f);
            neck3.setRotationX(neck3.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 5.0f);
            neck4.setRotationX(neck4.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 5.0f);
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 5.0f);
        }
    }

    @Override
    public String getMainBodyBone() {
        return "rotation";
    }
}

