/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.nightlight;

import com.GACMD.isleofberk.entity.base.render.model.BaseDragonModelFlying;
import com.GACMD.isleofberk.entity.dragons.nightlight.NightLight;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class NightLightModel
extends BaseDragonModelFlying<NightLight> {
    @Override
    public ResourceLocation getModelLocation(NightLight entity) {
        return new ResourceLocation("isleofberk", "geo/dragons/night_light.geo.json");
    }

    @Override
    public ResourceLocation getTextureLocation(NightLight entity) {
        switch (entity.getDragonVariant()) {
            default: {
                return new ResourceLocation("isleofberk", "textures/dragons/night_light/dart.png");
            }
            case 1: {
                return new ResourceLocation("isleofberk", "textures/dragons/night_light/pouncer.png");
            }
            case 2: {
                return new ResourceLocation("isleofberk", "textures/dragons/night_light/ruffrunner.png");
            }
            case 3: {
                return new ResourceLocation("isleofberk", "textures/dragons/night_light/leopard.png");
            }
            case 4: {
                return new ResourceLocation("isleofberk", "textures/dragons/night_light/dusk.png");
            }
            case 5: {
                return new ResourceLocation("isleofberk", "textures/dragons/night_light/appaloosa.png");
            }
            case 6: {
                return new ResourceLocation("isleofberk", "textures/dragons/night_light/skydancer.png");
            }
            case 7: {
                return new ResourceLocation("isleofberk", "textures/dragons/night_light/nightdancer.png");
            }
            case 8: {
                return new ResourceLocation("isleofberk", "textures/dragons/night_light/iridescence.png");
            }
            case 9: {
                return new ResourceLocation("isleofberk", "textures/dragons/night_light/ashwing.png");
            }
            case 11: 
        }
        return new ResourceLocation("isleofberk", "textures/dragons/night_light/harlequeen.png");
    }

    @Override
    public ResourceLocation getAnimationFileLocation(NightLight entity) {
        return new ResourceLocation("isleofberk", "animations/dragons/night_fury.animation.json");
    }

    @Override
    public int getMaxRise() {
        return 47;
    }

    @Override
    public int getMinRise() {
        return -47;
    }

    @Override
    public void setLivingAnimations(NightLight dragon, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations(dragon, uniqueID, customPredicate);
        IBone neck = this.getAnimationProcessor().getBone("Neck");
        IBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (!(dragon.shouldStopMovingIndependently() || Minecraft.m_91087_().m_91104_() || dragon.isRenderedOnGUI())) {
            neck.setRotationY(neck.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180) / 2.0f);
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180) / 2.0f);
            neck.setRotationX(neck.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 2.0f);
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 2.0f);
        }
    }

    @Override
    public String getMainBodyBone() {
        return "rotation";
    }
}

