/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.skrill;

import com.GACMD.isleofberk.entity.AI.taming.T3DragonWeakenAndFeedTamingGoal;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideableBreathUser;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.entity.eggs.entity.eggs.SkrillEgg;
import com.GACMD.isleofberk.entity.projectile.abase.BaseLinearFlightProjectile;
import com.GACMD.isleofberk.entity.projectile.breath_user.skrill_lightning.SkrillLightning;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModMobEffects;
import com.GACMD.isleofberk.registery.ModParticles;
import com.GACMD.isleofberk.registery.ModSounds;
import com.GACMD.isleofberk.registery.ModTags;
import com.GACMD.isleofberk.util.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class Skrill
extends ADragonBaseFlyingRideableBreathUser {
    private static final EntityDataAccessor<Boolean> IS_ON_FIRE_ABILITY = SynchedEntityData.m_135353_(Skrill.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int ticksUsingSecondAbility;
    private int ticksUsingActiveSecondAbility;

    public Skrill(EntityType<? extends ADragonBaseFlyingRideable> entityType, Level level) {
        super(entityType, level);
    }

    private <E extends IAnimatable> PlayState basicMovementController(AnimationEvent<E> event) {
        if (this.isFlying()) {
            if (this.isDragonMoving()) {
                if (this.m_20160_()) {
                    if (this.m_146909_() < 8.0f || this.isGoingUp() || this.m_20197_().size() > 2) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.Fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(true);
                    }
                    if (this.m_146909_() >= 8.0f && this.m_146909_() < 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.Glide", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    if (this.m_146909_() >= 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    return PlayState.CONTINUE;
                }
                if (this.isDragonFollowing() && this.m_142480_() != null && this.m_142480_().m_21255_()) {
                    LivingEntity owner = this.m_142480_();
                    float dist = this.m_20270_((Entity)owner);
                    double ydist = this.m_20186_() - owner.m_20186_();
                    if (ydist < 10.0 || dist > 15.0f) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.Fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    } else {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    }
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.Fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    this.setShouldPlayFlapping(true);
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.Hover", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                this.setShouldPlayFlapping(true);
            }
        } else {
            if (this.isDragonSitting() && !this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.Sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.Sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonMoving() && !this.shouldStopMovingIndependently()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.Walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonIncapacitated()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.Surrender", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.Idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attackController(AnimationEvent<E> event) {
        if (this.getTicksSinceLastAttack() >= 0 && this.getTicksSinceLastAttack() < 12 && this.getCurrentAttackType() == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.Bite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isUsingAbility()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.Breath"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState turnController(AnimationEvent<E> event) {
        int turnState = this.getRotationState();
        event.getController().setAnimationSpeed(4.0);
        if (turnState != 0) {
            if (this.isFlying()) {
                if (turnState == 1) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.rotLeft1F", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == 2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.rotLeft2F", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == -1) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.rotRight1F", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == -2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.rotRight2F", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            } else if (turnState == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.rotLeft1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.rotLeft2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == -1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.rotRight1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == -2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.rotRight2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("Skrill.rot0", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "basic_MovementController", (float)this.getTransitionTicks(), this::basicMovementController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_Controller", 0.0f, this::attackController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "turnController", 35.0f, this::turnController));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ON_FIRE_ABILITY, (Object)false);
    }

    public boolean isOnFireAbility() {
        return (Boolean)this.f_19804_.m_135370_(IS_ON_FIRE_ABILITY);
    }

    public void setOnFireAbility(boolean fire) {
        this.f_19804_.m_135381_(IS_ON_FIRE_ABILITY, (Object)fire);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("is_on_fire_ability", this.isOnFireAbility());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setOnFireAbility(pCompound.m_128471_("is_on_fire_ability"));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (this.f_19796_.nextInt(1000) == 1) {
            this.setDragonVariant(10);
        } else if (this.f_19796_.nextInt(1000) == 1) {
            this.setDragonVariant(11);
        } else if (this.f_19796_.nextInt(100) == 1) {
            this.setDragonVariant(12);
        } else {
            this.setDragonVariant(this.f_19796_.nextInt(this.getMaxAmountOfVariants()));
        }
        return pSpawnData;
    }

    @Override
    protected int getAggressionType() {
        return 3;
    }

    @Override
    public int getMaxAmountOfVariants() {
        return 10;
    }

    @Override
    public float getRideCameraDistanceBack() {
        if (this.isFlying()) {
            return 10.0f;
        }
        return 5.0f;
    }

    @Override
    public float getRideCameraDistanceFront() {
        if (this.isFlying()) {
            return 4.0f;
        }
        return 9.0f;
    }

    @Override
    public Vec3 getThroatPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        double x = -Math.sin((double)this.f_20883_ * Math.PI / 180.0) * 1.8;
        double y = 0.2;
        double z = Math.cos((double)this.f_20883_ * Math.PI / 180.0) * 1.8;
        return bodyOrigin.m_82549_(new Vec3(x, y, z));
    }

    @Override
    public void m_8119_() {
        boolean hasDamageResist;
        super.m_8119_();
        boolean bl = hasDamageResist = this.m_21124_(MobEffects.f_19606_) != null;
        if (this.isUsingSECONDAbility()) {
            if (!hasDamageResist) {
                ++this.ticksUsingSecondAbility;
                this.ticksUsingActiveSecondAbility = 0;
            } else {
                ++this.ticksUsingActiveSecondAbility;
                this.ticksUsingSecondAbility = 0;
            }
        }
        if (this.ticksUsingSecondAbility > 40) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, Util.minutesToSeconds(1), 0, false, false));
        }
        if (this.isOnFireAbility()) {
            Vec3 t = this.getBodyPos(this);
            double d0 = t.f_82479_ + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 3.0;
            double d1 = t.f_82480_ + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 3.0;
            double d2 = t.f_82481_ + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 3.0;
            ParticleOptions particleOptions = (ParticleOptions)ModParticles.SKRILL_SKILL_PARTICLES.get();
            if (this.f_19797_ % 4 == 0) {
                this.f_19853_.m_6493_(particleOptions, false, d0, d1, d2, (double)(0.1525f * (this.f_19796_.nextFloat() - 0.5f)), (double)(0.1525f * (this.f_19796_.nextFloat() - 0.5f)), (double)(0.1525f * (this.f_19796_.nextFloat() - 0.5f)));
            }
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_175830_, false, d0, d1, d2, (double)(0.1525f * (this.f_19796_.nextFloat() - 0.5f)), (double)(0.1525f * (this.f_19796_.nextFloat() - 0.5f)), (double)(0.1525f * (this.f_19796_.nextFloat() - 0.5f)));
            if (!this.f_19853_.m_5776_() && this.f_19797_ % 10 == 0) {
                this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_().m_82400_(4.0)).forEach(livingEntity -> {
                    Player player;
                    if (!(livingEntity == this || livingEntity instanceof Player && (player = (Player)livingEntity).m_7500_() || this.m_6254_() && this.m_20197_().contains(livingEntity))) {
                        livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.SHOCK.get(), 80, 0, false, false));
                    }
                });
            }
        }
        if (!this.f_19853_.m_5776_() && hasDamageResist) {
            this.setOnFireAbility(true);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 5, 0, false, false));
        }
        if (!this.f_19853_.m_5776_() && !hasDamageResist || this.isDragonIncapacitated()) {
            this.setOnFireAbility(false);
        }
        if (this.ticksUsingActiveSecondAbility > 40 && hasDamageResist) {
            this.m_21195_(MobEffects.f_19606_);
            this.ticksUsingSecondAbility = 0;
        }
        this.performInCapacitate();
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        LivingEntity attacker;
        Entity entity = pSource.m_7640_();
        if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity).m_20270_((Entity)this) < 3.0f && this.m_21213_() < 12 && attacker.m_21213_() < 12) {
            attacker.m_20254_(5);
            attacker.m_6469_(DamageSource.m_19335_((Entity)this), 4.0f);
        }
        if (this.f_19796_.nextInt(24) == 1 && !this.m_20069_() && this.m_6688_() == null) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, Util.minutesToSeconds(2), 0, false, false));
        }
        return super.m_6469_(pSource, pAmount);
    }

    public Vec3 getBodyPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        float scale = this.m_6162_() ? 0.2f : 1.0f;
        Vec3 throatPos = bodyOrigin.m_82549_(new Vec3(x * (double)scale, y * (double)scale, z * (double)scale));
        return throatPos;
    }

    public Vec3 getRWingPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        float angle = (float)((double)((float)Math.PI / 180 * this.f_20883_) - 1.6580627893946132);
        float angle1 = (float)((double)((float)Math.PI / 180 * this.f_20883_) - 1.6580627893946132);
        double x = -Math.sin(Math.PI + (double)angle) * 4.0;
        double y = 2.4;
        double z = Math.cos(Math.PI + (double)angle1) * 4.0;
        float scale = this.m_6162_() ? 0.2f : 1.0f;
        Vec3 throatPos = bodyOrigin.m_82549_(new Vec3(x * (double)scale, y * (double)scale, z * (double)scale));
        return throatPos;
    }

    @Override
    protected double rider1YOffSet() {
        return 0.8;
    }

    @Override
    protected double extraRidersXOffset() {
        return 0.4;
    }

    @Override
    protected double extraRidersYOffset() {
        return 0.762;
    }

    @Override
    protected double extraRidersZOffset() {
        return 1.0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 75.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22280_, (double)0.19f).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), (double)0.8f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new T3DragonWeakenAndFeedTamingGoal(this, 1.0));
    }

    @Override
    public void firePrimary(Vec3 riderLook, Vec3 throat) {
        if (this.f_19796_.nextInt(3) == 1) {
            SkrillLightning fireProj = new SkrillLightning(this, throat, riderLook, this.f_19853_);
            fireProj.setProjectileSize(2);
            fireProj.shoot(riderLook, 1.0f, 4.0);
            this.playProjectileSound();
            this.f_19853_.m_7967_((Entity)fireProj);
        }
    }

    @Override
    public int getExplosionStrength() {
        return 2;
    }

    @Override
    public float getProjectileDamage(ADragonBase dragon, Entity entity, BaseLinearFlightProjectile projectile) {
        return 3.0f;
    }

    @Override
    public int getMaxFuel() {
        return 50;
    }

    @Override
    protected int breathBarRegenSpeed() {
        return 20;
    }

    @Override
    protected int breathBarRegenAmount() {
        return 1;
    }

    @Override
    @Nullable
    public ADragonEggBase getBreedEggResult(ServerLevel level, @NotNull AgeableMob parent) {
        SkrillEgg dragon = (SkrillEgg)((EntityType)ModEntities.SKRILL_EGG.get()).m_20615_((Level)level);
        return dragon;
    }

    @Override
    protected int getInLoveCoolDownInMCDays() {
        return 3;
    }

    protected SoundEvent m_7515_() {
        if (this.isDragonSleeping()) {
            return (SoundEvent)ModSounds.SKRILL_SLEEP.get();
        }
        return (SoundEvent)ModSounds.SKRILL_GROWL.get();
    }

    @Override
    protected SoundEvent getTameSound() {
        return (SoundEvent)ModSounds.SKRILL_TAME.get();
    }

    @Override
    protected SoundEvent getProjectileSound() {
        return (SoundEvent)ModSounds.SKRILL_FIRE.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.SKRILL_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SKRILL_DEATH.get();
    }

    @Override
    protected SoundEvent get1stAttackSound() {
        return (SoundEvent)ModSounds.SKRILL_BITE.get();
    }

    @Override
    protected int getMaxPassengerCapacity() {
        return 2;
    }

    @Override
    protected boolean canCarryCargo() {
        return true;
    }

    @Override
    protected boolean isItemStackForTaming(ItemStack stack) {
        return Ingredient.m_204132_(ModTags.Items.SKRILL_TAME_FOOD).test(stack);
    }

    @Override
    public boolean isBreedingFood(ItemStack pStack) {
        return Ingredient.m_204132_(ModTags.Items.SKRILL_BREED_FOOD).test(pStack);
    }
}

