/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.skrill;

import com.GACMD.isleofberk.entity.base.render.model.BaseDragonModelFlying;
import com.GACMD.isleofberk.entity.dragons.skrill.Skrill;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class SkrillModel
extends BaseDragonModelFlying<Skrill> {
    @Override
    protected float getAdultSize() {
        return 1.4f;
    }

    public SkrillModel(EntityRendererProvider.Context renderManager) {
    }

    @Override
    public ResourceLocation getModelLocation(Skrill entity) {
        return new ResourceLocation("isleofberk", "geo/dragons/skrill.geo.json");
    }

    @Override
    public ResourceLocation getTextureLocation(Skrill entity) {
        return switch (entity.getDragonVariant()) {
            default -> new ResourceLocation("isleofberk", "textures/dragons/skrill/skrill.png");
            case 1 -> new ResourceLocation("isleofberk", "textures/dragons/skrill/stormshadow.png");
            case 2 -> new ResourceLocation("isleofberk", "textures/dragons/skrill/icebane.png");
            case 3 -> new ResourceLocation("isleofberk", "textures/dragons/skrill/fryrir.png");
            case 4 -> new ResourceLocation("isleofberk", "textures/dragons/skrill/crimson.png");
            case 5 -> new ResourceLocation("isleofberk", "textures/dragons/skrill/nemesis.png");
            case 6 -> new ResourceLocation("isleofberk", "textures/dragons/skrill/tempest.png");
            case 7 -> new ResourceLocation("isleofberk", "textures/dragons/skrill/pickle.png");
            case 8 -> new ResourceLocation("isleofberk", "textures/dragons/skrill/zen.png");
            case 9 -> new ResourceLocation("isleofberk", "textures/dragons/skrill/spark.png");
            case 10 -> new ResourceLocation("isleofberk", "textures/dragons/skrill/albino.png");
            case 11 -> new ResourceLocation("isleofberk", "textures/dragons/skrill/moonshock.png");
            case 12 -> new ResourceLocation("isleofberk", "textures/dragons/skrill/spring_storm.png");
        };
    }

    @Override
    public ResourceLocation getAnimationFileLocation(Skrill entity) {
        return new ResourceLocation("isleofberk", "animations/dragons/skrill.animation.json");
    }

    @Override
    public void setLivingAnimations(Skrill dragon, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations(dragon, uniqueID, customPredicate);
        IBone neck = this.getAnimationProcessor().getBone("Neck");
        IBone head = this.getAnimationProcessor().getBone("head");
        IBone spike = this.getAnimationProcessor().getBone("spikeRemove");
        spike.setHidden(dragon.m_6254_());
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (!(dragon.shouldStopMovingIndependently() || Minecraft.m_91087_().m_91104_() || dragon.isRenderedOnGUI())) {
            neck.setRotationY(neck.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180) / 2.0f);
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180) / 2.0f);
            neck.setRotationX(neck.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 2.0f);
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 2.0f);
        }
    }

    @Override
    public String getMainBodyBone() {
        return "rotation";
    }
}

