/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.speedstingerleader;

import com.GACMD.isleofberk.entity.dragons.speedstinger.SpeedStinger;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModSounds;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SpeedStingerLeader
extends SpeedStinger {
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected final List<SpeedStinger> groupMembers = new ArrayList<SpeedStinger>();
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);

    private <E extends IAnimatable> PlayState basicMovementController(AnimationEvent<E> event) {
        if (this.isDragonMoving() && !this.shouldStopMovingIndependently()) {
            if (this.m_5448_() != null && !this.m_5448_().m_21224_() && this.m_20270_((Entity)this.m_5448_()) < 8.0f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerRun", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerWalk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isDragonSitting() && !this.isDragonSleeping()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerSit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isDragonSleeping()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerSleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_21563_().m_186069_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerCurious", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerIdle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attackController(AnimationEvent<E> event) {
        if (this.getTicksSinceLastAttack() >= 0 && this.getTicksSinceLastAttack() < 12) {
            if (this.getCurrentAttackType() == 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerBite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.getCurrentAttackType() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerSting", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
        }
        if (this.m_5448_() != null && !this.m_20096_() && this.isDragonMoving() && !this.m_5448_().m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerPounce", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "speed_stinger_leader_controller", (float)this.getTransitionTicks(), this::basicMovementController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "speed_stinger_leader_controller_attacks", 5.0f, this::attackController));
    }

    @Override
    protected boolean isItemStackForTaming(ItemStack stack) {
        return stack.m_150930_(Items.f_42697_);
    }

    public SpeedStingerLeader(EntityType<? extends SpeedStingerLeader> animal, Level world) {
        super((EntityType<? extends SpeedStinger>)animal, world);
        this.f_21364_ = 750;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    @Override
    protected int getAggressionType() {
        return 3;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pReason == MobSpawnType.SPAWN_EGG) {
            this.setDragonVariant(this.getTypeForBiome(pLevel));
        } else {
            this.setDragonVariant(this.getTypeForBiome(pLevel));
        }
        int size = this.f_19796_.nextInt(2) + 3;
        float theta = (float)Math.PI * 2 / (float)size;
        for (int i = 0; i <= 6; ++i) {
            SpeedStinger speedStinger = (SpeedStinger)((EntityType)ModEntities.SPEED_STINGER.get()).m_20615_(this.f_19853_);
            assert (speedStinger != null);
            speedStinger.m_6027_(this.m_20185_() + 0.1 * Math.cos(theta * (float)i), this.m_20186_(), this.m_20189_() + 0.1 * Math.sin(theta * (float)i));
            speedStinger.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
            speedStinger.setDragonVariant(this.getDragonVariant());
            pLevel.m_7967_((Entity)speedStinger);
        }
        return pSpawnData;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22277_, 7.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 10.0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6457_(@NotNull ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(@NotNull ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    public void addMember(SpeedStinger speedStinger) {
        if (speedStinger.getLeaderUUID() == this.m_142081_()) {
            this.groupMembers.add(speedStinger);
        }
    }

    @Override
    public boolean m_8023_() {
        return true;
    }

    public void m_6667_(DamageSource pCause) {
        this.groupMembers.forEach(SpeedStinger::removeLeader);
        super.m_6667_(pCause);
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        this.groupMembers.forEach(SpeedStinger::removeLeader);
        super.m_142687_(pReason);
    }

    public List<SpeedStinger> getGroupMembers() {
        return this.groupMembers;
    }

    public boolean isGroupFull() {
        return this.getGroupMembers().size() > 15;
    }

    @Override
    protected int m_6552_(Player pPlayer) {
        return 1000;
    }

    @Override
    protected boolean isSpeedStingerLeaderClass() {
        return true;
    }

    public void m_146758_(int p_146759_) {
        super.m_146758_(p_146759_);
    }

    @Override
    protected SoundEvent m_7515_() {
        if (this.isDragonSleeping()) {
            return (SoundEvent)ModSounds.SPEED_STINGER_SLEEP.get();
        }
        return (SoundEvent)ModSounds.SPEED_STINGER_GROWL.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.SPEED_STINGER_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SPEED_STINGER_DEATH.get();
    }
}

