/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.stinger;

import com.GACMD.isleofberk.entity.AI.taming.T2DragonFeedTamingGoal;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseGroundRideable;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.network.ControlNetwork;
import com.GACMD.isleofberk.network.message.MessageStingerMovingForRam;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModSounds;
import com.GACMD.isleofberk.registery.ModTags;
import com.GACMD.isleofberk.util.math.MathX;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddMobPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class Stinger
extends ADragonBaseGroundRideable
implements IAnimatable {
    ADragonBase.DragonPart[] subParts;
    ADragonBase.DragonPart stingerRamOffset = new ADragonBase.DragonPart(this, "stingerRamOffset", 1.5f, 1.5f);
    private static final EntityDataAccessor<Boolean> RAMMING_DAMAGE = SynchedEntityData.m_135353_(Stinger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected float m_6431_(@NotNull Pose pPose, @NotNull EntityDimensions pSize) {
        return pPose == Pose.SLEEPING ? 0.2f : pSize.f_20378_ * 1.65f;
    }

    private <E extends IAnimatable> PlayState attackController(AnimationEvent<E> event) {
        if (this.isUsingAbility()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("stinger.ram", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.getTicksSinceLastAttack() >= 0 && this.getTicksSinceLastAttack() < 12 && this.getCurrentAttackType() == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("stinger.bite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState basicMovementController(AnimationEvent<E> event) {
        if (this.isDragonOnGround()) {
            if (this.isDragonSitting() && !this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("stinger.sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("stinger.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.m_20160_() && this.isDragonMoving() && !this.shouldStopMovingIndependently()) {
                this.setIsRammingDamageTrue(true);
                event.getController().setAnimation(new AnimationBuilder().addAnimation("stinger.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonMoving() && !this.shouldStopMovingIndependently()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("stinger.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("stinger.jump", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        this.setIsRammingDamageTrue(false);
        event.getController().setAnimation(new AnimationBuilder().addAnimation("stinger.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_Controller", 0.0f, this::attackController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "basic_MovementController", (float)this.getTransitionTicks(), this::basicMovementController));
    }

    public Stinger(EntityType<? extends Stinger> entityType, Level level) {
        super(entityType, level);
        this.subParts = new ADragonBase.DragonPart[]{this.stingerRamOffset};
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RAMMING_DAMAGE, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setIsRammingDamageTrue(pCompound.m_128471_("ramming_damage"));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("ramming_damage", this.IsRammingDamageTrue());
    }

    public boolean IsRammingDamageTrue() {
        return (Boolean)this.f_19804_.m_135370_(RAMMING_DAMAGE);
    }

    public void setIsRammingDamageTrue(boolean ram) {
        this.f_19804_.m_135381_(RAMMING_DAMAGE, (Object)ram);
    }

    @Override
    protected boolean isItemStackForTaming(ItemStack stack) {
        return Ingredient.m_204132_(ModTags.Items.STINGER_TAME_FOOD).test(stack);
    }

    @Override
    public boolean isBreedingFood(ItemStack pStack) {
        return Ingredient.m_204132_(ModTags.Items.STINGER_BREED_FOOD).test(pStack);
    }

    public PartEntity<?>[] getParts() {
        return this.subParts;
    }

    public void m_142223_(@NotNull ClientboundAddMobPacket mobPacket) {
        super.m_142223_(mobPacket);
        PartEntity<?>[] stingerPart = this.getParts();
        for (int i = 0; i < stingerPart.length; ++i) {
            stingerPart[i].m_20234_(i + mobPacket.m_131552_());
        }
    }

    @NotNull
    public Packet<?> m_5654_() {
        return new ClientboundAddMobPacket((LivingEntity)this);
    }

    private void tickPart(ADragonBase.DragonPart pPart, double pOffsetX, double pOffsetY, double pOffsetZ) {
        Vec3 lastPos = new Vec3(pPart.m_20185_(), pPart.m_20186_(), pPart.m_20189_());
        pPart.m_6034_(this.m_20185_() + pOffsetX, this.m_20186_() + pOffsetY, this.m_20189_() + pOffsetZ);
        pPart.f_19854_ = lastPos.f_82479_;
        pPart.f_19855_ = lastPos.f_82480_;
        pPart.f_19856_ = lastPos.f_82481_;
        pPart.f_19790_ = lastPos.f_82479_;
        pPart.f_19791_ = lastPos.f_82480_;
        pPart.f_19792_ = lastPos.f_82481_;
    }

    public boolean isMultipartEntity() {
        return !this.m_6162_();
    }

    public void m_8107_() {
        super.m_8107_();
        float yRotRadians = MathX.toRadians(this.m_146908_());
        float sinY = Mth.m_14031_((float)yRotRadians);
        float cosY = Mth.m_14089_((float)yRotRadians);
        this.tickPart(this.stingerRamOffset, 3.0f * -sinY * 1.0f, this.isUsingAbility() ? 0.4 : 2.0, 3.0f * cosY * 1.0f);
        Vec3 vec3 = this.m_20184_();
        boolean isMoving = vec3.f_82479_ > 0.0 || vec3.f_82480_ > 0.0 || vec3.f_82481_ > 0.0;
        Entity entity = this.m_6688_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isUsingAbility() && this.IsRammingDamageTrue()) {
                this.knockBack(this.f_19853_.m_6249_((Entity)this, this.stingerRamOffset.m_142469_().m_82377_(0.3, 0.3, 0.3).m_82386_(0.0, -0.3, 0.0), EntitySelector.f_20406_));
                if (!this.f_19853_.m_5776_()) {
                    this.hurt(this.f_19853_.m_6249_((Entity)this, this.stingerRamOffset.m_142469_().m_82400_(1.0), EntitySelector.f_20406_));
                }
            }
        }
    }

    private void knockBack(List<Entity> pEntities) {
        double d0 = (this.stingerRamOffset.m_142469_().f_82288_ + this.stingerRamOffset.m_142469_().f_82291_) / 2.0;
        double d1 = (this.stingerRamOffset.m_142469_().f_82290_ + this.stingerRamOffset.m_142469_().f_82293_) / 2.0;
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity) || entity == this.m_20197_() || entity.f_19790_ != entity.m_20185_() && entity.f_19792_ != entity.m_20189_()) continue;
            double d2 = entity.m_20185_() - d0;
            double d3 = entity.m_20189_() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.m_5997_(d2 / d4 * 0.5, (double)0.2f, d3 / d4 * 4.0);
            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 5.0f);
            this.m_19970_((LivingEntity)this, entity);
        }
    }

    private void hurt(List<Entity> pEntities) {
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 8.0f);
            this.m_19970_((LivingEntity)this, entity);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            ControlNetwork.INSTANCE.sendToServer((Object)new MessageStingerMovingForRam(this.IsRammingDamageTrue(), this.m_142049_()));
        }
        if (this.isUsingAbility()) {
            this.m_146926_(0.0f);
        }
    }

    @Override
    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (this.m_6084_()) {
            if (this.m_20160_() && this.m_5807_()) {
                LivingEntity pilot = (LivingEntity)this.m_6688_();
                assert (pilot != null);
                pilot.m_5618_(pilot.m_6080_());
                this.m_146922_(pilot.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(pilot.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = pilot.f_20900_ * 0.5f;
                float f1 = pilot.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && this.isDragonOnGround()) {
                    double d0 = this.getCustomJump() * (double)this.playerJumpPendingScale * (double)this.m_20098_();
                    double d1 = d0 + this.m_182332_();
                    Vec3 vec3 = this.m_20184_();
                    this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
                    this.setIsJumping(true);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-1.5f * f2 * this.playerJumpPendingScale), 0.0, (double)(1.5f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                this.f_20887_ = this.m_6113_() * 0.1f;
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                } else if (pilot instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.isDragonOnGround()) {
                    this.playerJumpPendingScale = 0.0f;
                    this.setIsJumping(false);
                }
                this.m_146872_();
            } else {
                this.f_20887_ = 0.02f;
                super.m_7023_(pTravelVector);
            }
        }
    }

    @Override
    @Nullable
    public ADragonEggBase getBreedEggResult(ServerLevel level, @NotNull AgeableMob parent) {
        return (ADragonEggBase)((EntityType)ModEntities.STINGER_EGG.get()).m_20615_((Level)level);
    }

    @Override
    public void m_27594_() {
        super.m_27594_();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new T2DragonFeedTamingGoal(this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22280_, 0.14).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22288_, 4.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 10.0);
    }

    @Override
    public float getRideCameraDistanceBack() {
        return 7.0f;
    }

    @Override
    public float getRideCameraDistanceFront() {
        return 3.0f;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (this.f_19796_.nextInt(500) == 1) {
            this.setDragonVariant(5);
        } else {
            this.setDragonVariant(this.getTypeForBiome(pLevel));
        }
        return pSpawnData;
    }

    @Override
    public int getMaxAmountOfVariants() {
        return 6;
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob pMob) {
        return null;
    }

    private int getTypeForBiome(ServerLevelAccessor pLevel) {
        Holder biome = pLevel.m_204166_(new BlockPos(this.m_20182_()));
        if (biome.m_203656_(BiomeTags.f_207591_)) {
            return 1;
        }
        if (biome.m_203656_(BiomeTags.f_207590_)) {
            if (this.f_19796_.nextInt(50) == 1) {
                return 4;
            }
            return 2;
        }
        if (biome.m_203656_(BiomeTags.f_207607_)) {
            return 3;
        }
        if (biome.m_203656_(BiomeTags.f_207592_)) {
            return 0;
        }
        return 1;
    }

    @Override
    public void m_7332_(@NotNull Entity pPassenger) {
        super.m_7332_(pPassenger);
    }

    @Override
    protected int getAggressionType() {
        return 1;
    }

    @Override
    public float getRideCameraDistanceVert() {
        return 0.2f;
    }

    protected SoundEvent m_7515_() {
        if (this.isDragonSleeping()) {
            return (SoundEvent)ModSounds.STINGER_SLEEP.get();
        }
        return (SoundEvent)ModSounds.STINGER_GROWL.get();
    }

    @Override
    protected SoundEvent getTameSound() {
        return (SoundEvent)ModSounds.STINGER_TAME.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.STINGER_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.STINGER_DEATH.get();
    }

    @Override
    protected SoundEvent get1stAttackSound() {
        return (SoundEvent)ModSounds.DEADLY_NADDER_BITE.get();
    }

    @Override
    protected boolean canCarryCargo() {
        return true;
    }

    @Override
    protected double extraRidersXOffset() {
        return 0.4;
    }

    @Override
    protected double extraRidersYOffset() {
        return 2.2;
    }

    @Override
    protected double extraRidersZOffset() {
        return 0.8;
    }

    @Override
    protected double rider1YOffSet() {
        return 2.2;
    }

    @Override
    protected int getMaxPassengerCapacity() {
        return 3;
    }
}

