/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.projectile.abase;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideableProjUser;
import com.GACMD.isleofberk.entity.projectile.abase.BaseLinearFlightProjectile;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class BaseLinearBoltProjectile
extends BaseLinearFlightProjectile {
    public ADragonBaseFlyingRideableProjUser dragon;

    public BaseLinearBoltProjectile(EntityType<? extends AbstractHurtingProjectile> type, Level level) {
        super(type, level);
    }

    public BaseLinearBoltProjectile(EntityType<? extends AbstractHurtingProjectile> type, ADragonBaseFlyingRideableProjUser owner, Vec3 throat, Vec3 end, Level level, int strengthRadius) {
        super(type, owner, throat, end, level, strengthRadius);
        this.dragon = owner;
    }

    @Override
    public void shoot(Vec3 end, float partialTicks) {
        if (partialTicks == 1.0f) {
            if (this.dragon.tier1()) {
                this.setDamageTier(1);
            } else if (this.dragon.tier2()) {
                this.setDamageTier(2);
            } else if (this.dragon.tier3()) {
                this.setDamageTier(3);
            } else if (this.dragon.tier4()) {
                this.setDamageTier(4);
            }
            super.shoot(end, partialTicks, 5.0);
        }
    }

    @Override
    public void shoot(Vec3 end, float partialTicks, double velocity) {
        if (partialTicks == 1.0f) {
            if (this.dragon.tier1()) {
                this.setDamageTier(1);
            } else if (this.dragon.tier2()) {
                this.setDamageTier(2);
            } else if (this.dragon.tier3()) {
                this.setDamageTier(3);
            } else if (this.dragon.tier4()) {
                this.setDamageTier(4);
            }
            super.shoot(end, partialTicks, velocity);
        }
    }

    @Override
    public Explosion explode(ADragonBase pEntity, double pX, double pY, double pZ, float pExplosionRadius, boolean pCausesFire, Explosion.BlockInteraction pMode) {
        return this.explode(pEntity, null, null, pX, pY, pZ, pExplosionRadius, pCausesFire, pMode);
    }

    public Explosion explode(ADragonBase pExploder, @Nullable DamageSource pDamageSource, @Nullable ExplosionDamageCalculator pContext, double pX, double pY, double pZ, float pSize, boolean pCausesFire, Explosion.BlockInteraction pMode) {
        FireBoltExplosion explosion = new FireBoltExplosion(this.f_19853_, (Entity)pExploder, pDamageSource, pContext, pX, pY, pZ, pSize, pCausesFire, pMode);
        if (ForgeEventFactory.onExplosionStart((Level)this.f_19853_, (Explosion)explosion)) {
            return explosion;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        return explosion;
    }

    private static class FireBoltExplosion
    extends Explosion {
        public FireBoltExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource pDamageSource, @Nullable ExplosionDamageCalculator pDamageCalculator, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, boolean pFire, Explosion.BlockInteraction pBlockInteraction) {
            super(pLevel, pSource, pDamageSource, pDamageCalculator, pToBlowX, pToBlowY, pToBlowZ, pRadius, pFire, pBlockInteraction);
        }

        public void m_46061_() {
            this.f_46012_.m_142346_(this.f_46016_, GameEvent.f_157812_, new BlockPos(this.f_46013_, this.f_46014_, this.f_46015_));
            HashSet set = Sets.newHashSet();
            int i = 16;
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    block2: for (int l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.f_46013_;
                        double d6 = this.f_46014_;
                        double d8 = this.f_46015_;
                        float f1 = 0.3f;
                        for (float f = this.f_46017_ * (0.7f + this.f_46012_.f_46441_.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                            BlockPos blockpos = new BlockPos(d4, d6, d8);
                            BlockState blockstate = this.f_46012_.m_8055_(blockpos);
                            FluidState fluidstate = this.f_46012_.m_6425_(blockpos);
                            if (!this.f_46012_.m_46739_(blockpos)) continue block2;
                            Optional optional = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, blockpos, blockstate, fluidstate);
                            if (optional.isPresent()) {
                                f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                            }
                            if (f > 0.0f && this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, blockpos, blockstate, f)) {
                                set.add(blockpos);
                            }
                            d4 += d0 * (double)0.3f;
                            d6 += d1 * (double)0.3f;
                            d8 += d2 * (double)0.3f;
                        }
                    }
                }
            }
            this.f_46020_.addAll(set);
            float f2 = this.f_46017_ * 2.0f;
            int k1 = Mth.m_14107_((double)(this.f_46013_ - (double)f2 - 1.0));
            int l1 = Mth.m_14107_((double)(this.f_46013_ + (double)f2 + 1.0));
            int i2 = Mth.m_14107_((double)(this.f_46014_ - (double)f2 - 1.0));
            int i1 = Mth.m_14107_((double)(this.f_46014_ + (double)f2 + 1.0));
            int j2 = Mth.m_14107_((double)(this.f_46015_ - (double)f2 - 1.0));
            int j1 = Mth.m_14107_((double)(this.f_46015_ + (double)f2 + 1.0));
            List list = this.f_46012_.m_45933_(this.f_46016_, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
            ForgeEventFactory.onExplosionDetonate((Level)this.f_46012_, (Explosion)this, (List)list, (double)f2);
            Vec3 vec3 = new Vec3(this.f_46013_, this.f_46014_, this.f_46015_);
            for (int k2 = 0; k2 < list.size(); ++k2) {
                Player player;
                double d9;
                double d7;
                double d5;
                double d13;
                double d12;
                Entity entity = (Entity)list.get(k2);
                if (entity.m_6128_() || entity == this.getExploder() || entity.m_6673_(DamageSource.f_19305_) || entity.m_6673_(DamageSource.f_19307_) || !((d12 = Math.sqrt(entity.m_20238_(vec3)) / (double)f2) <= 1.0) || (d13 = Math.sqrt((d5 = entity.m_20185_() - this.f_46013_) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.f_46014_) * d7 + (d9 = entity.m_20189_() - this.f_46015_) * d9)) == 0.0) continue;
                d5 /= d13;
                d7 /= d13;
                d9 /= d13;
                double d14 = FireBoltExplosion.m_46064_((Vec3)vec3, (Entity)entity);
                double d10 = (1.0 - d12) * d14;
                if (entity != this.f_46016_) {
                    entity.m_6469_(this.m_46077_(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0)));
                }
                double d11 = d10;
                if (entity instanceof LivingEntity) {
                    d11 = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)d10);
                }
                entity.m_20256_(entity.m_20184_().m_82520_(d5 * d11, d7 * d11, d9 * d11));
                if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
                this.f_46021_.put(player, new Vec3(d5 * d10, d7 * d10, d9 * d10));
            }
        }

        public void m_46075_(boolean pSpawnParticles) {
            boolean flag;
            boolean bl = flag = this.f_46010_ != Explosion.BlockInteraction.NONE;
            if (pSpawnParticles) {
                if (!(this.f_46017_ < 2.0f) && flag) {
                    this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.f_46013_, this.f_46014_, this.f_46015_, 1.0, 0.0, 0.0);
                } else {
                    this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.f_46013_, this.f_46014_, this.f_46015_, 1.0, 0.0, 0.0);
                }
            }
            if (flag) {
                ObjectArrayList objectarraylist = new ObjectArrayList();
                Collections.shuffle(this.f_46020_, this.f_46012_.f_46441_);
                for (BlockPos blockpos : this.f_46020_) {
                    BlockState blockstate = this.f_46012_.m_8055_(blockpos);
                    Block block = blockstate.m_60734_();
                    if (blockstate.m_60795_()) continue;
                    BlockPos blockpos1 = blockpos.m_7949_();
                    this.f_46012_.m_46473_().m_6180_("explosion_blocks");
                    if (blockstate.canDropFromExplosion((BlockGetter)this.f_46012_, blockpos, (Explosion)this) && this.f_46012_ instanceof ServerLevel) {
                        BlockEntity blockentity = blockstate.m_155947_() ? this.f_46012_.m_7702_(blockpos) : null;
                        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.f_46012_).m_78977_(this.f_46012_.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)blockentity).m_78984_(LootContextParams.f_81455_, (Object)this.f_46016_);
                        if (this.f_46010_ == Explosion.BlockInteraction.DESTROY) {
                            lootcontext$builder.m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(this.f_46017_));
                        }
                        blockstate.m_60724_(lootcontext$builder).forEach(p_46074_ -> FireBoltExplosion.m_46067_((ObjectArrayList)objectarraylist, (ItemStack)p_46074_, (BlockPos)blockpos1));
                    }
                    blockstate.onBlockExploded(this.f_46012_, blockpos, (Explosion)this);
                    this.f_46012_.m_46473_().m_7238_();
                }
                for (Pair pair : objectarraylist) {
                    Block.m_49840_((Level)this.f_46012_, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
                }
            }
            if (this.f_46009_) {
                for (BlockPos blockpos2 : this.f_46020_) {
                    if (this.f_46011_.nextInt(3) != 0 || !this.f_46012_.m_8055_(blockpos2).m_60795_() || !this.f_46012_.m_8055_(blockpos2.m_7495_()).m_60804_((BlockGetter)this.f_46012_, blockpos2.m_7495_())) continue;
                    this.f_46012_.m_46597_(blockpos2, BaseFireBlock.m_49245_((BlockGetter)this.f_46012_, (BlockPos)blockpos2));
                }
            }
        }
    }
}

