/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.projectile.abase;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseGroundRideable;
import com.GACMD.isleofberk.entity.base.dragon.ADragonRideableUtility;
import com.GACMD.isleofberk.entity.projectile.abase.BaseLinearBoltProjectile;
import com.GACMD.isleofberk.entity.projectile.breath_user.poison.ZipBreathProjectile;
import com.GACMD.isleofberk.entity.projectile.breath_user.skrill_lightning.SkrillLightning;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public abstract class BaseLinearFlightProjectile
extends AbstractHurtingProjectile {
    public ADragonRideableUtility dragon;
    public double ticksExisted;
    protected int strengthRadius;
    protected Vec3 start;
    protected Vec3 end;
    protected int damageTier;
    protected static final EntityDataAccessor<Integer> PROJECTILE_SIZE = SynchedEntityData.m_135353_(BaseLinearFlightProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BaseLinearFlightProjectile(EntityType<? extends AbstractHurtingProjectile> type, Level level) {
        super(type, level);
    }

    protected BaseLinearFlightProjectile(EntityType<? extends AbstractHurtingProjectile> type, ADragonRideableUtility owner, Vec3 start, Vec3 end, Level level, int strengthRadius) {
        super(type, level);
        this.dragon = owner;
        this.strengthRadius = strengthRadius;
        this.m_5602_((Entity)owner);
        this.start = start;
        this.end = end;
        this.m_7678_(this.start.m_7096_(), this.start.m_7098_(), this.start.m_7094_(), this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d0 = Math.sqrt(end.m_7096_() * end.m_7096_() + end.m_7098_() * end.m_7098_() + end.m_7094_() * end.m_7094_());
        if (d0 != 0.0) {
            this.f_36813_ = end.m_7096_() / d0 * 0.2;
            this.f_36814_ = end.m_7098_() / d0 * 0.2;
            this.f_36815_ = end.m_7094_() / d0 * 0.2;
        }
    }

    public BaseLinearFlightProjectile(EntityType<? extends AbstractHurtingProjectile> pEntityType, ADragonRideableUtility owner, double pX, double pY, double pZ, double pOffsetX, double pOffsetY, double pOffsetZ, Level pLevel, int strengthRadius) {
        this(pEntityType, pLevel);
        this.dragon = owner;
        this.strengthRadius = strengthRadius;
        this.m_5602_((Entity)owner);
        this.m_7678_(pX, pY, pZ, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d0 = Math.sqrt(pOffsetX * pOffsetX + pOffsetY * pOffsetY + pOffsetZ * pOffsetZ);
        if (d0 != 0.0) {
            this.f_36813_ = pOffsetX / d0 * 0.1;
            this.f_36814_ = pOffsetY / d0 * 0.1;
            this.f_36815_ = pOffsetZ / d0 * 0.1;
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(PROJECTILE_SIZE, (Object)1);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setProjectileSize(pCompound.m_128451_("projectile_size"));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("projectile_size", this.getProjectileSize());
    }

    public int getProjectileSize() {
        return (Integer)this.f_19804_.m_135370_(PROJECTILE_SIZE);
    }

    public void setProjectileSize(int sizeTier) {
        this.f_19804_.m_135381_(PROJECTILE_SIZE, (Object)sizeTier);
    }

    public static HitResult getLargerHitResultForEntityCollisions(Entity pProjectile, Predicate<Entity> pFilter) {
        EntityHitResult hitresult1;
        Vec3 vec32;
        Vec3 vec3 = pProjectile.m_20184_();
        Level level = pProjectile.f_19853_;
        Vec3 vec31 = pProjectile.m_20182_();
        BlockHitResult hitresult = level.m_45547_(new ClipContext(vec31, vec32 = vec31.m_82549_(vec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, pProjectile));
        if (hitresult.m_6662_() != HitResult.Type.MISS) {
            vec32 = hitresult.m_82450_();
        }
        if ((hitresult1 = ProjectileUtil.m_37304_((Level)level, (Entity)pProjectile, (Vec3)vec31, (Vec3)vec32, (AABB)pProjectile.m_142469_().m_82369_(pProjectile.m_20184_()).m_82400_(6.0).m_82363_(1.0, 3.0, 1.0), pFilter)) != null) {
            hitresult = hitresult1;
        }
        return hitresult;
    }

    @Nullable
    public ADragonBase getOwner() {
        return this.dragon;
    }

    public void m_8119_() {
        this.m_6075_();
        this.ticksExisted += 1.0;
        if (this.f_19853_.f_46443_ || this.dragon == null || !this.dragon.m_146910_()) {
            this.m_20101_();
            Vec3 vec3 = this.m_20184_();
            double d0 = this.m_20185_() + vec3.f_82479_;
            double d1 = this.m_20186_() + vec3.f_82480_;
            double d2 = this.m_20189_() + vec3.f_82481_;
            float f = this.m_6884_();
            if (this.m_20069_()) {
                for (int i = 0; i < 4; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d0 - vec3.f_82479_ * 0.25, d1 - vec3.f_82480_ * 0.25, d2 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
                f = 0.8f;
            }
            this.m_20256_(vec3.m_82520_(this.f_36813_, this.f_36814_, this.f_36815_).m_82490_((double)f));
            this.m_6034_(d0, d1, d2);
        }
        ADragonBase owner = this.getOwner();
        HitResult hitresult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        HitResult largerEntityHitResult = BaseLinearFlightProjectile.getLargerHitResultForEntityCollisions((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (!this.f_19853_.f_46443_ || owner == null || !owner.m_146910_()) {
            HitResult.Type hitresult$typeEntity;
            if (hitresult.m_6662_() != HitResult.Type.MISS && hitresult.m_6662_() != HitResult.Type.ENTITY) {
                HitResult.Type hitresult$type;
                this.end = hitresult.m_82450_();
                if (this.dragon != null && (hitresult$type = hitresult.m_6662_()) == HitResult.Type.BLOCK && hitresult instanceof BlockHitResult) {
                    BlockHitResult blockHitResult = (BlockHitResult)hitresult;
                    boolean flag = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.getOwner());
                    if (flag) {
                        this.explode(this.dragon, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.dragon.getExplosionStrength(), flag, flag ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
                        this.callExplosionEffects(flag, this.dragon);
                    }
                    this.m_146870_();
                    this.m_146852_(GameEvent.f_157777_, (Entity)this.getOwner());
                }
            }
            if ((hitresult$typeEntity = largerEntityHitResult.m_6662_()) == HitResult.Type.ENTITY && largerEntityHitResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)largerEntityHitResult;
                if (largerEntityHitResult.m_6662_() != HitResult.Type.MISS && largerEntityHitResult.m_6662_() != HitResult.Type.BLOCK) {
                    this.end = largerEntityHitResult.m_82450_();
                    Entity entity = entityHitResult.m_82443_();
                    if (this.dragon != null && entity != this.dragon && entity != owner && !(entity instanceof BaseLinearFlightProjectile)) {
                        float damage1;
                        boolean mobGriefing = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.getOwner());
                        float damage = this.dragon.getProjectileDamage(this.dragon, entity, this);
                        float f = damage1 = entity instanceof Player || entity instanceof ADragonBaseFlyingRideable || entity instanceof ADragonBaseGroundRideable ? damage / 3.0f : damage;
                        if (mobGriefing) {
                            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.dragon), damage1);
                            if (!(this instanceof ZipBreathProjectile) && !(this instanceof SkrillLightning)) {
                                entity.m_20254_(7);
                            }
                            this.m_146870_();
                            this.m_146852_(GameEvent.f_157777_, (Entity)this.getOwner());
                        } else if (!mobGriefing) {
                            TamableAnimal tamableAnimal;
                            LivingEntity livingEntity;
                            if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21233_() < 20.0f && livingEntity.m_8077_()) {
                                return;
                            }
                            if (entity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity).m_21824_()) {
                                return;
                            }
                            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.dragon), damage1);
                            if (!(this instanceof ZipBreathProjectile) && !(this instanceof SkrillLightning)) {
                                entity.m_20254_(7);
                            }
                            this.m_146870_();
                            this.m_146852_(GameEvent.f_157777_, (Entity)this.getOwner());
                        }
                        boolean flag = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.getOwner());
                        this.explode(this.dragon, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.dragon.getExplosionStrength(), flag, flag ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
                        this.callExplosionEffects(flag, this.dragon);
                    }
                }
            }
        }
        this.playParticles();
        if (this.ticksExisted > (double)this.threshHoldForDeletion()) {
            this.m_146870_();
            this.ticksExisted = 0.0;
        }
    }

    protected void callExplosionEffects(boolean flag, ADragonRideableUtility dragon) {
        if (this instanceof BaseLinearBoltProjectile) {
            if (this.getProjectileSize() == 3 || this.getProjectileSize() == 2 || this.getProjectileSize() == 1) {
                this.f_19853_.m_46518_((Entity)dragon, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)dragon.getExplosionStrength(), flag, flag ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
            }
            if (this.getProjectileSize() == 0) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0, 0.0, 0.0);
                this.m_5496_(SoundEvents.f_11929_, 4.0f, 1.0f);
            }
        }
    }

    public void shoot(Vec3 end, float partialTicks, float pInaccuracy, double pVelocity) {
        Vec3 endVec = new Vec3(end.m_7096_() * pVelocity, end.m_7098_() * pVelocity, end.m_7094_() * pVelocity);
        Vec3 vec3 = endVec.m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)pInaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)pInaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)pInaccuracy).m_82490_(pVelocity);
        this.m_20256_(vec3);
        double d0 = end.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)end.f_82479_, (double)end.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)end.f_82480_, (double)d0) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146908_();
    }

    public void shootNoScaling(Vec3 end, float partialTicks, float pInaccuracy) {
        double pVelocity = 2.0;
        Vec3 endVec = new Vec3(end.m_7096_() * pVelocity, end.m_7098_() * pVelocity, end.m_7094_() * pVelocity);
        Vec3 vec3 = endVec.m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)pInaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)pInaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)pInaccuracy).m_82490_(pVelocity);
        this.m_20256_(vec3);
        double d0 = end.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)end.f_82479_, (double)end.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)end.f_82480_, (double)d0) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146908_();
    }

    public void shoot(Vec3 end, float partialTicks) {
        this.shoot(end, partialTicks, 1.0f, 5.0);
    }

    public void shoot(Vec3 end, float partialTicks, double velocity) {
        this.shoot(end, partialTicks, 1.0f, velocity);
    }

    protected int threshHoldForDeletion() {
        return 300;
    }

    protected abstract Explosion explode(ADragonBase var1, double var2, double var4, double var6, float var8, boolean var9, Explosion.BlockInteraction var10);

    public void playParticles() {
        float scale = (float)this.ticksExisted * 2.0f + 8.0f;
        float scaleMultiplier = switch (this.getProjectileSize()) {
            default -> 0.3f;
            case 1 -> 0.4f;
            case 2 -> 0.5f;
            case 3 -> 0.6f;
        };
        double posX = this.f_19854_ + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * (this.ticksExisted / 15.0);
        double posY = this.f_19855_ + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * (this.ticksExisted / 15.0);
        double posZ = this.f_19856_ + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * (this.ticksExisted / 15.0);
        ParticleOptions particleOptions = this.m_5967_();
        this.f_19853_.m_6493_(particleOptions, true, posX, posY, posZ, (double)(scale * scaleMultiplier) + 0.1 * (double)(this.f_19796_.nextFloat() - 0.5f), (double)(scale * scaleMultiplier) * 0.1 * (double)(this.f_19796_.nextFloat() - 0.5f), (double)(scale * scaleMultiplier) + 0.1 * (double)(this.f_19796_.nextFloat() - 0.5f));
    }

    public boolean m_6060_() {
        return false;
    }

    public int getDamageTier() {
        return this.damageTier;
    }

    public void setDamageTier(int damageTier) {
        this.damageTier = damageTier;
    }
}

