/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.projectile.breath_user.skrill_lightning;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import com.GACMD.isleofberk.entity.projectile.abase.BaseLinearFlightProjectile;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModMobEffects;
import com.GACMD.isleofberk.registery.ModParticles;
import com.GACMD.isleofberk.util.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class SkrillLightning
extends BaseLinearFlightProjectile {
    public SkrillLightning(EntityType<? extends SkrillLightning> projectile, Level level) {
        super(projectile, level);
    }

    public SkrillLightning(ADragonBaseFlyingRideable dragonOwner, Vec3 throat, Vec3 end, Level level) {
        super((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ModEntities.SKRILL_LIGHTNING.get()), dragonOwner, throat, end, level, 1);
    }

    protected boolean m_5931_() {
        return false;
    }

    @Override
    public void playParticles() {
        Vec3 vec3 = this.m_20184_();
        double deltaX = vec3.f_82479_;
        double deltaY = vec3.f_82480_;
        double deltaZ = vec3.f_82481_;
        double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * (double)0.7f);
        double posX = this.f_19854_ + deltaX + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 2.0;
        double posY = this.f_19855_ + deltaY + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 2.0;
        double posZ = this.f_19856_ + deltaZ + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 2.0;
        for (double j = 0.0; j < dist; j += 1.0) {
            double scale = 0.05f;
            double coeff = j / dist;
            ParticleOptions particleOptions = (ParticleOptions)ModParticles.SKRILL_LIGHTNING_PARTICLES.get();
            this.f_19853_.m_6493_(particleOptions, true, this.f_19854_ + deltaX * coeff, this.f_19855_ + deltaY * coeff + 0.1, this.f_19856_ + deltaZ * coeff, scale * (double)(this.f_19796_.nextFloat() - 0.3f), scale * (double)(this.f_19796_.nextFloat() - 0.3f), scale * (double)(this.f_19796_.nextFloat() - 0.3f));
        }
        this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_175830_, true, posX, posY, posZ, (double)(5.0f * (this.f_19796_.nextFloat() - 0.5f)), (double)(5.0f * (this.f_19796_.nextFloat() - 0.5f)), (double)(5.0f * (this.f_19796_.nextFloat() - 0.5f)));
        if (this.f_19797_ % 5 == 0) {
            this.f_19853_.m_6493_((ParticleOptions)ModParticles.SKRILL_SKILL_PARTICLES.get(), true, posX, posY, posZ, (double)(25.0f * (this.f_19796_.nextFloat() - 0.5f)), (double)(25.0f * (this.f_19796_.nextFloat() - 0.5f)), (double)(25.0f * (this.f_19796_.nextFloat() - 0.5f)));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        ADragonBase owner = this.getOwner();
        if (this.f_19853_.f_46443_ || owner == null || !owner.m_146910_()) {
            HitResult hitresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_);
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                this.end = hitresult.m_82450_();
            }
            if (!this.f_19853_.m_5776_() && hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                BlockHitResult blockHitResult;
                HitResult.Type hitresult$type = hitresult.m_6662_();
                if (hitresult$type == HitResult.Type.ENTITY && hitresult instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)hitresult;
                    Entity entity = entityHitResult.m_82443_();
                    boolean mobGriefing = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.getOwner());
                    if (entity != this.dragon) {
                        TamableAnimal tamableAnimal;
                        if (mobGriefing) {
                            entity.m_6469_(DamageSource.m_19373_((LivingEntity)this.dragon), 14.0f);
                            this.m_146870_();
                            this.m_146852_(GameEvent.f_157777_, (Entity)this.getOwner());
                        } else if (!mobGriefing && !entity.m_8077_() && entity instanceof TamableAnimal && !(tamableAnimal = (TamableAnimal)entity).m_21824_()) {
                            entity.m_6469_(DamageSource.m_19373_((LivingEntity)this.dragon), 8.0f);
                            if (entity.m_6060_()) {
                                this.explode(this.getOwner(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 4.0f, true, Explosion.BlockInteraction.NONE);
                            }
                            this.m_146870_();
                            this.m_146852_(GameEvent.f_157777_, (Entity)this.getOwner());
                        }
                    }
                    return;
                }
                if (hitresult$type == HitResult.Type.BLOCK && hitresult instanceof BlockHitResult && !(this.f_19853_.m_8055_((blockHitResult = (BlockHitResult)hitresult).m_82425_()).m_60734_() instanceof BushBlock)) {
                    boolean flag = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.getOwner());
                    this.makeAreaOfEffectCloud();
                    this.m_146870_();
                    this.m_146852_(GameEvent.f_157777_, (Entity)this.getOwner());
                }
            }
            this.m_20101_();
            Vec3 deltaMovement = this.m_20184_();
            double x = this.m_20185_() + deltaMovement.f_82479_;
            double y = this.m_20186_() + deltaMovement.f_82480_;
            double z = this.m_20189_() + deltaMovement.f_82481_;
            float inertia = this.m_6884_();
            if (this.m_20069_()) {
                for (int i = 0; i < 4; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, x - deltaMovement.f_82479_ * 0.25, y - deltaMovement.f_82480_ * 0.25, z - deltaMovement.f_82481_ * 0.25, deltaMovement.f_82479_, deltaMovement.f_82480_, deltaMovement.f_82481_);
                }
                inertia = 0.8f;
            }
            this.m_20256_(deltaMovement.m_82520_(this.f_36813_, this.f_36814_, this.f_36815_).m_82490_((double)inertia));
            this.m_6034_(x, y, z);
        }
        this.playParticles();
    }

    private void makeAreaOfEffectCloud() {
        AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
        ADragonBase entity = this.getOwner();
        if (entity != null) {
            areaeffectcloud.m_19718_((LivingEntity)entity);
        }
        areaeffectcloud.m_19712_(2.0f);
        areaeffectcloud.m_19732_(-0.5f);
        areaeffectcloud.m_19740_(5);
        areaeffectcloud.m_19734_(40);
        areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
        areaeffectcloud.m_19724_((ParticleOptions)ModParticles.LIGHTNING_AOE_EMITTER.get());
        areaeffectcloud.m_19716_(new MobEffectInstance((MobEffect)ModMobEffects.SHOCK.get(), Util.secondsToTicks(5)));
        this.f_19853_.m_7967_((Entity)areaeffectcloud);
    }

    protected boolean m_5603_(Entity hitEntity) {
        return super.m_5603_(hitEntity) && hitEntity != this.dragon;
    }

    @NotNull
    protected ParticleOptions m_5967_() {
        return (ParticleOptions)ModParticles.SKRILL_LIGHTNING_PARTICLES.get();
    }

    @Override
    protected int threshHoldForDeletion() {
        return 20;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_20068_() {
        return true;
    }

    public float m_6073_() {
        return 0.0f;
    }

    @Override
    protected Explosion explode(ADragonBase dragon, double x, double y, double z, float explosionStrength, boolean flag, Explosion.BlockInteraction blockInteraction) {
        return null;
    }
}

