/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.network.message;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ClientMessageTameParticlesDragon {
    int entityId;
    boolean check;

    public ClientMessageTameParticlesDragon(int entityId, boolean check) {
        this.entityId = entityId;
        this.check = check;
    }

    public static void encode(ClientMessageTameParticlesDragon message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
        buffer.writeBoolean(message.check);
    }

    public static ClientMessageTameParticlesDragon decode(FriendlyByteBuf buffer) {
        return new ClientMessageTameParticlesDragon(buffer.readInt(), buffer.readBoolean());
    }

    public static void handle(ClientMessageTameParticlesDragon message, Supplier<NetworkEvent.Context> ctx) {
        Entity entity;
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        if (player != null && (entity = player.f_19853_.m_6815_(message.entityId)) instanceof ADragonBase) {
            ADragonBase dragon = (ADragonBase)entity;
            if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                context.enqueueWork(() -> ClientMessageTameParticlesDragon.spawnTamingParticles(message.check, dragon));
                context.setPacketHandled(true);
            }
        }
    }

    protected static void spawnTamingParticles(boolean p_30670_, ADragonBase dragon) {
        if (dragon.f_19853_.m_5776_()) {
            SimpleParticleType particleoptions = p_30670_ ? ParticleTypes.f_123750_ : ParticleTypes.f_123762_;
            for (int i = 0; i < 7; ++i) {
                double d0 = dragon.m_21187_().nextGaussian() * 0.02;
                double d1 = dragon.m_21187_().nextGaussian() * 0.02;
                double d2 = dragon.m_21187_().nextGaussian() * 0.02;
                dragon.f_19853_.m_7106_((ParticleOptions)particleoptions, dragon.m_20208_(1.0), dragon.m_20187_() + 0.5, dragon.m_20262_(1.0), d0, d1, d2);
            }
        }
    }
}

