/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.network.message;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ControlMessageJumping {
    boolean isGoingUp;
    int dragonId;

    public ControlMessageJumping() {
    }

    public ControlMessageJumping(boolean isGoingUp, int dragonId) {
        this.isGoingUp = isGoingUp;
        this.dragonId = dragonId;
    }

    public static void encode(ControlMessageJumping message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.isGoingUp);
        buffer.writeInt(message.dragonId);
    }

    public static ControlMessageJumping decode(FriendlyByteBuf buffer) {
        return new ControlMessageJumping(buffer.readBoolean(), buffer.readInt());
    }

    public static void handle(ControlMessageJumping message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ServerPlayer player = context.getSender();
            if (player != null && (entity = player.f_19853_.m_6815_(message.dragonId)) instanceof ADragonBaseFlyingRideable) {
                ADragonBaseFlyingRideable dragon = (ADragonBaseFlyingRideable)entity;
                if (player.m_20202_() == dragon && dragon.m_142480_() == player) {
                    dragon.setIsGoingUp(message.isGoingUp);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

