/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.network.message;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class DragonRideMessage {
    int dragonId;
    boolean ride;

    public DragonRideMessage() {
    }

    public DragonRideMessage(int dragonId, boolean ride) {
        this.dragonId = dragonId;
        this.ride = ride;
    }

    public static void encode(DragonRideMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.dragonId);
        buffer.writeBoolean(message.ride);
    }

    public static DragonRideMessage decode(FriendlyByteBuf buffer) {
        return new DragonRideMessage(buffer.readInt(), buffer.readBoolean());
    }

    public static void handle(DragonRideMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ADragonBase dragonBase;
            Entity entity;
            ServerPlayer player = context.getSender();
            if (player != null && (entity = player.f_19853_.m_6815_(message.dragonId)) instanceof ADragonBase && (dragonBase = (ADragonBase)entity).m_20182_().m_82554_(player.m_20182_()) < 14.0) {
                if (message.ride) {
                    dragonBase.m_7998_((Entity)player, true);
                } else {
                    dragonBase.m_8127_();
                }
            }
        });
        context.setPacketHandled(true);
    }
}

