/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.util;

import com.GACMD.isleofberk.util.math.MathX;

public class Interpolation {
    private static final float[][] CR = new float[][]{{-0.5f, 1.5f, -1.5f, 0.5f}, {1.0f, -2.5f, 2.0f, -0.5f}, {-0.5f, 0.0f, 0.5f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}};

    public static float linear(float a, float b, float x) {
        if (x <= 0.0f) {
            return a;
        }
        if (x >= 1.0f) {
            return b;
        }
        return a * (1.0f - x) + b * x;
    }

    public static float smoothStep(float a, float b, float x) {
        if (x <= 0.0f) {
            return a;
        }
        if (x >= 1.0f) {
            return b;
        }
        x = x * x * (3.0f - 2.0f * x);
        return a * (1.0f - x) + b * x;
    }

    public static void catmullRomSpline(float x, float[] result, float[] ... knots) {
        int nknots = knots.length;
        int nspans = nknots - 3;
        int knot = 0;
        if (nspans < 1) {
            throw new IllegalArgumentException("Spline has too few knots");
        }
        int span = (int)(x = MathX.clamp(x, 0.0f, 0.9999f) * (float)nspans);
        if (span >= nknots - 3) {
            span = nknots - 3;
        }
        x -= (float)span;
        knot += span;
        int dimension = result.length;
        for (int i = 0; i < dimension; ++i) {
            float knot0 = knots[knot][i];
            float knot1 = knots[knot + 1][i];
            float knot2 = knots[knot + 2][i];
            float knot3 = knots[knot + 3][i];
            float c3 = CR[0][0] * knot0 + CR[0][1] * knot1 + CR[0][2] * knot2 + CR[0][3] * knot3;
            float c2 = CR[1][0] * knot0 + CR[1][1] * knot1 + CR[1][2] * knot2 + CR[1][3] * knot3;
            float c1 = CR[2][0] * knot0 + CR[2][1] * knot1 + CR[2][2] * knot2 + CR[2][3] * knot3;
            float c0 = CR[3][0] * knot0 + CR[3][1] * knot1 + CR[3][2] * knot2 + CR[3][3] * knot3;
            result[i] = ((c3 * x + c2) * x + c1) * x + c0;
        }
    }

    private Interpolation() {
    }
}

