/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.util.math;

import java.util.Random;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MathX {
    public static final double PI_D = Math.PI;
    public static final float PI_F = (float)Math.PI;
    public static boolean useLUT = true;
    public static final double MINIMUM_SIGNIFICANT_DIFFERENCE = 0.001;

    private MathX() {
    }

    public static float sin(float a) {
        return (float)Math.sin(a);
    }

    public static float cos(float a) {
        return (float)Math.cos(a);
    }

    public static float tan(float a) {
        return (float)Math.tan(a);
    }

    public static float atan2(float y, float x) {
        return (float)Math.atan2(y, x);
    }

    public static float toRadians(float angdeg) {
        return (float)Math.toRadians(angdeg);
    }

    public static float toDegrees(float angrad) {
        return (float)Math.toDegrees(angrad);
    }

    public static float normDeg(float a) {
        if ((a %= 360.0f) >= 180.0f) {
            a -= 360.0f;
        }
        if (a < -180.0f) {
            a += 360.0f;
        }
        return a;
    }

    public static double normDeg(double a) {
        if ((a %= 360.0) >= 180.0) {
            a -= 360.0;
        }
        if (a < -180.0) {
            a += 360.0;
        }
        return a;
    }

    public static float normRad(float a) {
        if ((a %= (float)Math.PI * 2) >= (float)Math.PI) {
            a -= (float)Math.PI * 2;
        }
        if (a < (float)(-Math.PI)) {
            a += (float)Math.PI * 2;
        }
        return a;
    }

    public static double normRad(double a) {
        if ((a %= Math.PI * 2) >= Math.PI) {
            a -= Math.PI * 2;
        }
        if (a < -Math.PI) {
            a += Math.PI * 2;
        }
        return a;
    }

    public static double getTruncatedGaussian(Random rand, double mean, double threeSigma) {
        double rawValue = rand.nextGaussian();
        rawValue = MathX.clamp(rawValue, -3.0, 3.0);
        return mean + rawValue * threeSigma / 3.0;
    }

    public static float sqrtf(float f) {
        return (float)Math.sqrt(f);
    }

    public static float clamp(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static int clamp(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static byte clampByte(int value, int min, int max) {
        return (byte)(value < min ? min : (value > max ? max : value));
    }

    public static int clamps(int value, int min, int max) {
        return value < min ? min : (value >= max ? max : value);
    }

    public static float updateRotation(float r1, float r2, float step) {
        return r1 + MathX.clamp(MathX.normDeg(r2 - r1), -step, step);
    }

    public static float lerp(float a, float b, float x) {
        return a * (1.0f - x) + b * x;
    }

    public static double lerp(double a, double b, double x) {
        return a * (1.0 - x) + b * x;
    }

    public static float slerp(float a, float b, float x) {
        if (x <= 0.0f) {
            return a;
        }
        if (x >= 1.0f) {
            return b;
        }
        return MathX.lerp(a, b, x * x * (3.0f - 2.0f * x));
    }

    public static float terp(float a, float b, float x) {
        if (x <= 0.0f) {
            return a;
        }
        if (x >= 1.0f) {
            return b;
        }
        float mu2 = (1.0f - MathX.cos(x * (float)Math.PI)) / 2.0f;
        return a * (1.0f - mu2) + b * mu2;
    }

    public static double terp(double a, double b, double x) {
        if (x <= 0.0) {
            return a;
        }
        if (x >= 1.0) {
            return b;
        }
        double mu2 = (1.0 - Math.cos(x * Math.PI)) / 2.0;
        return a * (1.0 - mu2) + b * mu2;
    }

    public static float constrainAngle(float targetAngle, float centreAngle, float maximumDifference) {
        return centreAngle + MathX.clamp(MathX.normDeg(targetAngle - centreAngle), -maximumDifference, maximumDifference);
    }

    public static Vec3 multiply(Vec3 source, double multiplier) {
        return new Vec3(source.f_82479_ * multiplier, source.f_82480_ * multiplier, source.f_82481_ * multiplier);
    }

    public static boolean isApproximatelyEqual(double x1, double x2) {
        return Math.abs(x1 - x2) <= 0.001;
    }

    public static boolean isSignificantlyDifferent(double x1, double x2) {
        return Math.abs(x1 - x2) > 0.001;
    }

    public static int modulus(int numerator, int divisor) {
        return (numerator % divisor + divisor) % divisor;
    }

    public static float wrapAngleTo180(float angle) {
        if ((angle %= 360.0f) >= 180.0f) {
            angle -= 360.0f;
        }
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static double wrapAngleTo180(double angle) {
        if ((angle %= 360.0) >= 180.0) {
            angle -= 360.0;
        }
        if (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    public static float invSqrt(float x) {
        float xhalf = 0.5f * x;
        int i = Float.floatToIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - xhalf * x * x;
        return x;
    }

    public static double calculateYaw(Vec3 direction) {
        double yaw = Math.atan2(direction.f_82481_, direction.f_82479_) * 180.0 / Math.PI - 90.0;
        yaw = MathX.normDeg(yaw);
        return yaw;
    }

    public static double calculatePitch(Vec3 direction) {
        double xz_norm = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        double pitch = -(Math.atan2(direction.f_82480_, xz_norm) * 180.0 / Math.PI);
        return pitch;
    }

    public static int getRandomInRange(Random random, int minValue, int maxValue) {
        return random.nextInt(maxValue - minValue + 1) + minValue;
    }

    public static float getRandomInRange(Random random, float minValue, float maxValue) {
        return random.nextFloat() * (maxValue - minValue) + minValue;
    }

    public static double getClosestDistanceSQ(AABB aabb, Vec3 point) {
        double dx = Math.max(Math.max(0.0, aabb.f_82288_ - point.f_82479_), point.f_82479_ - aabb.f_82291_);
        double dy = Math.max(Math.max(0.0, aabb.f_82289_ - point.f_82480_), point.f_82480_ - aabb.f_82292_);
        double dz = Math.max(Math.max(0.0, aabb.f_82290_ - point.f_82481_), point.f_82481_ - aabb.f_82293_);
        return dx * dx + dy * dy + dz * dz;
    }

    public static float wrapDegrees(float value) {
        if ((value %= 360.0f) >= 180.0f) {
            value -= 360.0f;
        }
        if (value < -180.0f) {
            value += 360.0f;
        }
        return value;
    }
}

