/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.imitator;

import java.util.List;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CategoryRecipeValidator<T extends Recipe<?>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int INVALID_COUNT = -1;
    private final IRecipeCategory<T> recipeCategory;
    private final int maxInputs;

    public CategoryRecipeValidator(IRecipeCategory<T> recipeCategory, int maxInputs) {
        this.recipeCategory = recipeCategory;
        this.maxInputs = maxInputs;
    }

    public boolean isRecipeValid(T recipe) {
        return this.hasValidInputsAndOutputs(recipe);
    }

    public boolean isRecipeHandled(T recipe) {
        return this.recipeCategory.isHandled(recipe);
    }

    private boolean hasValidInputsAndOutputs(T recipe) {
        if (recipe.m_5598_()) {
            return true;
        }
        ItemStack recipeOutput = recipe.m_8043_();
        if (recipeOutput == null || recipeOutput.m_41619_()) {
            LOGGER.error("Recipe has no output. {}", recipe);
            return false;
        }
        NonNullList ingredients = recipe.m_7527_();
        if (ingredients == null) {
            LOGGER.error("Recipe has no input Ingredients. {}", recipe);
            return false;
        }
        int inputCount = CategoryRecipeValidator.getInputCount((List<Ingredient>)ingredients);
        if (inputCount == -1) {
            return false;
        }
        if (inputCount > this.maxInputs) {
            LOGGER.error("Recipe has too many inputs. {}", recipe);
            return false;
        }
        if (inputCount == 0 && this.maxInputs > 0) {
            LOGGER.error("Recipe has no inputs. {}", recipe);
            return false;
        }
        return true;
    }

    private static int getInputCount(List<Ingredient> ingredientList) {
        int inputCount = 0;
        for (Ingredient ingredient : ingredientList) {
            ItemStack[] input = ingredient.m_43908_();
            if (input == null) {
                return -1;
            }
            ++inputCount;
        }
        return inputCount;
    }
}

