/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import org.jetbrains.annotations.NotNull;

public class JEIFocus<T>
implements IFocus<T>,
IFocusGroup {
    private final RecipeIngredientRole role;
    private final ITypedIngredient<T> value;

    public JEIFocus(IFocus<T> focus) {
        this(focus.getRole(), focus.getTypedValue());
    }

    public JEIFocus(RecipeIngredientRole role, ITypedIngredient<T> value) {
        this.role = role;
        this.value = value;
    }

    @Override
    public RecipeIngredientRole getRole() {
        return this.role;
    }

    @Override
    @NotNull
    public IFocus.Mode getMode() {
        return switch (this.role) {
            default -> throw new IncompatibleClassChangeError();
            case RecipeIngredientRole.INPUT, RecipeIngredientRole.CATALYST -> IFocus.Mode.INPUT;
            case RecipeIngredientRole.OUTPUT, RecipeIngredientRole.RENDER_ONLY -> IFocus.Mode.OUTPUT;
        };
    }

    @Override
    public ITypedIngredient<T> getTypedValue() {
        return this.value;
    }

    @Override
    public <T1> Optional<IFocus<T1>> checkedCast(IIngredientType<T1> ingredientType) {
        if (Objects.equals(this.value.getType(), ingredientType)) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    public <R> JEIFocus<R> wrap() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public List<IFocus<?>> getAllFocuses() {
        return Collections.singletonList(this);
    }

    @Override
    public Stream<IFocus<?>> getFocuses(RecipeIngredientRole role) {
        if (this.getRole() == role) {
            return Stream.of(this);
        }
        return Stream.empty();
    }

    @Override
    public <T> Stream<IFocus<T>> getFocuses(IIngredientType<T> ingredientType) {
        if (Objects.equals(this.value.getType(), ingredientType)) {
            return Stream.of(this);
        }
        return Stream.empty();
    }

    @Override
    public <T> Stream<IFocus<T>> getFocuses(IIngredientType<T> ingredientType, RecipeIngredientRole role) {
        if (Objects.equals(this.value.getType(), ingredientType) && this.getRole() == role) {
            return Stream.of(this);
        }
        return Stream.empty();
    }
}

