/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.List;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public enum JEIModIdHelper implements IModIdHelper
{
    INSTANCE;


    @Override
    @NotNull
    public String getModNameForModId(@NotNull String modId) {
        return ClientHelper.getInstance().getModFromModId(modId);
    }

    @Override
    public boolean isDisplayingModNameEnabled() {
        return ConfigObject.getInstance().shouldAppendModNames();
    }

    @Override
    @NotNull
    public String getFormattedModNameForModId(@NotNull String modId) {
        String name = this.getModNameForModId(modId);
        if (name.isEmpty()) {
            return name;
        }
        return "\u00a79\u00a7o" + name;
    }

    @Override
    @NotNull
    public <T> List<Component> addModNameToIngredientTooltip(@NotNull List<Component> tooltip, @NotNull T ingredient, @NotNull IIngredientHelper<T> ingredientHelper) {
        String containingNs = JEIPluginDetector.unwrapStack(ingredient).getContainingNamespace();
        if (containingNs != null) {
            ClientHelper.getInstance().appendModIdToTooltips(tooltip, containingNs);
        }
        return tooltip;
    }
}

