/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.ingredient.JEIGuiIngredientGroup;
import me.shedaniel.rei.jeicompat.ingredient.JEIGuiIngredientGroupFluid;
import me.shedaniel.rei.jeicompat.ingredient.JEIGuiIngredientGroupItem;
import me.shedaniel.rei.jeicompat.wrap.JEIFocus;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayoutBuilder;
import me.shedaniel.rei.jeicompat.wrap.JEITypedIngredient;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JEIRecipeLayout<T>
implements IRecipeLayout {
    private final Map<EntryType<?>, JEIGuiIngredientGroup<?>> groups = new HashMap();
    public final JEIRecipeLayoutBuilder builder;

    public JEIRecipeLayout(JEIRecipeLayoutBuilder builder) {
        this.builder = builder;
    }

    @Override
    @NotNull
    public IGuiItemStackGroup getItemStacks() {
        return (IGuiItemStackGroup)this.getIngredientsGroup(VanillaTypes.ITEM);
    }

    @Override
    @NotNull
    public IGuiFluidStackGroup getFluidStacks() {
        return (IGuiFluidStackGroup)this.getIngredientsGroup(ForgeTypes.FLUID);
    }

    @Override
    @NotNull
    public <T> IGuiIngredientGroup<T> getIngredientsGroup(@NotNull IIngredientType<T> ingredientType) {
        return this.groups.computeIfAbsent(JEIPluginDetector.unwrapType(ingredientType), type -> {
            if (Objects.equals(ingredientType.getIngredientClass(), ItemStack.class)) {
                return new JEIGuiIngredientGroupItem(ingredientType.cast(), this.builder);
            }
            if (Objects.equals(ingredientType.getIngredientClass(), FluidStack.class)) {
                return new JEIGuiIngredientGroupFluid(ingredientType.cast(), this.builder);
            }
            return new JEIGuiIngredientGroup(ingredientType, this.builder);
        });
    }

    public Map<EntryType<?>, JEIGuiIngredientGroup<?>> getGroups() {
        return this.groups;
    }

    @Nullable
    public IFocus<?> getFocus() {
        IFocusGroup foci = JEIWrappedDisplay.getFoci();
        if (foci.isEmpty()) {
            return null;
        }
        return foci.getAllFocuses().get(0);
    }

    @Override
    @Nullable
    public <V> IFocus<V> getFocus(@NotNull IIngredientType<V> ingredientType) {
        IFocus<?> focus = this.getFocus();
        if (focus == null) {
            return null;
        }
        ITypedIngredient<?> typedIngredient = focus.getTypedValue();
        return new JEIFocus(focus.getRole(), new JEITypedIngredient(typedIngredient.getType(), typedIngredient.getIngredient()));
    }

    @Override
    public void moveRecipeTransferButton(int posX, int posY) {
        this.builder.moveRecipeTransferButton(posX, posY);
    }

    @Override
    public void setShapeless() {
        this.builder.setShapeless();
    }
}

