/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.utils.Amount;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.Nullable;

public class JEIRecipeSlot
implements IRecipeSlotBuilder,
IRecipeSlotView {
    public RecipeIngredientRole role;
    @Nullable
    public final Slot slot;
    private boolean visible;
    @Nullable
    public String name;
    public Integer capacityMb;
    public boolean showCapacity;
    public IRecipeSlotTooltipCallback tooltipCallback = (recipeSlotView, tooltip) -> {};
    public final Map<EntryType<?>, IIngredientRenderer<?>> renderers = new HashMap();
    @Nullable
    public Widget background;
    @Nullable
    public Widget overlay;
    public final int index;
    private static final Method m_93179_ = ObfuscationReflectionHelper.findMethod(GuiComponent.class, (String)"m_93179_", (Class[])new Class[]{PoseStack.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});

    public JEIRecipeSlot(int index, RecipeIngredientRole role, @Nullable Point pos) {
        this.index = index;
        this.role = role;
        this.slot = Widgets.createSlot((Point)new Point(pos == null ? 0 : pos.x, pos == null ? 0 : pos.y)).disableBackground();
        this.visible = pos != null;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public <I> IRecipeSlotBuilder addIngredients(IIngredientType<I> ingredientType, List<@Nullable I> ingredients) {
        for (I ingredient : ingredients) {
            this.slot.entry(JEIPluginDetector.unwrapStack(ingredient, ingredientType));
        }
        return this;
    }

    @Override
    public <I> IRecipeSlotBuilder addIngredient(IIngredientType<I> ingredientType, I ingredient) {
        this.slot.entry(JEIPluginDetector.unwrapStack(ingredient, ingredientType));
        return this;
    }

    @Override
    public IRecipeSlotBuilder addIngredientsUnsafe(List<?> ingredients) {
        for (Object ingredient : ingredients) {
            this.addIngredient(JEIPluginDetector.jeiType(JEIPluginDetector.unwrapDefinition(ingredient)).cast(), ingredient);
        }
        return this;
    }

    @Override
    public IRecipeSlotBuilder addFluidStack(Fluid fluid, long amount) {
        return this.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, new FluidStack(fluid, Amount.toInt((long)amount)));
    }

    @Override
    public IRecipeSlotBuilder addFluidStack(Fluid fluid, long amount, CompoundTag tag) {
        return this.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, new FluidStack(fluid, Amount.toInt((long)amount), tag));
    }

    @Override
    public IRecipeSlotBuilder addTooltipCallback(IRecipeSlotTooltipCallback tooltipCallback) {
        IRecipeSlotTooltipCallback old = this.tooltipCallback;
        this.tooltipCallback = (recipeSlotView, tooltip) -> {
            old.onTooltip(recipeSlotView, tooltip);
            tooltipCallback.onTooltip(recipeSlotView, tooltip);
        };
        return this;
    }

    @Override
    public IRecipeSlotBuilder setSlotName(String slotName) {
        this.name = slotName;
        return this;
    }

    @Override
    public IRecipeSlotBuilder setBackground(IDrawable background, int xOffset, int yOffset) {
        this.background = Widgets.withTranslate((Widget)Widgets.wrapRenderer(() -> this.slot.getInnerBounds().clone(), (Renderer)JEIPluginDetector.unwrapRenderer(background)), (double)xOffset, (double)yOffset, (double)0.0);
        return this;
    }

    @Override
    public IRecipeSlotBuilder setOverlay(IDrawable overlay, int xOffset, int yOffset) {
        this.overlay = Widgets.withTranslate((Widget)Widgets.wrapRenderer(() -> this.slot.getInnerBounds().clone(), (Renderer)JEIPluginDetector.unwrapRenderer(overlay)), (double)xOffset, (double)yOffset, (double)0.0);
        return this;
    }

    @Override
    public IRecipeSlotBuilder setFluidRenderer(int capacityMb, boolean showCapacity, int width, int height) {
        this.slot.getBounds().setSize(width + 2, height + 2);
        this.capacityMb = capacityMb;
        this.showCapacity = showCapacity;
        return this;
    }

    @Override
    public IRecipeSlotBuilder setFluidRenderer(long capacity, boolean showCapacity, int width, int height) {
        return this.setFluidRenderer(Amount.toInt((long)capacity), showCapacity, width, height);
    }

    @Override
    public <T> IRecipeSlotBuilder setCustomRenderer(IIngredientType<T> ingredientType, IIngredientRenderer<T> ingredientRenderer) {
        this.renderers.put(JEIPluginDetector.unwrapType(ingredientType), ingredientRenderer);
        return this;
    }

    @Override
    public <T> Stream<T> getIngredients(IIngredientType<T> ingredientType) {
        EntryType type = JEIPluginDetector.unwrapType(ingredientType);
        return this.slot.getEntries().stream().filter(stack -> stack.getType() == type).map(JEIPluginDetector::jeiValue);
    }

    @Override
    public Stream<ITypedIngredient<?>> getAllIngredients() {
        return this.slot.getEntries().stream().map(JEIPluginDetector::typedJeiValue);
    }

    @Override
    public boolean isEmpty() {
        return this.slot.getEntries().isEmpty();
    }

    @Override
    public <T> Optional<T> getDisplayedIngredient(IIngredientType<T> ingredientType) {
        EntryStack entry = this.slot.getCurrentEntry();
        ITypedIngredient value = JEIPluginDetector.typedJeiValue(entry);
        return value.getIngredient(ingredientType);
    }

    @Override
    public Optional<ITypedIngredient<?>> getDisplayedIngredient() {
        EntryStack entry = this.slot.getCurrentEntry();
        return JEIPluginDetector.typedJeiValueOpWild(entry);
    }

    @Override
    public Optional<String> getSlotName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public RecipeIngredientRole getRole() {
        return this.role;
    }

    @Override
    public void drawHighlight(PoseStack stack, int color) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Rectangle bounds = this.slot.getInnerBounds().clone();
        try {
            m_93179_.invoke((Object)this.slot, stack, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), color, color);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }
}

