/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.utils.value.Value;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRenderer;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.jeicompat.ClientTextTooltipInterface;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.ingredient.JEIGuiIngredientGroup;
import me.shedaniel.rei.jeicompat.wrap.ForwardRecipeSlotView;
import me.shedaniel.rei.jeicompat.wrap.ForwardRecipeSlotsView;
import me.shedaniel.rei.jeicompat.wrap.JEIDisplaySetup;
import me.shedaniel.rei.jeicompat.wrap.JEIFocusGroup;
import me.shedaniel.rei.jeicompat.wrap.JEIGuiHelper;
import me.shedaniel.rei.jeicompat.wrap.JEIJeiHelpers;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayoutBuilder;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayoutLegacyAdapter;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferError;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferHandlerHelper;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedCategory;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JEIRecipeTransferRegistration
implements IRecipeTransferRegistration {
    private static Consumer<RenderTooltipEvent> tooltipEventConsumer;
    private final Consumer<Runnable> post;
    private Function<Point, Tooltip> tooltip = null;

    public JEIRecipeTransferRegistration(Consumer<Runnable> post) {
        this.post = post;
    }

    @Override
    @NotNull
    public IJeiHelpers getJeiHelpers() {
        return JEIJeiHelpers.INSTANCE;
    }

    @Override
    @NotNull
    public IRecipeTransferHandlerHelper getTransferHelper() {
        return JEIRecipeTransferHandlerHelper.INSTANCE;
    }

    @Override
    public <C extends AbstractContainerMenu> void addRecipeTransferHandler(Class<C> containerClass, ResourceLocation recipeCategoryUid, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        this.addRecipeTransferHandler(containerClass, new RecipeType<Object>(recipeCategoryUid, Object.class), recipeSlotStart, recipeSlotCount, inventorySlotStart, inventorySlotCount);
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(final Class<C> containerClass, final RecipeType<R> recipeType, final int recipeSlotStart, final int recipeSlotCount, final int inventorySlotStart, final int inventorySlotCount) {
        this.addRecipeTransferHandler(new IRecipeTransferInfo<C, R>(){

            @Override
            public Class<C> getContainerClass() {
                return containerClass;
            }

            @Override
            public RecipeType<R> getRecipeType() {
                return recipeType;
            }

            @Override
            public Class<R> getRecipeClass() {
                return recipeType.getRecipeClass();
            }

            @Override
            public ResourceLocation getRecipeCategoryUid() {
                return recipeType.getUid();
            }

            @Override
            public boolean canHandle(C container, R recipe) {
                return this.getContainerClass().isInstance(container);
            }

            @Override
            public List<net.minecraft.world.inventory.Slot> getRecipeSlots(C container, R recipe) {
                return IntStream.range(recipeSlotStart, recipeSlotStart + recipeSlotCount).mapToObj(arg_0 -> container.m_38853_(arg_0)).collect(Collectors.toList());
            }

            @Override
            public List<net.minecraft.world.inventory.Slot> getInventorySlots(C container, R recipe) {
                return IntStream.range(inventorySlotStart, inventorySlotStart + inventorySlotCount).mapToObj(arg_0 -> container.m_38853_(arg_0)).collect(Collectors.toList());
            }
        });
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(final IRecipeTransferInfo<C, R> info) {
        UUID uuid = UUID.randomUUID();
        InternalLogger.getInstance().debug("Queued registration of JEI recipe transfer handler: " + JEIPluginDetector.categoryId(info.getRecipeType()) + " " + info.getContainerClass() + " " + uuid);
        this.post.accept(() -> {
            InternalLogger.getInstance().debug("Registered JEI recipe transfer handler: " + JEIPluginDetector.categoryId(info.getRecipeType()) + " " + info.getContainerClass() + " " + uuid);
            TransferHandlerRegistry.getInstance().register((TransferHandler)new SimpleTransferHandler(){
                private final CategoryIdentifier<?> categoryIdentifier;
                {
                    this.categoryIdentifier = JEIPluginDetector.categoryId(info.getRecipeType());
                }

                public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
                    Object jeiValue = JEIPluginDetector.jeiValue(context.getDisplay());
                    if (!info.getContainerClass().isInstance(context.getMenu()) || !this.categoryIdentifier.equals((Object)context.getDisplay().getCategoryIdentifier()) || context.getContainerScreen() == null || jeiValue == null) {
                        return TransferHandler.ApplicabilityResult.createNotApplicable();
                    }
                    if (!info.canHandle(context.getMenu(), jeiValue)) {
                        IRecipeTransferError error = info.getHandlingError(context.getMenu(), jeiValue);
                        TransferHandler.Result result = JEIRecipeTransferRegistration.this.ofError(error, new Rectangle[]{new Rectangle()}, null, null);
                        if (result.isApplicable()) {
                            return TransferHandler.ApplicabilityResult.createApplicableWithError((TransferHandler.Result)result);
                        }
                        return TransferHandler.ApplicabilityResult.createNotApplicable();
                    }
                    return TransferHandler.ApplicabilityResult.createApplicable();
                }

                public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context context) {
                    Object jeiValue = JEIPluginDetector.jeiValue(context.getDisplay());
                    List<net.minecraft.world.inventory.Slot> slots = info.getRecipeSlots(context.getMenu(), jeiValue);
                    return Iterables.transform(slots, SlotAccessor::fromSlot);
                }

                public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context context) {
                    Object jeiValue = JEIPluginDetector.jeiValue(context.getDisplay());
                    List<net.minecraft.world.inventory.Slot> slots = info.getInventorySlots(context.getMenu(), jeiValue);
                    return Iterables.transform(slots, SlotAccessor::fromSlot);
                }
            });
        });
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(IRecipeTransferHandler<C, R> recipeTransferHandler, RecipeType<R> recipeCategoryUid) {
        this.addRecipeTransferHandler(recipeTransferHandler, recipeCategoryUid.getUid());
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(final IRecipeTransferHandler<C, R> recipeTransferHandler, final ResourceLocation recipeCategoryUid) {
        TransferHandlerRegistry.getInstance().register(new TransferHandler(){

            public TransferHandler.Result handle(TransferHandler.Context context) {
                if (recipeTransferHandler.getContainerClass().isInstance(context.getMenu())) {
                    Display display = context.getDisplay();
                    if (recipeCategoryUid == null || display.getCategoryIdentifier().equals(JEIPluginDetector.categoryId(recipeCategoryUid))) {
                        IRecipeTransferError error;
                        Value<IDrawable> background = new Value<IDrawable>(){

                            public void accept(IDrawable iDrawable) {
                            }

                            public IDrawable get() {
                                return JEIGuiHelper.INSTANCE.createBlankDrawable(0, 0);
                            }
                        };
                        IRecipeSlotsView[] view = new IRecipeSlotsView[1];
                        if (display instanceof JEIWrappedDisplay) {
                            category = ((JEIWrappedDisplay)display).getBackingCategory();
                            view[0] = JEIDisplaySetup.create(category.getBackingCategory(), (JEIWrappedDisplay)display, JEIFocusGroup.EMPTY);
                        } else {
                            category = CategoryRegistry.getInstance().get(display.getCategoryIdentifier().cast()).getCategory();
                            DisplayCategoryView categoryView = CategoryRegistry.getInstance().get(display.getCategoryIdentifier().cast()).getView(display);
                            view[0] = new JEIDisplaySetup.Result();
                            JEIRecipeLayoutBuilder builder = new JEIRecipeLayoutBuilder(null);
                            List widgets = categoryView.setupDisplay(display, new Rectangle(0, 0, category.getDisplayWidth(display), category.getDisplayHeight()));
                            JEIRecipeTransferRegistration.this.addToLayout(builder, widgets, 4, 4);
                            ((JEIDisplaySetup.Result)view[0]).setSlots(builder.slots);
                        }
                        if (context.isActuallyCrafting()) {
                            context.getMinecraft().m_91152_((Screen)context.getContainerScreen());
                        }
                        IRecipeTransferHandler handler = recipeTransferHandler;
                        Object recipe = MoreObjects.firstNonNull((Object)JEIPluginDetector.jeiValue(display), (Object)display);
                        JEIRecipeLayoutLegacyAdapter layout = new JEIRecipeLayoutLegacyAdapter((JEIDisplaySetup.Result)view[0]);
                        final Rectangle[] b = new Rectangle[]{new Rectangle()};
                        try {
                            view[0] = new ForwardRecipeSlotsView(view[0], slot -> new ForwardRecipeSlotView((IRecipeSlotView)slot){

                                @Override
                                public void drawHighlight(PoseStack stack, int color) {
                                    stack.m_85836_();
                                    stack.m_85837_((double)(-b[0].x), (double)(-b[0].y), 0.0);
                                    super.drawHighlight(stack, color);
                                    stack.m_85849_();
                                }
                            });
                            error = handler.transferRecipe(context.getMenu(), recipe, view[0], (Player)context.getMinecraft().f_91074_, context.isStackedCrafting(), context.isActuallyCrafting());
                        }
                        catch (UnsupportedOperationException e) {
                            error = handler.transferRecipe(context.getMenu(), recipe, layout, (Player)context.getMinecraft().f_91074_, context.isStackedCrafting(), context.isActuallyCrafting());
                        }
                        return JEIRecipeTransferRegistration.this.ofError(error, b, view[0], layout);
                    }
                }
                return TransferHandler.Result.createNotApplicable();
            }
        });
    }

    private TransferHandler.Result ofError(IRecipeTransferError error, Rectangle[] b, @Nullable IRecipeSlotsView view, IRecipeLayout layout) {
        TransferHandler.Result result;
        if (error == null) {
            return TransferHandler.Result.createSuccessful();
        }
        IRecipeTransferError.Type type = error.getType();
        if (type == IRecipeTransferError.Type.INTERNAL) {
            return TransferHandler.Result.createNotApplicable();
        }
        TransferHandler.Result result2 = type == IRecipeTransferError.Type.COSMETIC ? TransferHandler.Result.createSuccessful() : (result = TransferHandler.Result.createFailed((Component)(error instanceof JEIRecipeTransferError ? ((JEIRecipeTransferError)error).getText() : new TextComponent(""))));
        if (type != IRecipeTransferError.Type.COSMETIC) {
            result.color(error.getButtonHighlightColor());
        }
        if (error instanceof JEIRecipeTransferError) {
            JEIRecipeTransferError transferError = (JEIRecipeTransferError)error;
            if (error instanceof JEIRecipeTransferError.Legacy) {
                result.renderer(JEIRecipeTransferRegistration.forRedSlots((IntList)((JEIRecipeTransferError.Legacy)error).getRedSlots()));
            } else if (error instanceof JEIRecipeTransferError.New) {
                result.renderer(JEIRecipeTransferRegistration.forRedSlots(b, ((JEIRecipeTransferError.New)error).getRedSlots()));
            }
            return result;
        }
        IRecipeTransferError finalError = error;
        return result.overrideTooltipRenderer((point, tooltipSink) -> {
            if (this.tooltip != null) {
                tooltipSink.accept(this.tooltip.apply((Point)point));
                this.tooltip = null;
            }
        }).renderer((matrices, mouseX, mouseY, delta, widgets, bounds, d) -> {
            b[0] = bounds;
            this.tooltip = null;
            tooltipEventConsumer = event -> {
                this.tooltip = point -> {
                    Tooltip tool = Tooltip.create((Point)point, (Component[])new Component[0]);
                    for (ClientTooltipComponent component : event.getComponents()) {
                        if (!(component instanceof ClientTextTooltip)) continue;
                        FormattedCharSequence sequence = ((ClientTextTooltipInterface)component).reipc$getText();
                        MutableComponent[] mutableComponents = new MutableComponent[]{new TextComponent("")};
                        sequence.m_13731_((index, style, codepoint) -> {
                            mutableComponents[0].m_7220_((Component)new TextComponent(new String(new int[]{codepoint}, 0, 1)).m_6270_(style));
                            return true;
                        });
                        tool.add((Component)mutableComponents[0]);
                    }
                    return tool;
                };
                event.setCanceled(true);
            };
            if (view != null) {
                matrices.m_85836_();
                finalError.showError(matrices, mouseX, mouseY, view, 4, 4);
                matrices.m_85849_();
            }
            if (layout != null) {
                matrices.m_85836_();
                finalError.showError(matrices, mouseX, mouseY, layout, bounds.x + 4, bounds.y + 4);
                matrices.m_85849_();
            }
            tooltipEventConsumer = null;
        });
    }

    static TransferHandlerRenderer forRedSlots(IntList redSlots) {
        return (matrices, mouseX, mouseY, delta, widgets, bounds, display) -> {
            DisplayCategory category = Objects.requireNonNull(CategoryRegistry.getInstance().get(display.getCategoryIdentifier())).getCategory();
            if (category instanceof JEIWrappedCategory) {
                JEIWrappedCategory wrappedCategory = (JEIWrappedCategory)category;
                for (JEIGuiIngredientGroup.SlotWrapper slotWrapper : Widgets.walk((Iterable)widgets, widget -> widget instanceof JEIGuiIngredientGroup.SlotWrapper)) {
                    if (slotWrapper.slot.role != RecipeIngredientRole.INPUT || !redSlots.contains(slotWrapper.index)) continue;
                    matrices.m_85836_();
                    matrices.m_85837_(0.0, 0.0, 400.0);
                    Rectangle innerBounds = slotWrapper.slot.slot.getInnerBounds();
                    GuiComponent.m_93172_((PoseStack)matrices, (int)innerBounds.x, (int)innerBounds.y, (int)innerBounds.getMaxX(), (int)innerBounds.getMaxY(), (int)0x40FF0000);
                    matrices.m_85849_();
                }
            }
        };
    }

    static TransferHandlerRenderer forRedSlots(Rectangle[] b, Collection<IRecipeSlotView> redSlots) {
        return (matrices, mouseX, mouseY, delta, widgets, bounds, display) -> {
            b[0] = new Rectangle(-bounds.x, -bounds.y, 1, 1);
            DisplayCategory category = Objects.requireNonNull(CategoryRegistry.getInstance().get(display.getCategoryIdentifier())).getCategory();
            if (category instanceof JEIWrappedCategory) {
                JEIWrappedCategory wrappedCategory = (JEIWrappedCategory)category;
                for (JEIGuiIngredientGroup.SlotWrapper slotWrapper : Widgets.walk((Iterable)widgets, widget -> widget instanceof JEIGuiIngredientGroup.SlotWrapper)) {
                    if (!redSlots.contains(slotWrapper.slot)) continue;
                    matrices.m_85836_();
                    matrices.m_85837_(0.0, 0.0, 400.0);
                    Rectangle innerBounds = slotWrapper.slot.slot.getInnerBounds();
                    GuiComponent.m_93172_((PoseStack)matrices, (int)innerBounds.x, (int)innerBounds.y, (int)innerBounds.getMaxX(), (int)innerBounds.getMaxY(), (int)0x40FF0000);
                    matrices.m_85849_();
                }
            } else {
                matrices.m_85836_();
                matrices.m_85837_(4.0, 4.0, 400.0);
                for (IRecipeSlotView missingSlot : redSlots) {
                    missingSlot.drawHighlight(matrices, 0x40FF0000);
                }
                matrices.m_85849_();
            }
        };
    }

    private void addToLayout(JEIRecipeLayoutBuilder builder, List<Widget> entries, int xOffset, int yOffset) {
        HashMap<Boolean, List> groups = new HashMap<Boolean, List>();
        for (Widget widget : entries) {
            if (!(widget instanceof Slot)) continue;
            HashMultimap group = HashMultimap.create();
            List ingredient = ((Slot)widget).getEntries();
            for (EntryStack stack : ingredient) {
                if (stack.isEmpty()) continue;
                group.put((Object)stack.getType(), (Object)stack);
            }
            groups.computeIfAbsent(((Slot)widget).getNoticeMark() != 2, $ -> new ArrayList()).add(Pair.of((Object)((Slot)widget), (Object)group));
        }
        for (Map.Entry entry : groups.entrySet()) {
            ((List)entry.getValue()).stream().map(Pair::getRight).map(Multimap::keys).flatMap(Collection::stream).distinct().forEach(type -> {
                for (Pair pair : (List)entry.getValue()) {
                    Slot slot = (Slot)pair.getLeft();
                    Collection stacks = ((Multimap)pair.getRight()).get(type);
                    builder.addSlot((Boolean)entry.getKey() != false ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT, slot.getInnerBounds().x - xOffset, slot.getInnerBounds().y - yOffset).addIngredientsUnsafe(CollectionUtils.map((Collection)stacks, JEIPluginDetector::jeiValue));
                }
            });
        }
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addUniversalRecipeTransferHandler(IRecipeTransferHandler<C, R> recipeTransferHandler) {
        this.addRecipeTransferHandler(recipeTransferHandler, (ResourceLocation)null);
    }

    static {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (tooltipEventConsumer != null) {
                tooltipEventConsumer.accept((RenderTooltipEvent)event);
            }
        });
    }
}

