/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIDisplaySetup;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.LazyLoadedValue;
import org.jetbrains.annotations.Nullable;

public class JEIWrappedCategory<T>
implements DisplayCategory<JEIWrappedDisplay<T>> {
    private final IRecipeCategory<T> backingCategory;
    public final LazyLoadedValue<IDrawable> background;
    private final CategoryIdentifier<? extends JEIWrappedDisplay<T>> identifier;

    public JEIWrappedCategory(IRecipeCategory<T> backingCategory) {
        this.backingCategory = backingCategory;
        this.background = new LazyLoadedValue(backingCategory::getBackground);
        this.identifier = JEIPluginDetector.categoryId(backingCategory.getRecipeType()).cast();
    }

    public Class<? extends T> getRecipeClass() {
        return this.backingCategory.getRecipeType().getRecipeClass();
    }

    public boolean handlesRecipe(T recipe) {
        return this.backingCategory.isHandled(recipe);
    }

    public Renderer getIcon() {
        IDrawable icon = this.backingCategory.getIcon();
        if (icon != null) {
            return JEIPluginDetector.unwrapRenderer(icon);
        }
        List workstations = CategoryRegistry.getInstance().get(this.getCategoryIdentifier()).getWorkstations();
        if (!workstations.isEmpty()) {
            return Widgets.createSlot((Point)new Point(0, 0)).entries((Collection)workstations.get(0)).disableBackground().disableHighlight().disableTooltips();
        }
        FormattedCharSequence title = this.getTitle().m_7532_();
        final FormattedCharSequence titleTrimmed = sink -> title.m_13731_((index, style, codepoint) -> {
            if (index == 0 || index == 1) {
                sink.m_6411_(index, style, codepoint);
                return true;
            }
            return false;
        });
        return new Renderer(){

            public void render(PoseStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                Font font = Minecraft.m_91087_().f_91062_;
                font.m_92744_(matrices, titleTrimmed, (float)bounds.getCenterX() - (float)font.m_92724_(titleTrimmed) / 2.0f, (float)bounds.getCenterY() - 4.5f, 0xFFFFFF);
            }

            public int getZ() {
                return 0;
            }

            public void setZ(int z) {
            }
        };
    }

    public Component getTitle() {
        return this.backingCategory.getTitle();
    }

    public int getDisplayWidth(JEIWrappedDisplay<T> display) {
        return ((IDrawable)this.background.m_13971_()).getWidth() + 8;
    }

    public CategoryIdentifier<? extends JEIWrappedDisplay<T>> getCategoryIdentifier() {
        return this.identifier;
    }

    public int getDisplayHeight() {
        return ((IDrawable)this.background.m_13971_()).getHeight() + 8;
    }

    public IRecipeCategory<T> getBackingCategory() {
        return this.backingCategory;
    }

    public List<Widget> setupDisplay(JEIWrappedDisplay<T> display, Rectangle bounds) {
        return JEIWrappedCategory.setupDisplay(this.getBackingCategory(), display, JEIWrappedDisplay.getFoci(), bounds, this.background);
    }

    public static <T> List<Widget> setupDisplay(IRecipeCategory<T> category, JEIWrappedDisplay<T> display, IFocusGroup focuses, Rectangle bounds, LazyLoadedValue<IDrawable> backgroundLazy) {
        JEIDisplaySetup.Result result;
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        try {
            result = JEIDisplaySetup.create(category, display, focuses);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds).color(-65536));
            widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.getCenterX(), bounds.getCenterY() - 8), (Component)new TextComponent("Failed to initiate JEI integration setRecipe")));
            widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.getCenterX(), bounds.getCenterY() + 1), (Component)new TextComponent("Check console for error")));
            return widgets;
        }
        return JEIWrappedCategory.setupDisplay(result, category, display, bounds, backgroundLazy);
    }

    public static <T> List<Widget> setupDisplay(final JEIDisplaySetup.Result result, final IRecipeCategory<T> category, final JEIWrappedDisplay<T> display, final Rectangle bounds, LazyLoadedValue<IDrawable> backgroundLazy) {
        final ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        IDrawable background = category.getBackground();
        if (background != null) {
            widgets.add((Widget)Widgets.withTranslate((Widget)Widgets.wrapRenderer((Rectangle)bounds, (Renderer)JEIPluginDetector.unwrapRenderer(background)), (double)4.0, (double)4.0, (double)0.0));
        }
        widgets.add((Widget)new WidgetWithBounds(){

            public Rectangle getBounds() {
                return bounds;
            }

            public void m_6305_(PoseStack arg, int mouseX, int mouseY, float f) {
                PoseStack stack = new PoseStack();
                stack.m_85836_();
                stack.m_85850_().m_85861_().m_162210_(arg.m_85850_().m_85861_());
                stack.m_85837_((double)(bounds.x + 4), (double)(bounds.y + 4), 10.0);
                category.draw(display.getBackingRecipe(), result, stack, mouseX - bounds.x, mouseY - bounds.y);
                stack.m_85849_();
                Point mouse = new Point(mouseX, mouseY);
                if (this.containsMouse(mouse)) {
                    for (Slot slot : Widgets.walk((Iterable)widgets, listener -> listener instanceof Slot)) {
                        if (!slot.containsMouse(mouse) || !slot.isHighlightEnabled() || slot.getCurrentTooltip(mouse) == null) continue;
                        return;
                    }
                    Tooltip tooltip = this.getTooltip(TooltipContext.of((Point)mouse));
                    if (tooltip != null) {
                        tooltip.queue();
                    }
                }
            }

            @Nullable
            public Tooltip getTooltip(Point mouse) {
                List<Component> strings = category.getTooltipStrings(display.getBackingRecipe(), result, mouse.x - bounds.x - 4, mouse.y - bounds.y - 4);
                if (strings.isEmpty()) {
                    return null;
                }
                return Tooltip.create((Point)mouse, strings);
            }

            public List<? extends GuiEventListener> m_6702_() {
                return Collections.emptyList();
            }

            public boolean m_6375_(double d, double e, int i) {
                return category.handleInput(display.getBackingRecipe(), d - (double)bounds.x - 4.0, e - (double)bounds.y - 4.0, InputConstants.Type.MOUSE.m_84895_(i)) || super.m_6375_(d, e, i);
            }

            public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
                double d = PointHelper.getMouseFloatingX();
                double e = PointHelper.getMouseFloatingY();
                return category.handleInput(display.getBackingRecipe(), d - (double)bounds.x - 4.0, e - (double)bounds.y - 4.0, InputConstants.m_84827_((int)keyCode, (int)scanCode)) || super.m_7933_(keyCode, scanCode, modifiers);
            }
        });
        JEIDisplaySetup.addTo(widgets, bounds, result);
        if (result.shapelessData.shapeless) {
            Point shapelessPoint = result.shapelessData.pos;
            if (shapelessPoint != null) {
                widgets.add(Widgets.createShapelessIcon((Point)new Point(shapelessPoint.x + 9, shapelessPoint.y - 1)));
            } else {
                widgets.add(Widgets.createShapelessIcon((Rectangle)bounds));
            }
        }
        return widgets;
    }
}

