/*
 * Decompiled with CFR 0.152.
 */
package net.additions.archipelagoadditions.effect;

import java.util.Objects;
import net.additions.archipelagoadditions.config.ArchipelagoAdditionsCommonConfigs;
import net.additions.archipelagoadditions.util.ModTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import org.jetbrains.annotations.NotNull;

public class BlueOleanderEffect
extends MobEffect {
    private static final String DAMAGE_COUNT_KEY = "BlueOleanderDamageCount";
    private static final String LAST_DAMAGE_TICK_KEY = "BlueOleanderLastDamageTick";
    private static final long INTERVAL = 12000L;

    protected BlueOleanderEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6742_(@NotNull LivingEntity entity, int amplifier) {
        Mob mob;
        if (!((Boolean)ArchipelagoAdditionsCommonConfigs.DISABLE_OLEANDER_LETHALITY.get()).booleanValue() && !entity.f_19853_.m_5776_() && entity instanceof Mob && (mob = (Mob)entity).m_21023_((MobEffect)this) && mob.m_6095_().m_204039_(ModTags.EntityTypes.OLEANDER_VULNERABLE)) {
            CompoundTag data = mob.getPersistentData();
            long lastDamageTick = data.m_128454_(LAST_DAMAGE_TICK_KEY);
            long gameTime = Objects.requireNonNull(entity.f_19853_.m_142572_()).m_129921_();
            if (gameTime - lastDamageTick >= 12000L) {
                int damageCount = data.m_128451_(DAMAGE_COUNT_KEY);
                float baseDamage = 4.0f;
                float scaledDamage = (float)((double)baseDamage * Math.pow(1.5, damageCount));
                data.m_128356_(LAST_DAMAGE_TICK_KEY, gameTime);
                data.m_128405_(DAMAGE_COUNT_KEY, damageCount + 1);
                mob.m_6469_(DamageSource.f_19320_, scaledDamage);
            }
        }
        super.m_6742_(entity, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void m_6385_(@NotNull LivingEntity entity, @NotNull AttributeMap map, int amplifier) {
        super.m_6385_(entity, map, amplifier);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            CompoundTag data = mob.getPersistentData();
            data.m_128405_(DAMAGE_COUNT_KEY, 0);
            data.m_128356_(LAST_DAMAGE_TICK_KEY, (long)Objects.requireNonNull(mob.f_19853_.m_142572_()).m_129921_());
        }
    }

    public void m_6386_(@NotNull LivingEntity entity, @NotNull AttributeMap map, int amplifier) {
        super.m_6386_(entity, map, amplifier);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            CompoundTag data = mob.getPersistentData();
            data.m_128473_(DAMAGE_COUNT_KEY);
            data.m_128473_(LAST_DAMAGE_TICK_KEY);
        }
    }
}

