/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.gui;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.EnumSearchPrefix;
import com.lothrazar.storagenetwork.api.IGuiNetwork;
import com.lothrazar.storagenetwork.gui.ButtonRequest;
import com.lothrazar.storagenetwork.gui.ItemSlotNetwork;
import com.lothrazar.storagenetwork.jei.JeiHooks;
import com.lothrazar.storagenetwork.network.InsertMessage;
import com.lothrazar.storagenetwork.network.RequestMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fml.ModList;

public class NetworkWidget {
    public ItemStack stackUnderMouse = ItemStack.f_41583_;
    public List<ItemStack> stacks;
    public EditBox searchBar;
    public ButtonRequest directionBtn;
    public ButtonRequest sortBtn;
    public ButtonRequest jeiBtn;
    public ButtonRequest focusBtn;
    private int fieldHeight = 90;
    private List<ItemSlotNetwork> slots;
    private final IGuiNetwork gui;
    private long lastClick;
    private int page = 1;
    private int maxPage = 1;
    private int lines = 4;
    private final int columns = 9;

    @Deprecated
    public NetworkWidget(IGuiNetwork gui) {
        this(gui, NetworkScreenSize.NORMAL);
    }

    public NetworkWidget(IGuiNetwork gui, NetworkScreenSize size) {
        this.gui = gui;
        this.stacks = Lists.newArrayList();
        this.slots = Lists.newArrayList();
        PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage());
        this.lastClick = System.currentTimeMillis();
        switch (size) {
            case LARGE: {
                this.setLines(8);
                this.setFieldHeight(172);
                break;
            }
            case NORMAL: {
                this.setLines(4);
                this.setFieldHeight(90);
            }
        }
    }

    public void applySearchTextToSlots() {
        ArrayList stacksToDisplay;
        String searchText = this.searchBar.m_94155_();
        ArrayList arrayList = stacksToDisplay = searchText.equals("") ? Lists.newArrayList(this.stacks) : Lists.newArrayList();
        if (!searchText.equals("")) {
            for (ItemStack stack : this.stacks) {
                if (!this.doesStackMatchSearch(stack)) continue;
                stacksToDisplay.add(stack);
            }
        }
        this.sortStackWrappers(stacksToDisplay);
        this.applyScrollPaging(stacksToDisplay);
        this.rebuildItemSlots(stacksToDisplay);
    }

    public void clearSearch() {
        if (this.searchBar == null) {
            return;
        }
        this.searchBar.m_94144_("");
        if (ModList.get().isLoaded("jei") && this.gui.isJeiSearchSynced()) {
            JeiHooks.setFilterText("");
        }
    }

    private boolean doesStackMatchSearch(ItemStack stack) {
        String searchText = this.searchBar.m_94155_();
        if (searchText.startsWith(EnumSearchPrefix.MOD.getPrefix())) {
            String name = UtilTileEntity.getModNameForItem(stack.m_41720_());
            return name.toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        if (searchText.startsWith(EnumSearchPrefix.TOOLTIP.getPrefix())) {
            Minecraft mc = Minecraft.m_91087_();
            List tooltip = stack.m_41651_((Player)mc.f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL);
            List unformattedTooltip = tooltip.stream().map(Component::getString).collect(Collectors.toList());
            String tooltipString = Joiner.on((char)' ').join(unformattedTooltip).toLowerCase().trim();
            return tooltipString.contains(searchText.toLowerCase().substring(1));
        }
        if (searchText.startsWith(EnumSearchPrefix.TAG.getPrefix())) {
            ArrayList<String> joiner = new ArrayList<String>();
            for (ResourceLocation oreId : stack.m_204131_().map(tagKey -> tagKey.f_203868_()).collect(Collectors.toList())) {
                String oreName = oreId.toString();
                joiner.add(oreName);
            }
            String dictFinal = Joiner.on((char)' ').join(joiner).toLowerCase().trim();
            return dictFinal.contains(searchText.toLowerCase().substring(1));
        }
        return stack.m_41786_().getString().toLowerCase().contains(searchText.toLowerCase());
    }

    public boolean canClick() {
        return System.currentTimeMillis() > this.lastClick + 100L;
    }

    int getLines() {
        return this.lines;
    }

    int getColumns() {
        return 9;
    }

    public void setLines(int v) {
        this.lines = v;
    }

    public void applyScrollPaging(List<ItemStack> stacksToDisplay) {
        this.maxPage = stacksToDisplay.size() / this.getColumns();
        if (stacksToDisplay.size() % this.getColumns() != 0) {
            ++this.maxPage;
        }
        this.maxPage -= this.getLines() - 1;
        if (this.maxPage < 1) {
            this.maxPage = 1;
        }
        if (this.page < 1) {
            this.page = 1;
        }
        if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
    }

    public void mouseScrolled(double mouseButton) {
        if (mouseButton > 0.0 && this.page > 1) {
            --this.page;
        }
        if (mouseButton < 0.0 && this.page < this.maxPage) {
            ++this.page;
        }
    }

    public void rebuildItemSlots(List<ItemStack> stacksToDisplay) {
        this.slots = Lists.newArrayList();
        int index = (this.page - 1) * this.getColumns();
        for (int row = 0; row < this.getLines(); ++row) {
            for (int col = 0; col < this.getColumns() && index < stacksToDisplay.size(); ++col) {
                int in = index++;
                this.slots.add(new ItemSlotNetwork(this.gui, stacksToDisplay.get(in), this.gui.getGuiLeft() + 8 + col * 18, this.gui.getGuiTopFixJei() + 10 + row * 18, stacksToDisplay.get(in).m_41613_(), this.gui.getGuiLeft(), this.gui.getGuiTopFixJei(), true));
            }
        }
    }

    public boolean inSearchBar(double mouseX, double mouseY) {
        return this.gui.isInRegion(this.searchBar.f_93620_ - this.gui.getGuiLeft(), this.searchBar.f_93621_ - this.gui.getGuiTopFixJei(), this.searchBar.m_5711_(), this.searchBar.m_93694_(), mouseX, mouseY);
    }

    public void initSearchbar() {
        this.searchBar.m_94182_(false);
        this.searchBar.m_94194_(true);
        this.searchBar.m_94202_(0xFFFFFF);
        if (ModList.get().isLoaded("jei")) {
            this.initJei();
        }
    }

    private void initJei() {
        try {
            if (this.gui != null && this.searchBar != null && this.gui.isJeiSearchSynced()) {
                this.searchBar.m_94144_(JeiHooks.getFilterText());
            }
        }
        catch (Exception e) {
            StorageNetworkMod.LOGGER.error("Search bar error ", (Throwable)e);
        }
    }

    public void syncTextToJei() {
        if (ModList.get().isLoaded("jei") && this.gui.isJeiSearchSynced()) {
            JeiHooks.setFilterText(this.searchBar.m_94155_());
        }
    }

    public void drawGuiContainerForegroundLayer(PoseStack ms, int mouseX, int mouseY, Font font) {
        for (ItemSlotNetwork slot : this.slots) {
            if (slot == null || !slot.isMouseOverSlot(mouseX, mouseY)) continue;
            slot.drawTooltip(ms, mouseX, mouseY);
            return;
        }
        TranslatableComponent tooltip = null;
        if (this.directionBtn != null && this.directionBtn.m_5953_(mouseX, mouseY)) {
            tooltip = new TranslatableComponent("gui.storagenetwork.sort");
        } else if (this.sortBtn != null && this.sortBtn.m_5953_(mouseX, mouseY)) {
            tooltip = new TranslatableComponent("gui.storagenetwork.req.tooltip_" + this.gui.getSort().name().toLowerCase());
        } else if (this.focusBtn != null && this.focusBtn.m_5953_(mouseX, mouseY)) {
            tooltip = new TranslatableComponent("gui.storagenetwork.autofocus.tooltip." + this.gui.getAutoFocus());
        } else if (ModList.get().isLoaded("jei") && this.jeiBtn != null && this.jeiBtn.m_5953_(mouseX, mouseY)) {
            tooltip = new TranslatableComponent(this.gui.isJeiSearchSynced() ? "gui.storagenetwork.fil.tooltip_jei_on" : "gui.storagenetwork.fil.tooltip_jei_off");
        } else if (this.inSearchBar(mouseX, mouseY)) {
            if (!Screen.m_96638_()) {
                tooltip = new TranslatableComponent("gui.storagenetwork.shift");
            } else {
                ArrayList lis = Lists.newArrayList();
                lis.add(new TranslatableComponent("gui.storagenetwork.fil.tooltip_mod"));
                lis.add(new TranslatableComponent("gui.storagenetwork.fil.tooltip_tooltip"));
                lis.add(new TranslatableComponent("gui.storagenetwork.fil.tooltip_tags"));
                lis.add(new TranslatableComponent("gui.storagenetwork.fil.tooltip_clear"));
                Screen screen = (Screen)this.gui;
                screen.m_169388_(ms, (List)lis, Optional.empty(), mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTopFixJei());
                return;
            }
        }
        if (tooltip != null) {
            Screen screen = (Screen)this.gui;
            screen.m_169388_(ms, (List)Lists.newArrayList((Object[])new Component[]{tooltip}), Optional.empty(), mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTopFixJei());
        }
    }

    public void renderItemSlots(PoseStack ms, int mouseX, int mouseY, Font font) {
        this.stackUnderMouse = ItemStack.f_41583_;
        for (ItemSlotNetwork slot : this.slots) {
            slot.drawSlot(ms, font, mouseX, mouseY);
            if (!slot.isMouseOverSlot(mouseX, mouseY)) continue;
            this.stackUnderMouse = slot.getStack();
        }
        if (this.slots.isEmpty()) {
            this.stackUnderMouse = ItemStack.f_41583_;
        }
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.searchBar.m_93696_() && this.searchBar.m_5534_(typedChar, keyCode)) {
            PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage(0, ItemStack.f_41583_, false, false));
            this.syncTextToJei();
            return true;
        }
        return false;
    }

    public void mouseClicked(double mouseX, double mouseY, int mouseButton) {
        LocalPlayer player;
        this.searchBar.m_94178_(false);
        if (this.inSearchBar(mouseX, mouseY)) {
            this.searchBar.m_94178_(true);
            if (mouseButton == 1) {
                this.clearSearch();
                return;
            }
        }
        if ((player = Minecraft.m_91087_().f_91074_) == null) {
            return;
        }
        ItemStack stackCarriedByMouse = player.f_36096_.m_142621_();
        if (!this.stackUnderMouse.m_41619_() && (mouseButton == 0 || mouseButton == 1) && stackCarriedByMouse.m_41619_() && this.canClick()) {
            PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage(mouseButton, this.stackUnderMouse.m_41777_(), Screen.m_96638_(), Screen.m_96639_() || Screen.m_96637_()));
            this.lastClick = System.currentTimeMillis();
        } else if (!stackCarriedByMouse.m_41619_() && this.inField((int)mouseX, (int)mouseY) && this.canClick()) {
            PacketRegistry.INSTANCE.sendToServer((Object)new InsertMessage(0, mouseButton));
            this.lastClick = System.currentTimeMillis();
        }
    }

    private boolean inField(int mouseX, int mouseY) {
        return mouseX > this.gui.getGuiLeft() + 7 && mouseX < this.gui.getGuiLeft() + 176 - 7 && mouseY > this.gui.getGuiTopFixJei() + 7 && mouseY < this.gui.getGuiTopFixJei() + this.getFieldHeight();
    }

    public void initButtons() {
        int y = this.searchBar.f_93621_ - 4;
        this.directionBtn = new ButtonRequest(this.gui.getGuiLeft() + 6, y, "", p -> {
            this.gui.setDownwards(!this.gui.getDownwards());
            this.gui.syncDataToServer();
        });
        this.directionBtn.setHeight(16);
        this.sortBtn = new ButtonRequest(this.gui.getGuiLeft() + 22, y, "", p -> {
            this.gui.setSort(this.gui.getSort().next());
            this.gui.syncDataToServer();
        });
        this.sortBtn.setHeight(16);
        if (ModList.get().isLoaded("jei")) {
            this.jeiBtn = new ButtonRequest(this.gui.getGuiLeft() + 38, y, "", p -> {
                this.gui.setJeiSearchSynced(!this.gui.isJeiSearchSynced());
                this.gui.syncDataToServer();
            });
            this.jeiBtn.setHeight(16);
        }
        this.focusBtn = new ButtonRequest(this.gui.getGuiLeft() + 166, y + 2, "", p -> {
            this.gui.setAutoFocus(!this.gui.getAutoFocus());
            this.gui.syncDataToServer();
        });
        this.focusBtn.setHeight(11);
        this.focusBtn.m_93674_(6);
    }

    public void sortStackWrappers(List<ItemStack> stacksToDisplay) {
        Collections.sort(stacksToDisplay, new Comparator<ItemStack>(){
            final int mul;
            {
                this.mul = NetworkWidget.this.gui.getDownwards() ? -1 : 1;
            }

            @Override
            public int compare(ItemStack o2, ItemStack o1) {
                switch (NetworkWidget.this.gui.getSort()) {
                    case AMOUNT: {
                        return Integer.compare(o1.m_41613_(), o2.m_41613_()) * this.mul;
                    }
                    case NAME: {
                        return o2.m_41786_().getString().compareToIgnoreCase(o1.m_41786_().getString()) * this.mul;
                    }
                    case MOD: {
                        return UtilTileEntity.getModNameForItem(o2.m_41720_()).compareToIgnoreCase(UtilTileEntity.getModNameForItem(o1.m_41720_())) * this.mul;
                    }
                }
                return 0;
            }
        });
    }

    public void render() {
        switch (this.gui.getSort()) {
            case AMOUNT: {
                this.sortBtn.setTextureId(ButtonRequest.TextureEnum.SORT_AMT);
                break;
            }
            case MOD: {
                this.sortBtn.setTextureId(ButtonRequest.TextureEnum.SORT_MOD);
                break;
            }
            case NAME: {
                this.sortBtn.setTextureId(ButtonRequest.TextureEnum.SORT_NAME);
            }
        }
        this.focusBtn.setTextureId(this.gui.getAutoFocus() ? ButtonRequest.TextureEnum.RED : ButtonRequest.TextureEnum.GREY);
        this.directionBtn.setTextureId(this.gui.getDownwards() ? ButtonRequest.TextureEnum.SORT_DOWN : ButtonRequest.TextureEnum.SORT_UP);
        if (this.jeiBtn != null && ModList.get().isLoaded("jei")) {
            this.jeiBtn.setTextureId(this.gui.isJeiSearchSynced() ? ButtonRequest.TextureEnum.JEI_GREEN : ButtonRequest.TextureEnum.JEI_RED);
        }
    }

    public int getFieldHeight() {
        return this.fieldHeight;
    }

    public void setFieldHeight(int fieldHeight) {
        this.fieldHeight = fieldHeight;
    }

    public static enum NetworkScreenSize {
        NORMAL,
        LARGE;

    }
}

