/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.block.cable.linkfilter.ContainerCableFilter;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.CapabilityConnectableLink;
import com.lothrazar.storagenetwork.network.RefreshFilterClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class CableDataMessage {
    private boolean isAllowlist;
    private final int id;
    private int value = 0;
    private ItemStack stack = ItemStack.f_41583_;

    public CableDataMessage(int id) {
        this.id = id;
    }

    public CableDataMessage(int id, int value, boolean is) {
        this(id);
        this.value = value;
        this.isAllowlist = is;
    }

    public CableDataMessage(int id, int value, ItemStack mystack) {
        this(id);
        this.value = value;
        this.stack = mystack;
    }

    public String toString() {
        return "CableDataMessage{isAllowlist=" + this.isAllowlist + ", id=" + this.id + ", value=" + this.value + ", stack=" + this.stack + "}";
    }

    public static void handle(CableDataMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            CapabilityConnectableLink link = null;
            ContainerCableFilter container = (ContainerCableFilter)player.f_36096_;
            if (container == null || container.cap == null) {
                return;
            }
            link = container.cap;
            TileMain root = UtilTileEntity.getTileMainForConnectable(link.connectable);
            CableMessageType type = CableMessageType.values()[message.id];
            switch (type) {
                case IMPORT_FILTER: {
                    link.getFilter().clear();
                    int targetSlot = 0;
                    for (ItemStack filterSuggestion : link.getStoredStacks(false)) {
                        if (link.getFilter().exactStackAlreadyInList(filterSuggestion)) continue;
                        try {
                            link.getFilter().setStackInSlot(targetSlot, filterSuggestion.m_41777_());
                            if (++targetSlot < link.getFilter().getSlots()) continue;
                        }
                        catch (Exception ex) {
                            StorageNetworkMod.LOGGER.error("Exception saving filter slot ", (Object)message);
                        }
                    }
                    PacketRegistry.INSTANCE.sendTo((Object)new RefreshFilterClientMessage(link.getFilter().getStacks()), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                    break;
                }
                case SYNC_DATA: {
                    link.setPriority(link.getPriority() + message.value);
                    link.getFilter().setIsAllowlist(message.isAllowlist);
                    if (root == null) break;
                    root.clearCache();
                    break;
                }
                case SAVE_FITLER: {
                    link.setFilter(message.value, message.stack.m_41777_());
                }
            }
            container.tile.m_6596_();
            player.f_8906_.m_141995_((Packet)container.tile.getUpdatePacket());
        });
        ctx.get().setPacketHandled(true);
    }

    public static void encode(CableDataMessage msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.id);
        buffer.writeInt(msg.value);
        buffer.writeBoolean(msg.isAllowlist);
        buffer.m_130079_(msg.stack.m_41739_(new CompoundTag()));
    }

    public static CableDataMessage decode(FriendlyByteBuf buffer) {
        CableDataMessage c = new CableDataMessage(buffer.readInt(), buffer.readInt(), buffer.readBoolean());
        c.stack = ItemStack.m_41712_((CompoundTag)buffer.m_130260_());
        return c;
    }

    public static enum CableMessageType {
        SYNC_DATA,
        IMPORT_FILTER,
        SAVE_FITLER;

    }
}

