/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SelectionListEntry<T>
extends TooltipListEntry<T> {
    private final ImmutableList<T> values;
    private final AtomicInteger index;
    private final int original;
    private final Button buttonWidget;
    private final Button resetButton;
    private final Supplier<T> defaultValue;
    private final List<AbstractWidget> widgets;
    private final Function<T, Component> nameProvider;

    @Deprecated
    @ApiStatus.Internal
    public SelectionListEntry(Component fieldName, T[] valuesArray, T value, Component resetButtonKey, Supplier<T> defaultValue, Consumer<T> saveConsumer) {
        this(fieldName, valuesArray, value, resetButtonKey, defaultValue, saveConsumer, null);
    }

    @Deprecated
    @ApiStatus.Internal
    public SelectionListEntry(Component fieldName, T[] valuesArray, T value, Component resetButtonKey, Supplier<T> defaultValue, Consumer<T> saveConsumer, Function<T, Component> nameProvider) {
        this(fieldName, valuesArray, value, resetButtonKey, defaultValue, saveConsumer, nameProvider, null);
    }

    @Deprecated
    @ApiStatus.Internal
    public SelectionListEntry(Component fieldName, T[] valuesArray, T value, Component resetButtonKey, Supplier<T> defaultValue, Consumer<T> saveConsumer, Function<T, Component> nameProvider, Supplier<Optional<Component[]>> tooltipSupplier) {
        this(fieldName, valuesArray, value, resetButtonKey, defaultValue, saveConsumer, nameProvider, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public SelectionListEntry(Component fieldName, T[] valuesArray, T value, Component resetButtonKey, Supplier<T> defaultValue, Consumer<T> saveConsumer, Function<T, Component> nameProvider, Supplier<Optional<Component[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.values = valuesArray != null ? ImmutableList.copyOf((Object[])valuesArray) : ImmutableList.of(value);
        this.defaultValue = defaultValue;
        this.index = new AtomicInteger(this.values.indexOf(value));
        this.index.compareAndSet(-1, 0);
        this.original = this.values.indexOf(value);
        this.buttonWidget = new Button(0, 0, 150, 20, NarratorChatListener.f_93310_, widget -> {
            this.index.incrementAndGet();
            this.index.compareAndSet(this.values.size(), 0);
        });
        this.resetButton = new Button(0, 0, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)resetButtonKey) + 6, 20, resetButtonKey, widget -> this.index.set(this.getDefaultIndex()));
        this.saveCallback = saveConsumer;
        this.widgets = Lists.newArrayList((Object[])new AbstractWidget[]{this.buttonWidget, this.resetButton});
        this.nameProvider = nameProvider == null ? t -> new TranslatableComponent(t instanceof Translatable ? ((Translatable)t).getKey() : t.toString()) : nameProvider;
    }

    @Override
    public boolean isEdited() {
        return super.isEdited() || !Objects.equals(this.index.get(), this.original);
    }

    @Override
    public T getValue() {
        return (T)this.values.get(this.index.get());
    }

    @Override
    public Optional<T> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    @Override
    public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        Window window = Minecraft.m_91087_().m_91268_();
        this.resetButton.f_93623_ = this.isEditable() && this.getDefaultValue().isPresent() && this.getDefaultIndex() != this.index.get();
        this.resetButton.f_93621_ = y;
        this.buttonWidget.f_93623_ = this.isEditable();
        this.buttonWidget.f_93621_ = y;
        this.buttonWidget.m_93666_(this.nameProvider.apply(this.getValue()));
        Component displayedFieldName = this.getDisplayedFieldName();
        if (Minecraft.m_91087_().f_91062_.m_92718_()) {
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, displayedFieldName.m_7532_(), (float)(window.m_85445_() - x - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)displayedFieldName)), (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.f_93620_ = x;
            this.buttonWidget.f_93620_ = x + this.resetButton.m_5711_() + 2;
        } else {
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, displayedFieldName.m_7532_(), (float)x, (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.f_93620_ = x + entryWidth - this.resetButton.m_5711_();
            this.buttonWidget.f_93620_ = x + entryWidth - 150;
        }
        this.buttonWidget.m_93674_(150 - this.resetButton.m_5711_() - 2);
        this.resetButton.m_6305_(matrices, mouseX, mouseY, delta);
        this.buttonWidget.m_6305_(matrices, mouseX, mouseY, delta);
    }

    private int getDefaultIndex() {
        return Math.max(0, this.values.indexOf(this.defaultValue.get()));
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.widgets;
    }

    @Override
    public List<? extends NarratableEntry> narratables() {
        return this.widgets;
    }

    public static interface Translatable {
        @NotNull
        public String getKey();
    }
}

