/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.forge;

import com.mojang.blaze3d.platform.InputConstants;
import kotlin.Unit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.anti_ad.mc.common.gui.NativeContext;
import org.anti_ad.mc.common.vanilla.Vanilla;
import org.anti_ad.mc.common.vanilla.VanillaUtil;
import org.anti_ad.mc.ipnext.config.Tweaks;
import org.anti_ad.mc.ipnext.event.ClientEventHandler;
import org.anti_ad.mc.ipnext.event.LockSlotsHandler;
import org.anti_ad.mc.ipnext.gui.inject.ContainerScreenEventHandler;
import org.anti_ad.mc.ipnext.gui.inject.ScreenEventHandler;
import org.anti_ad.mc.ipnext.inventory.GeneralInventoryActions;

public class ForgeEventHandler {
    @SubscribeEvent
    public void clientClick(TickEvent.ClientTickEvent clientTickEvent) {
        if (clientTickEvent.phase == TickEvent.Phase.START) {
            ClientEventHandler.INSTANCE.onTickPre();
            return;
        }
        ClientEventHandler.INSTANCE.onTick();
    }

    @SubscribeEvent
    public void joinWorld(WorldEvent.Load load) {
        if (VanillaUtil.INSTANCE.isOnClientThread()) {
            ClientEventHandler.INSTANCE.onJoinWorld();
        }
    }

    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent itemCraftedEvent) {
        ClientEventHandler.INSTANCE.onCrafted();
    }

    @SubscribeEvent
    public void onInitGuiPost(ScreenEvent.InitScreenEvent.Post post) {
        ScreenEventHandler.INSTANCE.onScreenInit(post.getScreen(), abstractButton -> {
            post.addListener((GuiEventListener)abstractButton);
            return Unit.INSTANCE;
        });
    }

    @SubscribeEvent
    public void preScreenRender(ScreenEvent.DrawScreenEvent.Pre pre) {
        ScreenEventHandler.INSTANCE.preRender(new NativeContext(pre.getPoseStack()));
    }

    @SubscribeEvent
    public void postScreenRender(ScreenEvent.DrawScreenEvent.Post post) {
        ScreenEventHandler.INSTANCE.postRender(new NativeContext(post.getPoseStack()));
    }

    @SubscribeEvent
    public void onBackgroundRender(ContainerScreenEvent.DrawBackground drawBackground) {
        ContainerScreenEventHandler.INSTANCE.onBackgroundRender(new NativeContext(drawBackground.getPoseStack()), drawBackground.getMouseX(), drawBackground.getMouseY());
    }

    @SubscribeEvent
    public void onForegroundRender(ContainerScreenEvent.DrawForeground drawForeground2) {
        ContainerScreenEventHandler.INSTANCE.onForegroundRender(new NativeContext(drawForeground2.getPoseStack()), drawForeground2.getMouseX(), drawForeground2.getMouseY());
    }

    @SubscribeEvent
    public void onGuiKeyPressedPre(ScreenEvent.KeyboardKeyPressedEvent.Pre pre) {
        if (!VanillaUtil.INSTANCE.inGame()) {
            return;
        }
        InputConstants.Key key = InputConstants.m_84827_((int)pre.getKeyCode(), (int)pre.getScanCode());
        if (Tweaks.INSTANCE.getPREVENT_CLOSE_GUI_DROP_ITEM().getBooleanValue() && (pre.getKeyCode() == 256 || Vanilla.INSTANCE.mc().f_91066_.f_92092_.isActiveAndMatches(key))) {
            GeneralInventoryActions.INSTANCE.handleCloseContainer();
        }
    }

    @SubscribeEvent
    public void onScreenClose(ScreenOpenEvent screenOpenEvent) {
        if (!VanillaUtil.INSTANCE.inGame()) {
            return;
        }
        screenOpenEvent = screenOpenEvent.getScreen();
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen != null) {
            if (screenOpenEvent == null) {
                ScreenEventHandler.INSTANCE.onScreenRemoved(screen);
                return;
            }
            if (screenOpenEvent != screen) {
                ScreenEventHandler.INSTANCE.onScreenRemoved(screen);
            }
        }
    }

    public void onOverlayLayerPre(RenderGameOverlayEvent.PreLayer preLayer) {
        if (preLayer.getOverlay() == ForgeIngameGui.HOTBAR_ELEMENT) {
            LockSlotsHandler.INSTANCE.preRenderHud(new NativeContext(preLayer.getMatrixStack()));
        }
    }

    @SubscribeEvent
    public void onOverlayLayerPost(RenderGameOverlayEvent.PostLayer postLayer) {
        if (postLayer.getOverlay() == ForgeIngameGui.HOTBAR_ELEMENT) {
            LockSlotsHandler.INSTANCE.postRenderHud(new NativeContext(postLayer.getMatrixStack()));
        }
    }
}

