/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public final class GuiUtil {
    public static final ResourceLocation IRIS_WIDGETS_TEX = new ResourceLocation("iris", "textures/gui/widgets.png");
    private static final Component ELLIPSIS = new TextComponent("...");

    private GuiUtil() {
    }

    private static Minecraft client() {
        return Minecraft.m_91087_();
    }

    public static void bindIrisWidgetsTexture() {
        RenderSystem.m_157456_((int)0, (ResourceLocation)IRIS_WIDGETS_TEX);
    }

    public static void drawButton(PoseStack poseStack, int x, int y, int width, int height, boolean hovered, boolean disabled) {
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        int vOffset = disabled ? 46 : (hovered ? 86 : 66);
        RenderSystem.m_69478_();
        RenderSystem.m_69493_();
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)vOffset, (int)halfWidth, (int)halfHeight, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + halfWidth), (int)y, (float)(200 - (width - halfWidth)), (float)vOffset, (int)(width - halfWidth), (int)halfHeight, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)(y + halfHeight), (float)0.0f, (float)(vOffset + (20 - (height - halfHeight))), (int)halfWidth, (int)(height - halfHeight), (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + halfWidth), (int)(y + halfHeight), (float)(200 - (width - halfWidth)), (float)(vOffset + (20 - (height - halfHeight))), (int)(width - halfWidth), (int)(height - halfHeight), (int)256, (int)256);
    }

    public static void drawPanel(PoseStack poseStack, int x, int y, int width, int height) {
        int borderColor = -555819298;
        int innerColor = -570425344;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + 1), (int)borderColor);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)borderColor);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + height - 1), (int)borderColor);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height - 1), (int)borderColor);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)innerColor);
    }

    public static void drawTextPanel(Font font, PoseStack poseStack, Component text, int x, int y) {
        GuiUtil.drawPanel(poseStack, x, y, font.m_92852_((FormattedText)text) + 8, 16);
        font.m_92763_(poseStack, text, (float)(x + 4), (float)(y + 4), 0xFFFFFF);
    }

    public static MutableComponent shortenText(Font font, MutableComponent text, int width) {
        if (font.m_92852_((FormattedText)text) > width) {
            return new TextComponent(font.m_92834_(text.getString(), width - font.m_92852_((FormattedText)ELLIPSIS))).m_7220_(ELLIPSIS).m_6270_(text.m_7383_());
        }
        return text;
    }

    public static MutableComponent translateOrDefault(MutableComponent defaultText, String translationDesc, Object ... format) {
        if (I18n.m_118936_((String)translationDesc)) {
            return new TranslatableComponent(translationDesc, format);
        }
        return defaultText;
    }

    public static void playButtonClickSound() {
        GuiUtil.client().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    public static class Icon {
        public static final Icon SEARCH = new Icon(0, 0, 7, 8);
        public static final Icon CLOSE = new Icon(7, 0, 5, 6);
        public static final Icon REFRESH = new Icon(12, 0, 10, 10);
        public static final Icon EXPORT = new Icon(22, 0, 7, 8);
        public static final Icon EXPORT_COLORED = new Icon(29, 0, 7, 8);
        public static final Icon IMPORT = new Icon(22, 8, 7, 8);
        public static final Icon IMPORT_COLORED = new Icon(29, 8, 7, 8);
        private final int u;
        private final int v;
        private final int width;
        private final int height;

        public Icon(int u, int v, int width, int height) {
            this.u = u;
            this.v = v;
            this.width = width;
            this.height = height;
        }

        public void draw(PoseStack poseStack, int x, int y) {
            RenderSystem.m_69478_();
            RenderSystem.m_69493_();
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)this.u, (float)this.v, (int)this.width, (int)this.height, (int)256, (int)256);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

