/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.ShaderPackOptionList;
import net.coderbot.iris.gui.element.ShaderPackSelectionList;
import net.coderbot.iris.gui.element.widget.AbstractElementWidget;
import net.coderbot.iris.gui.element.widget.CommentedElementWidget;
import net.coderbot.iris.gui.screen.HudHideable;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class ShaderPackScreen
extends Screen
implements HudHideable {
    public static final Set<Runnable> TOP_LAYER_RENDER_QUEUE = new HashSet<Runnable>();
    private static final Component SELECT_TITLE = new TranslatableComponent("pack.iris.select.title").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
    private static final Component CONFIGURE_TITLE = new TranslatableComponent("pack.iris.configure.title").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
    private static final int COMMENT_PANEL_WIDTH = 314;
    private final Screen parent;
    private final MutableComponent irisTextComponent;
    private ShaderPackSelectionList shaderPackList;
    @Nullable
    private ShaderPackOptionList shaderOptionList = null;
    @Nullable
    private NavigationController navigation = null;
    private Button screenSwitchButton;
    private Component notificationDialog = null;
    private int notificationDialogTimer = 0;
    @Nullable
    private AbstractElementWidget<?> hoveredElement = null;
    private Optional<Component> hoveredElementCommentTitle = Optional.empty();
    private List<FormattedCharSequence> hoveredElementCommentBody = new ArrayList<FormattedCharSequence>();
    private int hoveredElementCommentTimer = 0;
    private boolean optionMenuOpen = false;
    private boolean dropChanges = false;
    private static String development = "Development Environment";
    private MutableComponent developmentComponent;
    private MutableComponent updateComponent;
    private boolean guiHidden = false;
    private float guiButtonHoverTimer = 0.0f;

    public ShaderPackScreen(Screen parent) {
        super((Component)new TranslatableComponent("options.iris.shaderPackSelection.title"));
        this.parent = parent;
        Object irisName = "Oculus " + Iris.getVersion();
        if (((String)irisName).contains("-development-environment")) {
            this.developmentComponent = new TextComponent("Development Environment").m_130940_(ChatFormatting.GOLD);
            irisName = ((String)irisName).replace("-development-environment", "");
        }
        this.irisTextComponent = new TextComponent((String)irisName).m_130940_(ChatFormatting.GRAY);
        this.refreshForChangedPack();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        if (this.f_96541_.f_91073_ == null) {
            this.m_7333_(poseStack);
        } else if (!this.guiHidden) {
            this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, 1327702819, 1327702819);
        }
        if (Screen.m_96637_() && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)68)) {
            Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(option -> {
                Iris.setDebug(option);
                Minecraft.m_91087_().m_91152_((Screen)this);
            }, (Component)new TextComponent("Shader debug mode toggle"), (Component)new TextComponent("Debug mode helps investigate problems and shows shader errors. Would you like to enable it?"), (Component)new TextComponent("Yes"), (Component)new TextComponent("No")));
        }
        if (!this.guiHidden) {
            if (this.optionMenuOpen && this.shaderOptionList != null) {
                this.shaderOptionList.m_6305_(poseStack, mouseX, mouseY, delta);
            } else {
                this.shaderPackList.m_6305_(poseStack, mouseX, mouseY, delta);
            }
        }
        float previousHoverTimer = this.guiButtonHoverTimer;
        super.m_6305_(poseStack, mouseX, mouseY, delta);
        if (previousHoverTimer == this.guiButtonHoverTimer) {
            this.guiButtonHoverTimer = 0.0f;
        }
        if (!this.guiHidden) {
            ShaderPackScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)((int)((double)this.f_96543_ * 0.5)), (int)8, (int)0xFFFFFF);
            if (this.notificationDialog != null && this.notificationDialogTimer > 0) {
                ShaderPackScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.notificationDialog, (int)((int)((double)this.f_96543_ * 0.5)), (int)21, (int)0xFFFFFF);
            } else if (this.optionMenuOpen) {
                ShaderPackScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)CONFIGURE_TITLE, (int)((int)((double)this.f_96543_ * 0.5)), (int)21, (int)0xFFFFFF);
            } else {
                ShaderPackScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)SELECT_TITLE, (int)((int)((double)this.f_96543_ * 0.5)), (int)21, (int)0xFFFFFF);
            }
            if (this.isDisplayingComment()) {
                int panelHeight = Math.max(50, 18 + this.hoveredElementCommentBody.size() * 10);
                int x = (int)(0.5 * (double)this.f_96543_) - 157;
                int y = this.f_96544_ - (panelHeight + 4);
                GuiUtil.drawPanel(poseStack, x, y, 314, panelHeight);
                this.f_96547_.m_92763_(poseStack, this.hoveredElementCommentTitle.orElse(TextComponent.f_131282_), (float)(x + 4), (float)(y + 4), 0xFFFFFF);
                for (int i = 0; i < this.hoveredElementCommentBody.size(); ++i) {
                    this.f_96547_.m_92744_(poseStack, this.hoveredElementCommentBody.get(i), (float)(x + 4), (float)(y + 16 + i * 10), 0xFFFFFF);
                }
            }
        }
        for (Runnable render : TOP_LAYER_RENDER_QUEUE) {
            render.run();
        }
        TOP_LAYER_RENDER_QUEUE.clear();
        if (this.developmentComponent != null) {
            this.f_96547_.m_92763_(poseStack, (Component)this.developmentComponent, 2.0f, (float)(this.f_96544_ - 10), 0xFFFFFF);
            this.f_96547_.m_92763_(poseStack, (Component)this.irisTextComponent, 2.0f, (float)(this.f_96544_ - 20), 0xFFFFFF);
        } else if (this.updateComponent != null) {
            this.f_96547_.m_92763_(poseStack, (Component)this.updateComponent, 2.0f, (float)(this.f_96544_ - 10), 0xFFFFFF);
            this.f_96547_.m_92763_(poseStack, (Component)this.irisTextComponent, 2.0f, (float)(this.f_96544_ - 20), 0xFFFFFF);
        } else {
            this.f_96547_.m_92763_(poseStack, (Component)this.irisTextComponent, 2.0f, (float)(this.f_96544_ - 10), 0xFFFFFF);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int bottomCenter = this.f_96543_ / 2 - 50;
        int topCenter = this.f_96543_ / 2 - 76;
        boolean inWorld = this.f_96541_.f_91073_ != null;
        this.m_169411_((GuiEventListener)this.shaderPackList);
        this.m_169411_((GuiEventListener)this.shaderOptionList);
        this.shaderPackList = new ShaderPackSelectionList(this, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 58, 0, this.f_96543_);
        if (Iris.getCurrentPack().isPresent() && this.navigation != null) {
            ShaderPack currentPack = Iris.getCurrentPack().get();
            this.shaderOptionList = new ShaderPackOptionList(this, this.navigation, currentPack, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 58, 0, this.f_96543_);
            this.navigation.setActiveOptionList(this.shaderOptionList);
            this.shaderOptionList.rebuild();
        } else {
            this.optionMenuOpen = false;
            this.shaderOptionList = null;
        }
        if (inWorld) {
            this.shaderPackList.m_93488_(false);
            if (this.shaderOptionList != null) {
                this.shaderOptionList.m_93488_(false);
            }
        }
        this.m_169413_();
        if (!this.guiHidden) {
            if (this.optionMenuOpen && this.shaderOptionList != null) {
                this.m_142416_((GuiEventListener)this.shaderOptionList);
            } else {
                this.m_142416_((GuiEventListener)this.shaderPackList);
            }
            this.m_142416_((GuiEventListener)new Button(bottomCenter + 104, this.f_96544_ - 27, 100, 20, CommonComponents.f_130655_, button -> this.m_7379_()));
            this.m_142416_((GuiEventListener)new Button(bottomCenter, this.f_96544_ - 27, 100, 20, (Component)new TranslatableComponent("options.iris.apply"), button -> this.applyChanges()));
            this.m_142416_((GuiEventListener)new Button(bottomCenter - 104, this.f_96544_ - 27, 100, 20, CommonComponents.f_130656_, button -> this.dropChangesAndClose()));
            this.m_142416_((GuiEventListener)new Button(topCenter - 78, this.f_96544_ - 51, 152, 20, (Component)new TranslatableComponent("options.iris.openShaderPackFolder"), button -> this.openShaderPackFolder()));
            this.screenSwitchButton = (Button)this.m_142416_((GuiEventListener)new Button(topCenter + 78, this.f_96544_ - 51, 152, 20, (Component)new TranslatableComponent("options.iris.shaderPackList"), button -> {
                this.optionMenuOpen = !this.optionMenuOpen;
                this.applyChanges();
                this.m_7856_();
            }));
            this.refreshScreenSwitchButton();
        }
        if (inWorld) {
            TranslatableComponent showOrHide = this.guiHidden ? new TranslatableComponent("options.iris.gui.show") : new TranslatableComponent("options.iris.gui.hide");
            float endOfLastButton = (float)this.f_96543_ / 2.0f + 154.0f;
            float freeSpace = (float)this.f_96543_ - endOfLastButton;
            int x = freeSpace > 100.0f ? this.f_96543_ - 50 : (freeSpace < 20.0f ? this.f_96543_ - 20 : (int)(endOfLastButton + freeSpace / 2.0f) - 10);
            this.m_142416_((GuiEventListener)new ImageButton(x, this.f_96544_ - 39, 20, 20, this.guiHidden ? 20 : 0, 146, 20, GuiUtil.IRIS_WIDGETS_TEX, 256, 256, button -> {
                this.guiHidden = !this.guiHidden;
                this.m_7856_();
            }, (arg_0, arg_1, arg_2, arg_3) -> this.lambda$init$8((Component)showOrHide, arg_0, arg_1, arg_2, arg_3), (Component)showOrHide));
        }
        this.hoveredElement = null;
        this.hoveredElementCommentTimer = 0;
    }

    public void refreshForChangedPack() {
        if (Iris.getCurrentPack().isPresent()) {
            ShaderPack currentPack = Iris.getCurrentPack().get();
            this.navigation = new NavigationController(currentPack.getMenuContainer());
            if (this.shaderOptionList != null) {
                this.shaderOptionList.applyShaderPack(currentPack);
                this.shaderOptionList.rebuild();
            }
        } else {
            this.navigation = null;
        }
        this.refreshScreenSwitchButton();
    }

    public void refreshScreenSwitchButton() {
        if (this.screenSwitchButton != null) {
            this.screenSwitchButton.m_93666_((Component)(this.optionMenuOpen ? new TranslatableComponent("options.iris.shaderPackList") : new TranslatableComponent("options.iris.shaderPackSettings")));
            this.screenSwitchButton.f_93623_ = this.optionMenuOpen || this.shaderPackList.getTopButtonRow().shadersEnabled;
        }
    }

    public void m_96624_() {
        super.m_96624_();
        if (this.notificationDialogTimer > 0) {
            --this.notificationDialogTimer;
        }
        this.hoveredElementCommentTimer = this.hoveredElement != null ? ++this.hoveredElementCommentTimer : 0;
    }

    public boolean m_7933_(int key, int j, int k) {
        if (key == 256) {
            if (this.guiHidden) {
                this.guiHidden = false;
                this.m_7856_();
                return true;
            }
            if (this.navigation != null && this.navigation.hasHistory()) {
                this.navigation.back();
                return true;
            }
            if (this.optionMenuOpen) {
                this.optionMenuOpen = false;
                this.m_7856_();
                return true;
            }
        }
        return this.guiHidden || super.m_7933_(key, j, k);
    }

    public void m_7400_(List<Path> paths) {
        if (this.optionMenuOpen) {
            this.onOptionMenuFilesDrop(paths);
        } else {
            this.onPackListFilesDrop(paths);
        }
    }

    public void onPackListFilesDrop(List<Path> paths) {
        List packs = paths.stream().filter(Iris::isValidShaderpack).collect(Collectors.toList());
        for (Path pack : packs) {
            String fileName = pack.getFileName().toString();
            try {
                Iris.getShaderpacksDirectoryManager().copyPackIntoDirectory(fileName, pack);
            }
            catch (FileAlreadyExistsException e) {
                this.notificationDialog = new TranslatableComponent("options.iris.shaderPackSelection.copyErrorAlreadyExists", new Object[]{fileName}).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.RED});
                this.notificationDialogTimer = 100;
                this.shaderPackList.refresh();
                return;
            }
            catch (IOException e) {
                Iris.logger.warn("Error copying dragged shader pack", e);
                this.notificationDialog = new TranslatableComponent("options.iris.shaderPackSelection.copyError", new Object[]{fileName}).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.RED});
                this.notificationDialogTimer = 100;
                this.shaderPackList.refresh();
                return;
            }
        }
        this.shaderPackList.refresh();
        if (packs.size() == 0) {
            if (paths.size() == 1) {
                String fileName = paths.get(0).getFileName().toString();
                this.notificationDialog = new TranslatableComponent("options.iris.shaderPackSelection.failedAddSingle", new Object[]{fileName}).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.RED});
            } else {
                this.notificationDialog = new TranslatableComponent("options.iris.shaderPackSelection.failedAdd").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.RED});
            }
        } else if (packs.size() == 1) {
            String packName = ((Path)packs.get(0)).getFileName().toString();
            this.notificationDialog = new TranslatableComponent("options.iris.shaderPackSelection.addedPack", new Object[]{packName}).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.YELLOW});
            this.shaderPackList.select(packName);
        } else {
            this.notificationDialog = new TranslatableComponent("options.iris.shaderPackSelection.addedPacks", new Object[]{packs.size()}).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.YELLOW});
        }
        this.notificationDialogTimer = 100;
    }

    public void displayNotification(Component component) {
        this.notificationDialog = component;
        this.notificationDialogTimer = 100;
    }

    public void onOptionMenuFilesDrop(List<Path> paths) {
        if (paths.size() != 1) {
            this.notificationDialog = new TranslatableComponent("options.iris.shaderPackOptions.tooManyFiles").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.RED});
            this.notificationDialogTimer = 100;
            return;
        }
        this.importPackOptions(paths.get(0));
    }

    public void importPackOptions(Path settingFile) {
        try (InputStream in = Files.newInputStream(settingFile, new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(in);
            Iris.queueShaderPackOptionsFromProperties(properties);
            this.notificationDialog = new TranslatableComponent("options.iris.shaderPackOptions.importedSettings", new Object[]{settingFile.getFileName().toString()}).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.YELLOW});
            this.notificationDialogTimer = 100;
            if (this.navigation != null) {
                this.navigation.refresh();
            }
        }
        catch (Exception e) {
            Iris.logger.error("Error importing shader settings file \"" + settingFile.toString() + "\"", e);
            this.notificationDialog = new TranslatableComponent("options.iris.shaderPackOptions.failedImport", new Object[]{settingFile.getFileName().toString()}).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.RED});
            this.notificationDialogTimer = 100;
        }
    }

    public void m_7379_() {
        if (!this.dropChanges) {
            this.applyChanges();
        } else {
            this.discardChanges();
        }
        this.f_96541_.m_91152_(this.parent);
    }

    private void dropChangesAndClose() {
        this.dropChanges = true;
        this.m_7379_();
    }

    public void applyChanges() {
        ShaderPackSelectionList.BaseEntry base = (ShaderPackSelectionList.BaseEntry)this.shaderPackList.m_93511_();
        if (!(base instanceof ShaderPackSelectionList.ShaderPackEntry)) {
            return;
        }
        ShaderPackSelectionList.ShaderPackEntry entry = (ShaderPackSelectionList.ShaderPackEntry)base;
        this.shaderPackList.setApplied(entry);
        String name = entry.getPackName();
        if (!name.equals(Iris.getCurrentPackName())) {
            Iris.clearShaderPackOptionQueue();
        }
        boolean enabled = this.shaderPackList.getTopButtonRow().shadersEnabled;
        String previousPackName = Iris.getIrisConfig().getShaderPackName().orElse(null);
        boolean previousShadersEnabled = Iris.getIrisConfig().areShadersEnabled();
        if (!name.equals(previousPackName) || enabled != previousShadersEnabled || !Iris.getShaderPackOptionQueue().isEmpty() || Iris.shouldResetShaderPackOptionsOnNextReload()) {
            Iris.getIrisConfig().setShaderPackName(name);
            IrisApi.getInstance().getConfig().setShadersEnabledAndApply(enabled);
        }
        this.refreshForChangedPack();
    }

    private void discardChanges() {
        Iris.clearShaderPackOptionQueue();
    }

    private void openShaderPackFolder() {
        CompletableFuture.runAsync(() -> Util.m_137581_().m_137648_(Iris.getShaderpacksDirectoryManager().getDirectoryUri()));
    }

    public void setElementHoveredStatus(AbstractElementWidget<?> widget, boolean hovered) {
        if (hovered && widget != this.hoveredElement) {
            this.hoveredElement = widget;
            if (widget instanceof CommentedElementWidget) {
                this.hoveredElementCommentTitle = ((CommentedElementWidget)widget).getCommentTitle();
                Optional<Component> commentBody = ((CommentedElementWidget)widget).getCommentBody();
                if (!commentBody.isPresent()) {
                    this.hoveredElementCommentBody.clear();
                } else {
                    String rawCommentBody = commentBody.get().getString();
                    if (rawCommentBody.endsWith(".")) {
                        rawCommentBody = rawCommentBody.substring(0, rawCommentBody.length() - 1);
                    }
                    List splitByPeriods = Arrays.stream(rawCommentBody.split("\\. [ ]*")).map(TextComponent::new).collect(Collectors.toList());
                    this.hoveredElementCommentBody = new ArrayList<FormattedCharSequence>();
                    for (MutableComponent text : splitByPeriods) {
                        this.hoveredElementCommentBody.addAll(this.f_96547_.m_92923_((FormattedText)text, 306));
                    }
                }
            } else {
                this.hoveredElementCommentTitle = Optional.empty();
                this.hoveredElementCommentBody.clear();
            }
            this.hoveredElementCommentTimer = 0;
        } else if (!hovered && widget == this.hoveredElement) {
            this.hoveredElement = null;
            this.hoveredElementCommentTitle = Optional.empty();
            this.hoveredElementCommentBody.clear();
            this.hoveredElementCommentTimer = 0;
        }
    }

    public boolean isDisplayingComment() {
        return this.hoveredElementCommentTimer > 20 && this.hoveredElementCommentTitle.isPresent() && !this.hoveredElementCommentBody.isEmpty();
    }

    private /* synthetic */ void lambda$init$8(Component showOrHide, Button button, PoseStack poseStack, int i, int j) {
        this.guiButtonHoverTimer += this.f_96541_.m_91297_();
        if (this.guiButtonHoverTimer >= 10.0f) {
            TOP_LAYER_RENDER_QUEUE.add(() -> this.m_96602_(poseStack, showOrHide, i, j));
        }
    }
}

