/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import java.util.Locale;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import net.coderbot.iris.gl.uniform.FloatSupplier;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BiomeParameters {
    private static final Minecraft client = Minecraft.m_91087_();

    public static void addBiomeUniforms(UniformHolder uniforms) {
        uniforms.uniform1i(UniformUpdateFrequency.PER_TICK, "biome", BiomeParameters.playerI(player -> BuiltinRegistries.f_123865_.m_7447_((Object)((Biome)player.f_19853_.m_204166_(player.m_142538_()).m_203334_())))).uniform1i(UniformUpdateFrequency.PER_TICK, "biome_category", BiomeParameters.playerI(player -> Biome.m_204183_((Holder)player.f_19853_.m_204166_(player.m_142538_())).ordinal())).uniform1i(UniformUpdateFrequency.PER_TICK, "biome_precipitation", BiomeParameters.playerI(player -> {
            Biome.Precipitation precipitation = ((Biome)player.f_19853_.m_204166_(player.m_142538_()).m_203334_()).m_47530_();
            switch (precipitation) {
                case NONE: {
                    return 0;
                }
                case RAIN: {
                    return 1;
                }
                case SNOW: {
                    return 2;
                }
            }
            throw new IllegalStateException("Unknown precipitation type:" + precipitation);
        })).uniform1f(UniformUpdateFrequency.PER_TICK, "rainfall", BiomeParameters.playerF(player -> ((Biome)player.f_19853_.m_204166_(player.m_142538_()).m_203334_()).m_47548_())).uniform1f(UniformUpdateFrequency.PER_TICK, "temperature", BiomeParameters.playerF(player -> ((Biome)player.f_19853_.m_204166_(player.m_142538_()).m_203334_()).m_47554_())).uniform1i(UniformUpdateFrequency.ONCE, "PPT_NONE", () -> 0).uniform1i(UniformUpdateFrequency.ONCE, "PPT_RAIN", () -> 1).uniform1i(UniformUpdateFrequency.ONCE, "PPT_SNOW", () -> 2);
        BiomeParameters.addBiomes(uniforms);
        BiomeParameters.addCategories(uniforms);
    }

    public static void addBiomes(UniformHolder uniforms) {
        for (Biome biome : BuiltinRegistries.f_123865_) {
            ResourceLocation id = BuiltinRegistries.f_123865_.m_7981_((Object)biome);
            if (id == null || !id.m_135827_().equals("minecraft")) continue;
            int rawId = BuiltinRegistries.f_123865_.m_7447_((Object)biome);
            uniforms.uniform1i(UniformUpdateFrequency.ONCE, "BIOME_" + id.m_135815_().toUpperCase(Locale.ROOT), () -> rawId);
        }
    }

    public static void addCategories(UniformHolder uniforms) {
        Biome.BiomeCategory[] categories = Biome.BiomeCategory.values();
        for (int i = 0; i < categories.length; ++i) {
            int finalI = i;
            uniforms.uniform1i(UniformUpdateFrequency.ONCE, "CAT_" + categories[i].m_47645_().toUpperCase(Locale.ROOT), () -> finalI);
        }
    }

    static IntSupplier playerI(ToIntFunction<LocalPlayer> function) {
        return () -> {
            LocalPlayer player = BiomeParameters.client.f_91074_;
            if (player == null) {
                return 0;
            }
            return function.applyAsInt(player);
        };
    }

    static FloatSupplier playerF(ToFloatFunction<LocalPlayer> function) {
        return () -> {
            LocalPlayer player = BiomeParameters.client.f_91074_;
            if (player == null) {
                return 0.0f;
            }
            return function.applyAsFloat(player);
        };
    }

    @FunctionalInterface
    public static interface ToFloatFunction<T> {
        public float applyAsFloat(T var1);
    }
}

