/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.InventoryUtils;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ClientOnlyInventoryControls
implements InventoryControls {
    @Override
    public boolean singleTransfer(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        AbstractContainerMenu menu = screen.m_6262_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        if (!clickedSlot.m_8010_((Player)player)) {
            return false;
        }
        ItemStack targetStack = clickedSlot.m_7993_().m_41777_();
        if (targetStack.m_41613_() == 1) {
            this.slotClick(menu, clickedSlot, 0, ClickType.QUICK_MOVE);
            return true;
        }
        Slot fallbackSlot = null;
        for (Slot slot : menu.f_38839_) {
            ItemStack stack = slot.m_7993_();
            if (slot == clickedSlot || !slot.m_5857_(targetStack) || InventoryUtils.isSameInventory(clickedSlot, slot) || stack.m_41613_() >= Math.min(slot.m_6641_(), slot.m_5866_(stack))) continue;
            if (ItemStack.m_41758_((ItemStack)targetStack, (ItemStack)stack)) {
                this.slotClick(menu, clickedSlot, 1, ClickType.PICKUP);
                this.slotClick(menu, slot, 1, ClickType.PICKUP);
                this.slotClick(menu, clickedSlot, 0, ClickType.PICKUP);
                return true;
            }
            if (slot.m_6657_() || fallbackSlot != null) continue;
            fallbackSlot = slot;
        }
        if (fallbackSlot != null) {
            this.slotClick(menu, clickedSlot, 1, ClickType.PICKUP);
            this.slotClick(menu, fallbackSlot, 1, ClickType.PICKUP);
            this.slotClick(menu, clickedSlot, 0, ClickType.PICKUP);
            return true;
        }
        return false;
    }

    @Override
    public boolean bulkTransferByType(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        ItemStack targetStack = clickedSlot.m_7993_().m_41777_();
        AbstractContainerMenu menu = screen.m_6262_();
        ArrayList<Slot> transferSlots = new ArrayList<Slot>();
        transferSlots.add(clickedSlot);
        for (Slot slot : menu.f_38839_) {
            ItemStack stack;
            if (slot == clickedSlot || !InventoryUtils.isSameInventory(slot, clickedSlot) || !ItemStack.m_41758_((ItemStack)targetStack, (ItemStack)(stack = slot.m_7993_()))) continue;
            transferSlots.add(slot);
        }
        for (Slot transferSlot : transferSlots) {
            this.slotClick(menu, transferSlot, 0, ClickType.QUICK_MOVE);
        }
        return true;
    }

    @Override
    public boolean bulkTransferAll(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        if (!clickedSlot.m_6657_() && !InventoryEssentialsConfig.getActive().allowBulkTransferAllOnEmptySlot) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        AbstractContainerMenu menu = screen.m_6262_();
        boolean isProbablyMovingToPlayerInventory = false;
        if (!(clickedSlot.f_40218_ instanceof Inventory)) {
            isProbablyMovingToPlayerInventory = InventoryUtils.containerContainsPlayerInventory(menu);
        }
        boolean movedAny = false;
        if (isProbablyMovingToPlayerInventory) {
            ArrayDeque<Slot> emptySlots = new ArrayDeque<Slot>();
            ArrayList<Slot> nonEmptySlots = new ArrayList<Slot>();
            for (Slot slot : menu.f_38839_) {
                if (InventoryUtils.isSameInventory(slot, clickedSlot) || !(slot.f_40218_ instanceof Inventory)) continue;
                if (slot.m_6657_()) {
                    nonEmptySlots.add(slot);
                    continue;
                }
                if (Inventory.m_36045_((int)slot.m_150661_())) continue;
                emptySlots.add(slot);
            }
            for (Slot slot : menu.f_38839_) {
                if (!slot.m_8010_((Player)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true) || !this.bulkTransferPreferInventory(menu, player.m_150109_(), emptySlots, nonEmptySlots, slot)) continue;
                movedAny = true;
            }
        } else {
            for (Slot slot : menu.f_38839_) {
                if (!slot.m_8010_((Player)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                this.slotClick(menu, slot, 0, ClickType.QUICK_MOVE);
                movedAny = true;
            }
        }
        return movedAny;
    }

    private boolean bulkTransferPreferInventory(AbstractContainerMenu menu, Inventory inventory, Deque<Slot> emptySlots, List<Slot> nonEmptySlots, Slot slot) {
        ItemStack targetStack = slot.m_7993_();
        if (targetStack.m_41619_()) {
            return false;
        }
        this.slotClick(menu, slot, 0, ClickType.PICKUP);
        for (Slot nonEmptySlot : nonEmptySlots) {
            boolean hasSpaceLeft;
            ItemStack stack = slot.m_7993_();
            if (!ItemStack.m_41758_((ItemStack)targetStack, (ItemStack)stack)) continue;
            boolean bl = hasSpaceLeft = stack.m_41613_() < Math.min(slot.m_6641_(), slot.m_5866_(stack));
            if (!hasSpaceLeft) continue;
            this.slotClick(menu, nonEmptySlot, 0, ClickType.PICKUP);
            ItemStack mouseItem = menu.m_142621_();
            if (!mouseItem.m_41619_()) continue;
            return true;
        }
        Iterator<Slot> iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            ItemStack mouseItem;
            Slot emptySlot = iterator.next();
            this.slotClick(menu, emptySlot, 0, ClickType.PICKUP);
            if (emptySlot.m_6657_()) {
                nonEmptySlots.add(emptySlot);
                iterator.remove();
            }
            if (!(mouseItem = menu.m_142621_()).m_41619_()) continue;
            return true;
        }
        ItemStack mouseItem = menu.m_142621_();
        if (!mouseItem.m_41619_()) {
            this.slotClick(menu, slot, 0, ClickType.PICKUP);
        }
        return false;
    }

    @Override
    public void dragTransfer(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        this.slotClick(screen.m_6262_(), clickedSlot, 0, ClickType.QUICK_MOVE);
    }

    private void slotClick(AbstractContainerMenu menu, Slot slot, int mouseButton, ClickType clickType) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
        if (player != null && gameMode != null && slot.f_40219_ >= 0 && slot.f_40219_ < menu.f_38839_.size()) {
            gameMode.m_171799_(menu.f_38840_, slot.f_40219_, mouseButton, clickType, (Player)player);
        }
    }

    @Override
    public boolean dropByType(AbstractContainerScreen<?> screen, Slot hoverSlot) {
        ItemStack targetStack = hoverSlot.m_7993_().m_41777_();
        AbstractContainerMenu menu = screen.m_6262_();
        ArrayList<Slot> transferSlots = new ArrayList<Slot>();
        transferSlots.add(hoverSlot);
        for (Slot slot : menu.f_38839_) {
            ItemStack stack;
            if (slot == hoverSlot || !InventoryUtils.isSameInventory(slot, hoverSlot) || !ItemStack.m_41758_((ItemStack)targetStack, (ItemStack)(stack = slot.m_7993_()))) continue;
            transferSlots.add(slot);
        }
        for (Slot transferSlot : transferSlots) {
            this.slotClick(menu, transferSlot, 1, ClickType.THROW);
        }
        return true;
    }
}

