/*
 * Decompiled with CFR 0.152.
 */
package nordmods.iobvariantloader.config;

import com.GACMD.isleofberk.config.util.ConfigHelper;
import net.minecraftforge.common.ForgeConfigSpec;

public class VLConfig {
    public ConfigHelper.ConfigValueListener<Double> inheritanceChance;
    public ConfigHelper.ConfigValueListener<Boolean> assignEggVariantOnBreeding;
    public ConfigHelper.ConfigValueListener<Boolean> assignEggVariantOnPlaced;
    public ConfigHelper.ConfigValueListener<Boolean> logDragonVariantSpawns;
    public ConfigHelper.ConfigValueListener<Boolean> logHitboxRedirects;
    public ConfigHelper.ConfigValueListener<Boolean> logSoundRedirects;
    public ConfigHelper.ConfigValueListener<Boolean> logExtras;

    public VLConfig(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
        builder.push("Inheritance Chance");
        this.inheritanceChance = subscriber.subscribe((ForgeConfigSpec.ConfigValue)builder.comment("Defines the chance of dragon inheriting variant of their parents. 1 means variant will always be the same as their parents one").defineInRange("inheritance_chance", 0.7, 0.0, 1.0));
        builder.pop();
        builder.push("Assign Egg Variant on Breeding");
        this.assignEggVariantOnBreeding = subscriber.subscribe((ForgeConfigSpec.ConfigValue)builder.comment("Enables variant assignment on breeding. If false, all eggs always will have no variant assigned during breeding").define("assign_egg_variant_on_breeding", true));
        builder.pop();
        builder.push("Assign Egg Variant on Placed");
        this.assignEggVariantOnPlaced = subscriber.subscribe((ForgeConfigSpec.ConfigValue)builder.comment("Enables variant assignment when egg is placed and has empty or invalid variant tag. If false, all eggs always will have no variant assigned when placed").define("assign_egg_variant_on_placed", false));
        builder.pop();
        builder.push("Log Variant Spawns");
        this.logDragonVariantSpawns = subscriber.subscribe((ForgeConfigSpec.ConfigValue)builder.comment("Logs any added variant spawn in console for easier debugging").define("log_variant_spawns", false));
        builder.pop();
        builder.push("Log Hitbox Redirects");
        this.logHitboxRedirects = subscriber.subscribe((ForgeConfigSpec.ConfigValue)builder.comment("Logs any added hitbox redirects in console for easier debugging").define("log_hitbox_redirects", false));
        builder.pop();
        builder.push("Log Sound Redirects");
        this.logSoundRedirects = subscriber.subscribe((ForgeConfigSpec.ConfigValue)builder.comment("Logs any added sound redirects in console for easier debugging").define("log_sound_redirects", false));
        builder.pop();
        builder.push("Log Extras");
        this.logExtras = subscriber.subscribe((ForgeConfigSpec.ConfigValue)builder.comment("Logs any added extras in console for easier debugging").define("log_extras", false));
        builder.pop();
    }
}

